/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab;

import java.util.List;
import org.eclipse.swt.graphics.GC;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.tab.SilenceCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;

public class Caret {
    private Tablature tablature;
    private SongManager songManager;
    private SongCoords songCoords;
    private SongTrackCoords selectedTrack;
    private MeasureCoords selectedMeasure;
    private MeasureComponent selectedComponent;
    private Duration selectedDuration;
    private int posX;
    private int posY;
    private long position;
    private int string;
    private boolean changes;

    public Caret(Tablature tablature, SongManager songManager, SongCoords songCoords) {
        this.tablature = tablature;
        this.songManager = songManager;
        this.songCoords = songCoords;
        this.selectedDuration = new Duration(4);
        this.string = 1;
        this.changes = false;
    }

    private void setSelectedMeasureCoords(MeasureCoords measureCoords) {
        if (this.selectedMeasure != null) {
            this.selectedMeasure.setCaret(null);
        }
        this.selectedMeasure = measureCoords;
        if (this.selectedMeasure != null) {
            this.selectedMeasure.setCaret(this);
        }
    }

    public synchronized void update() {
        long l = this.selectedTrack != null ? this.selectedTrack.getTrack().getNumber() : 1L;
        this.update(l, this.position, this.string);
    }

    public synchronized void update(long l) {
        this.update(l, this.position, this.string);
    }

    public synchronized void update(long l, long l2, int n) {
        l2 = this.songManager.getPlayer().isRunning() ? this.songManager.getPlayer().getTickPosition() : l2;
        SongTrackCoords songTrackCoords = this.songCoords.getTrack(l);
        if (songTrackCoords == null) {
            songTrackCoords = this.songCoords.getFirstTrack();
        }
        if (songTrackCoords != null) {
            MeasureCoords measureCoords = songTrackCoords.getMeasureCoords(l2);
            if (measureCoords == null) {
                measureCoords = songTrackCoords.getFirstMeasure();
            }
            if (measureCoords != null) {
                MeasureComponent measureComponent = measureCoords.getComponentOrSilence(l2, n);
                if (measureComponent == null) {
                    measureComponent = measureCoords.getComponent(l2);
                }
                if (measureComponent == null) {
                    measureComponent = measureCoords.getFirstComponent();
                }
                this.moveTo(songTrackCoords, measureCoords, measureComponent, n);
            }
        }
    }

    public synchronized void goToTickPosition() {
        if (!this.songManager.isAtPosition(this.selectedMeasure.getMeasure().getHeader(), this.songManager.getPlayer().getTickPosition())) {
            this.update(this.selectedTrack.getTrack().getNumber(), this.songManager.getPlayer().getTickPosition(), this.string);
            this.setChanges(true);
        }
    }

    public void paintCaret(GC gC, int n, int n2) {
        if (this.selectedMeasure != null && this.selectedComponent != null) {
            long l = this.selectedComponent.getStart();
            this.posX = n + TablatureUtil.getStartPosition(this.selectedMeasure.getMeasure(), l, this.selectedMeasure.getQuarterSpan()) + this.selectedComponent.getSpan() + 4;
            this.posY = n2 + this.string * this.tablature.getViewLayout().getStringSpan() - 7;
            gC.drawRectangle(this.posX, this.posY, 13, 15);
        }
    }

    public void setStringNumber(int n) {
        this.string = n;
    }

    public boolean moveRight() {
        if (this.selectedComponent != null) {
            MeasureComponent measureComponent = this.selectedMeasure.getNextComponent(this.selectedComponent);
            if (measureComponent != null) {
                this.selectedComponent = measureComponent;
            } else {
                MeasureCoords measureCoords = this.selectedTrack.getNextMeasure(this.selectedMeasure);
                if (measureCoords == null) {
                    return false;
                }
                this.setSelectedMeasureCoords(measureCoords);
                this.selectedComponent = this.selectedMeasure.getFirstComponent();
            }
            this.updatePosition();
            this.updateDuration();
            this.checkString();
            this.setChanges(true);
            this.checkTransport();
        }
        return true;
    }

    public void moveLeft() {
        if (this.selectedComponent != null) {
            MeasureComponent measureComponent = this.selectedMeasure.getPreviousComponent(this.selectedComponent);
            if (measureComponent != null) {
                this.selectedComponent = measureComponent;
            } else {
                MeasureCoords measureCoords = this.selectedTrack.getPrevMeasure(this.selectedMeasure);
                if (measureCoords != null) {
                    this.setSelectedMeasureCoords(measureCoords);
                    this.selectedComponent = this.selectedMeasure.getLastComponent();
                }
            }
            this.updatePosition();
            this.updateDuration();
            this.checkString();
            this.setChanges(true);
            this.checkTransport();
        }
    }

    private void updateDuration() {
        if (this.selectedComponent != null) {
            boolean bl = false;
            for (MeasureComponent measureComponent : this.getMeasureCoords().getComponentsBeforeEnd(this.getSelectedComponent().getStart())) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                bl = true;
                break;
            }
            if (bl) {
                if (this.selectedComponent instanceof SilenceCoords) {
                    long l = this.selectedComponent.getDuration().getTime();
                    MeasureComponent measureComponent = this.getMeasureCoords().getNextComponent(this.selectedComponent);
                    while (measureComponent != null && measureComponent instanceof SilenceCoords) {
                        l += measureComponent.getDuration().getTime();
                        measureComponent = this.getMeasureCoords().getNextComponent(measureComponent);
                    }
                    if (this.selectedDuration.getTime() > l) {
                        this.selectedDuration = (Duration)this.selectedComponent.getDuration().clone();
                    }
                } else {
                    this.selectedDuration = (Duration)this.selectedComponent.getDuration().clone();
                }
            }
        }
    }

    public void moveUp() {
        this.changeString(-1);
    }

    public void moveDown() {
        this.changeString(1);
    }

    private void changeString(int n) {
        int n2 = this.string + n;
        int n3 = this.selectedTrack.getTrack().getStrings().size();
        if (n2 < 1) {
            n2 = n3;
        } else if (n2 > n3) {
            n2 = 1;
        }
        this.string = n2;
    }

    public long getPosition() {
        return this.position;
    }

    public SongCoords getSongCoords() {
        return this.songCoords;
    }

    public MeasureCoords getMeasureCoords() {
        return this.selectedMeasure;
    }

    public SongTrackCoords getSongTrackCoords() {
        return this.selectedTrack;
    }

    public MeasureComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Duration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(Duration duration) {
        this.selectedDuration = duration;
    }

    public InstrumentString getSelectedString() {
        List list = this.selectedTrack.getTrack().getStrings();
        for (InstrumentString instrumentString : list) {
            if (instrumentString.getNumber() != this.string) continue;
            return instrumentString;
        }
        return null;
    }

    public void moveTo(SongTrackCoords songTrackCoords, MeasureCoords measureCoords, MeasureComponent measureComponent) {
        this.moveTo(songTrackCoords, measureCoords, measureComponent, this.string);
    }

    public void moveTo(SongTrackCoords songTrackCoords, MeasureCoords measureCoords, MeasureComponent measureComponent, int n) {
        this.selectedTrack = songTrackCoords;
        this.selectedComponent = measureComponent;
        this.string = n;
        this.setSelectedMeasureCoords(measureCoords);
        this.updatePosition();
        this.updateDuration();
        this.checkString();
        this.checkTransport();
    }

    public void changeDuration(Duration duration) {
        this.getSongCoords().getSongManager().getMeasureManager().changeDuration(this.getMeasureCoords().getMeasure(), this.getSelectedComponent().getComponent(), duration);
        this.setChanges(true);
    }

    private void updatePosition() {
        this.position = this.getSelectedComponent().getStart();
    }

    private void checkString() {
        int n = this.getSongTrackCoords().getTrack().getStrings().size();
        if (this.string > n) {
            this.string = n;
        }
    }

    private void checkTransport() {
        TuxGuitar.instance().getTransport().gotoMeasure(this.getMeasureCoords().getMeasure());
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }
}

