/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.keybindings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.keybindings.KeyBinding;
import org.herac.tuxguitar.gui.keybindings.KeyBindingReserveds;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class KeyBindingEditor {
    private Shell dialog;
    private List availableActions;
    private List actionKeyBindings;
    private Table table;
    private Button remove;
    private Button save;
    private boolean hasChanges;

    public KeyBindingEditor(List list) {
        this.availableActions = list;
        this.hasChanges = false;
        this.makeActionKeyBindings();
    }

    public void show(Shell shell) {
        this.dialog = new Shell(shell, 67680);
        this.dialog.setText(TuxGuitar.getProperty("key-bindings-editor"));
        this.dialog.setLayout((Layout)new GridLayout());
        this.initCombo((Composite)this.dialog);
        this.initTable((Composite)this.dialog);
        this.notifyAction(false);
        this.dialog.pack();
        this.dialog.open();
        int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
        this.dialog.setLocation(n, n2);
    }

    public void initCombo(Composite composite) {
        String string;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        final Combo combo = new Combo(composite2, 0);
        combo.add(TuxGuitar.getProperty("key-bindings-editor-action-select"));
        combo.select(0);
        for (int i = 0; i < this.availableActions.size(); ++i) {
            string = (String)this.availableActions.get(i);
            combo.add(this.getActionDescription(string));
        }
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        string = new Button(composite2, 8);
        string.setLayoutData((Object)gridData);
        string.setText(TuxGuitar.getProperty("add"));
        string.setEnabled(false);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter((Button)string, combo){
            final /* synthetic */ Button val$button;
            final /* synthetic */ Combo val$combo;
            {
                this.val$button = button;
                this.val$combo = combo;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.val$button.setEnabled(this.val$combo.getSelectionIndex() > 0);
            }
        });
        string.addSelectionListener((SelectionListener)new SelectionAdapter((Button)string){
            final /* synthetic */ Button val$button;
            {
                this.val$button = button;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeyBinding keyBinding;
                if (combo.getSelectionIndex() > 0 && (keyBinding = new KeySelector().select(KeyBindingEditor.this.dialog.getShell())) != null) {
                    String string = (String)KeyBindingEditor.this.availableActions.get(combo.getSelectionIndex() - 1);
                    KeyBindingEditor.this.actionKeyBindings.add(new ActionKeyBinding(string, keyBinding));
                    KeyBindingEditor.this.notifyAction(true);
                }
                combo.select(0);
                this.val$button.setEnabled(false);
            }
        });
    }

    public void initTable(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(composite2, 2048);
        this.table.setLayoutData((Object)new GridData(350, 200));
        TableColumn tableColumn = new TableColumn(this.table, 16384);
        TableColumn tableColumn2 = new TableColumn(this.table, 16384);
        tableColumn.setText(TuxGuitar.getProperty("key-bindings-editor-action-column"));
        tableColumn2.setText(TuxGuitar.getProperty("key-bindings-editor-shortcut-column"));
        tableColumn.setWidth(250);
        tableColumn2.setWidth(100);
        this.table.setHeaderVisible(true);
        this.loadTableItems();
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout(3, false));
        composite3.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        this.remove = new Button(composite3, 8);
        this.save = new Button(composite3, 8);
        Button button = new Button(composite3, 8);
        this.remove.setText(TuxGuitar.getProperty("remove"));
        this.save.setText(TuxGuitar.getProperty("save"));
        button.setText(TuxGuitar.getProperty("exit"));
        this.remove.setLayoutData((Object)gridData);
        this.save.setLayoutData((Object)gridData);
        button.setLayoutData((Object)gridData);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                KeyBindingEditor.this.notifyAction(false);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                TableItem tableItem = KeyBindingEditor.this.getSelectedItem();
                if (tableItem != null) {
                    ActionKeyBinding actionKeyBinding = (ActionKeyBinding)tableItem.getData();
                    new KeySelector(actionKeyBinding.getKeyBinding()).select(KeyBindingEditor.this.dialog.getShell());
                    KeyBindingEditor.this.notifyAction(true);
                }
            }
        });
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem tableItem = KeyBindingEditor.this.getSelectedItem();
                if (tableItem != null) {
                    ActionKeyBinding actionKeyBinding = (ActionKeyBinding)tableItem.getData();
                    KeyBindingEditor.this.actionKeyBindings.remove(actionKeyBinding);
                    KeyBindingEditor.this.notifyAction(true);
                }
            }
        });
        this.save.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getkeyBindingManager().reset(KeyBindingEditor.this.actionKeyBindingsToMap());
                TuxGuitar.instance().getkeyBindingManager().saveKeyBindings();
                KeyBindingEditor.this.removeChanges();
                KeyBindingEditor.this.notifyAction(false);
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (KeyBindingEditor.this.hasChanges && !new ConfirmDialog(KeyBindingEditor.this.table.getShell(), TuxGuitar.getProperty("key-bindings-editor-save-question")).confirm()) {
                    return;
                }
                KeyBindingEditor.this.dialog.dispose();
            }
        });
    }

    private void clearTableItems() {
        TableItem[] tableItemArray = this.table.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            tableItemArray[i].dispose();
        }
    }

    private void loadTableItems() {
        this.clearTableItems();
        for (ActionKeyBinding actionKeyBinding : this.actionKeyBindings) {
            TableItem tableItem = new TableItem(this.table, 0);
            String string = actionKeyBinding.getActionName();
            String string2 = actionKeyBinding.getKeyBinding().toString();
            tableItem.setText(new String[]{this.getActionDescription(string), string2});
            tableItem.setData((Object)actionKeyBinding);
        }
    }

    private void removeChanges() {
        this.hasChanges = false;
    }

    private void notifyAction(boolean bl) {
        if (bl) {
            this.hasChanges = true;
            this.loadTableItems();
        }
        this.remove.setEnabled(this.getSelectedItem() != null);
        this.save.setEnabled(this.hasChanges);
    }

    private TableItem getSelectedItem() {
        TableItem tableItem = null;
        int n = this.table.getSelectionIndex();
        if (n >= 0) {
            tableItem = this.table.getItem(n);
        }
        return tableItem;
    }

    private KeyBinding getKeyBinding(KeyBinding keyBinding) {
        for (ActionKeyBinding actionKeyBinding : this.actionKeyBindings) {
            if (!keyBinding.equals(actionKeyBinding.getKeyBinding())) continue;
            return actionKeyBinding.getKeyBinding();
        }
        return null;
    }

    private void remove(KeyBinding keyBinding) {
        for (ActionKeyBinding actionKeyBinding : this.actionKeyBindings) {
            if (!keyBinding.equals(actionKeyBinding.getKeyBinding())) continue;
            this.actionKeyBindings.remove(actionKeyBinding);
            break;
        }
    }

    private String getActionDescription(String string) {
        return TuxGuitar.getProperty(string + "-description");
    }

    private void makeActionKeyBindings() {
        this.actionKeyBindings = new ArrayList();
        Iterator iterator = TuxGuitar.instance().getkeyBindingManager().getKeyBindings().iterator();
        while (iterator.hasNext()) {
            KeyBinding keyBinding = (KeyBinding)((KeyBinding)iterator.next()).clone();
            Action action = TuxGuitar.instance().getkeyBindingManager().getActionForKeyBinding(keyBinding);
            if (action == null) continue;
            this.actionKeyBindings.add(new ActionKeyBinding(action.getName(), keyBinding));
        }
    }

    private Map actionKeyBindingsToMap() {
        HashMap<KeyBinding, Action> hashMap = new HashMap<KeyBinding, Action>();
        for (ActionKeyBinding actionKeyBinding : this.actionKeyBindings) {
            hashMap.put(actionKeyBinding.getKeyBinding(), TuxGuitar.instance().getAction(actionKeyBinding.getActionName()));
        }
        return hashMap;
    }

    private class ActionKeyBinding {
        private String actionName;
        private KeyBinding keyBinding;

        public ActionKeyBinding(String string, KeyBinding keyBinding) {
            this.actionName = string;
            this.keyBinding = keyBinding;
        }

        public String getActionName() {
            return this.actionName;
        }

        public KeyBinding getKeyBinding() {
            return this.keyBinding;
        }
    }

    private class KeySelector {
        private KeyBinding keyBinding;

        public KeySelector(KeyBinding keyBinding) {
            this.keyBinding = keyBinding;
        }

        public KeySelector() {
            this(null);
        }

        public KeyBinding select(Shell shell) {
            final Shell shell2 = new Shell(shell, 67680);
            shell2.setLayout((Layout)new FillLayout());
            Composite composite = new Composite((Composite)shell2, 2048);
            composite.setLayout((Layout)new FillLayout());
            Label label = new Label(composite, 0);
            label.setFont(new Font((Device)shell2.getDisplay(), "Sans", 15, 1));
            label.setText(TuxGuitar.getProperty("key-bindings-editor-push-a-key"));
            composite.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    KeyBinding keyBinding = new KeyBinding(keyEvent.keyCode, keyEvent.stateMask);
                    if (KeyBindingReserveds.isReserved(keyBinding)) {
                        String string = TuxGuitar.getProperty("key-bindings-editor-reserved-title");
                        String string2 = TuxGuitar.getProperty("key-bindings-editor-reserved-message");
                        new MessageDialog(string, string2, 0).show(shell2.getShell());
                        return;
                    }
                    KeyBinding keyBinding2 = KeyBindingEditor.this.getKeyBinding(keyBinding);
                    if (!(keyBinding2 == null || KeySelector.this.keyBinding != null && KeySelector.this.keyBinding.equals(keyBinding2))) {
                        if (!new ConfirmDialog(shell2.getShell(), TuxGuitar.getProperty("key-bindings-editor-override")).confirm()) {
                            return;
                        }
                        KeyBindingEditor.this.remove(keyBinding);
                    }
                    if (KeySelector.this.keyBinding == null) {
                        KeySelector.this.keyBinding = new KeyBinding();
                    }
                    KeySelector.this.keyBinding.setKey(keyBinding.getKey());
                    KeySelector.this.keyBinding.setMask(keyBinding.getMask());
                    shell2.dispose();
                }
            });
            shell2.pack();
            shell2.open();
            int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
            shell2.setLocation(n, n2);
            while (!shell2.isDisposed()) {
                if (shell2.getDisplay().readAndDispatch()) continue;
                shell2.getDisplay().sleep();
            }
            return this.keyBinding;
        }
    }
}

