/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;

public class PlayerToolItems
implements ItemContainer {
    public static final String NAME = "PLAYER_ITEMS";
    private static final int STATUS_STOPED = 1;
    private static final int STATUS_PAUSED = 2;
    private static final int STATUS_RUNNING = 3;
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem first;
    private ToolItem last;
    private ToolItem previous;
    private ToolItem next;
    private ToolItem stop;
    private ToolItem play;
    private int status;

    public PlayerToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }

    public void showItems() {
        this.first = new ToolItem(this.toolBar, 8);
        this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_1);
        this.first.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoFirst((TypedEvent)selectionEvent);
            }
        });
        this.previous = new ToolItem(this.toolBar, 8);
        this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_1);
        this.previous.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoPrevious((TypedEvent)selectionEvent);
            }
        });
        this.stop = new ToolItem(this.toolBar, 8);
        this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
        this.stop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().stop((TypedEvent)selectionEvent);
            }
        });
        this.play = new ToolItem(this.toolBar, 8);
        this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
        this.play.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().play((TypedEvent)selectionEvent);
            }
        });
        this.next = new ToolItem(this.toolBar, 8);
        this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_1);
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoNext((TypedEvent)selectionEvent);
            }
        });
        this.last = new ToolItem(this.toolBar, 8);
        this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_1);
        this.last.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TuxGuitar.instance().getTransport().gotoLast((TypedEvent)selectionEvent);
            }
        });
        this.status = 1;
        this.loadProperties();
    }

    public void update() {
        int n = this.status;
        this.status = this.tablatureEditor.getSongManager().getPlayer().isRunning() ? 3 : (this.tablatureEditor.getSongManager().getPlayer().isPaused() ? 2 : 1);
        if (n != this.status) {
            if (this.status == 3) {
                this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_2);
                this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_2);
                this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_2);
                this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_2);
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PAUSE);
            } else if (this.status == 2) {
                this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_2);
                this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_2);
                this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_2);
                this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_2);
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_2);
            } else if (this.status == 1) {
                this.first.setImage(SystemImages.TRANSPORT_ICON_FIRST_1);
                this.last.setImage(SystemImages.TRANSPORT_ICON_LAST_1);
                this.previous.setImage(SystemImages.TRANSPORT_ICON_PREVIOUS_1);
                this.next.setImage(SystemImages.TRANSPORT_ICON_NEXT_1);
                this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
                this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
            }
        }
    }

    public void loadProperties() {
        this.play.setToolTipText(TuxGuitar.getProperty("player.start"));
        this.stop.setToolTipText(TuxGuitar.getProperty("player.stop"));
    }
}

