/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.layout.PageViewLayout;

public class LayoutToolItems
implements ItemContainer {
    public static final String NAME = "COMPOSITION_ITEMS";
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem pageLayout;
    private ToolItem linearLayout;
    private ToolItem multitrack;
    private ToolItem scoreEnabled;

    public LayoutToolItems(TablatureEditor tablatureEditor, ToolBar toolBar) {
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }

    public void showItems() {
        this.pageLayout = new ToolItem(this.toolBar, 16);
        this.pageLayout.setImage(SystemImages.LAYOUT_PAGE);
        this.pageLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_PAGE_LAYOUT"));
        this.linearLayout = new ToolItem(this.toolBar, 16);
        this.linearLayout.setImage(SystemImages.LAYOUT_LINEAR);
        this.linearLayout.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_LINEAR_LAYOUT"));
        this.multitrack = new ToolItem(this.toolBar, 32);
        this.multitrack.setImage(SystemImages.LAYOUT_MULTITRACK);
        this.multitrack.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_MULTITRACK_VIEW"));
        this.scoreEnabled = new ToolItem(this.toolBar, 32);
        this.scoreEnabled.setImage(SystemImages.LAYOUT_SCORE);
        this.scoreEnabled.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("SET_SCORE_ENABLED"));
        this.loadProperties();
    }

    public void loadProperties() {
        this.pageLayout.setToolTipText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setToolTipText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setToolTipText(TuxGuitar.getProperty("layout.multitrack"));
        this.scoreEnabled.setToolTipText(TuxGuitar.getProperty("layout.score-enabled"));
    }

    public void update() {
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
        this.scoreEnabled.setSelection(this.tablatureEditor.getTablature().getViewLayout().isScoreEnabled());
    }
}

