/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.language.LanguageManager;

public class LanguageMenuItem
implements ItemContainer {
    private LanguageManager languageManager;
    private MenuItem languageMenuItem;
    private Menu menu;
    private MenuItem[] languages;

    public LanguageMenuItem(Shell shell, Menu menu, int n) {
        this.languageMenuItem = new MenuItem(menu, n);
        this.menu = new Menu((Decorations)shell, 4);
    }

    public void showItems() {
        this.languageManager = TuxGuitar.instance().getLanguageManager();
        String[] stringArray = this.languageManager.getLanguages();
        if (stringArray != null) {
            this.languages = new MenuItem[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.languages[i] = new MenuItem(this.menu, 32);
                this.languages[i].setData((Object)stringArray[i]);
                this.languages[i].addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("CHANGE_LANGUAGE"));
                this.languages[i].setText(stringArray[i]);
            }
            this.languageMenuItem.setMenu(this.menu);
            this.update();
        }
        this.loadProperties();
    }

    public void update() {
        if (this.languages != null) {
            String string = this.languageManager.getLanguage();
            for (int i = 0; i < this.languages.length; ++i) {
                Object object = this.languages[i].getData();
                if (!(object instanceof String)) continue;
                this.languages[i].setSelection(object.toString().equals(string));
            }
        }
    }

    public void loadProperties() {
        this.languageMenuItem.setText(TuxGuitar.getProperty("language"));
        if (this.languages != null) {
            for (int i = 0; i < this.languages.length; ++i) {
                Object object = this.languages[i].getData();
                if (!(object instanceof String)) continue;
                this.languages[i].setText(TuxGuitar.getProperty(object.toString()));
            }
        }
    }
}

