/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.fretboard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.SongTrack;

public class FretBoard
extends Composite {
    public static final int MAX_FRETS = 24;
    private static final Color COLOR_BACKGROUND = new Color((Device)TuxGuitar.instance().getDisplay(), 255, 255, 255);
    private static final Color COLOR_STRING = new Color((Device)TuxGuitar.instance().getDisplay(), 227, 217, 217);
    private TablatureEditor editor;
    private Composite toolComposite;
    private Composite fretBoardComposite;
    private Label durationLabel;
    private Combo handSelector;
    private List components;
    private int[] frets;
    private int[] strings;
    private int fretSpan;
    private int stringSpan;
    private MeasureCoords playingCache;

    public FretBoard(Composite composite, TablatureEditor tablatureEditor) {
        super(composite, 2048);
        this.setLayout((Layout)new FormLayout());
        this.editor = tablatureEditor;
        this.initToolBar();
        this.initEditor();
        this.components = new ArrayList();
        this.layout(this.getDisplay().getBounds().width, 150, 1);
    }

    private void initToolBar() {
        this.toolComposite = new Composite((Composite)this, 0);
        this.toolComposite.setLayout((Layout)new GridLayout(3, true));
        Composite composite = new Composite(this.toolComposite, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        Button button = new Button(composite, 16388);
        button.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_LEFT"));
        Button button2 = new Button(composite, 131076);
        button2.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("GO_RIGHT"));
        Composite composite2 = new Composite(this.toolComposite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Button button3 = new Button(composite2, 132);
        button3.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("DECREMENT_DURATION"));
        this.durationLabel = new Label(composite2, 2048);
        this.durationLabel.setImage(this.getDurationImage());
        Button button4 = new Button(composite2, 1028);
        button4.addSelectionListener((SelectionListener)TuxGuitar.instance().getAction("INCREMENT_DURATION"));
        this.handSelector = new Combo(this.toolComposite, 0);
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(0);
        this.handSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = FretBoard.this.handSelector.getSelectionIndex();
                if (n == 0) {
                    FretBoard.this.initFrets(10, 1);
                } else {
                    FretBoard.this.initFrets(10, 2);
                }
                FretBoard.this.fretBoardComposite.redraw();
            }
        });
    }

    private void initEditor() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 50);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoardComposite = new Composite((Composite)this, 0x20000800);
        this.fretBoardComposite.setLayoutData((Object)formData);
        this.fretBoardComposite.setBackground(COLOR_BACKGROUND);
        this.fretBoardComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                FretBoard.this.paintEditor(paintEvent.gc);
                paintEvent.gc.dispose();
            }
        });
        this.fretBoardComposite.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
                FretBoard.this.hit(mouseEvent.x, mouseEvent.y);
                FretBoard.this.afterAction();
            }
        });
    }

    private Image getDurationImage() {
        Duration duration = (Duration)this.editor.getTablature().getCaret().getDuration().clone();
        return SystemImages.getDuration(duration.getValue());
    }

    private void calculateFretSpan(int n) {
        this.fretSpan = n / 24;
        int n2 = 0;
        for (int i = 0; i < 24; ++i) {
            n2 += i * 2;
        }
        this.fretSpan += n2 / 24 + 2;
    }

    private void calculateStringSpan(int n) {
        this.stringSpan = n / 6;
    }

    private void initFrets(int n, int n2) {
        block3: {
            int n3;
            block2: {
                this.frets = new int[24];
                n3 = n;
                if (n2 != 1) break block2;
                for (int i = 0; i < this.frets.length; ++i) {
                    this.frets[i] = n3;
                    n3 += this.fretSpan - (i + 1) * 2;
                }
                break block3;
            }
            if (n2 != 2) break block3;
            for (int i = this.frets.length - 1; i >= 0; --i) {
                this.frets[i] = n3;
                n3 += this.fretSpan - i * 2;
            }
        }
    }

    private void initStrings(int n, int n2) {
        this.strings = new int[n2];
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = n + this.stringSpan * i;
        }
    }

    private void updateEditor() {
        if (this.isVisible()) {
            SongManager songManager = TuxGuitar.instance().getSongManager();
            if (songManager.getPlayer().isRunning()) {
                this.loadPlayingComponents();
            } else {
                this.loadCaretComponents();
            }
            if (this.strings.length != this.getStringCount()) {
                this.initStrings(10, this.getStringCount());
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.getClientArea().width;
            int n4 = this.getClientArea().height;
            if (n + 20 < n3 || n > n3) {
                this.layout(this.getClientArea().width, 150, this.handSelector.getSelectionIndex() + 1);
            }
            if (n2 < n4 || n2 + 10 > n4) {
                TuxGuitar.instance().showFretBoard();
            }
        }
    }

    private void loadCaretComponents() {
        this.components.clear();
        Caret caret = this.editor.getTablature().getCaret();
        MeasureCoords measureCoords = caret.getMeasureCoords();
        if (measureCoords != null) {
            this.components = measureCoords.getComponents(caret.getPosition());
        }
    }

    private void loadPlayingComponents() {
        SongManager songManager = TuxGuitar.instance().getSongManager();
        if (songManager.getPlayer().isRunning()) {
            this.components.clear();
            long l = songManager.getPlayer().getTickPosition();
            Caret caret = this.editor.getTablature().getCaret();
            SongTrack songTrack = caret.getSongTrackCoords().getTrack();
            if (this.playingCache == null || !this.playingCache.hasTrack((int)songTrack.getNumber()) || !this.playingCache.isPlaying()) {
                this.playingCache = caret.getSongTrackCoords().getMeasure(songManager.getTrackManager().getMeasureAt(songTrack, l));
            }
            if (this.playingCache != null) {
                this.components = this.playingCache.getComponentsBetween(l);
            }
        }
    }

    private void paintEditor(GC gC) {
        this.updateEditor();
        if (this.frets.length > 0 && this.strings.length > 0) {
            int n;
            gC.setBackground(this.getDisplay().getSystemColor(2));
            gC.fillRectangle(this.getClientArea());
            Image image = SystemImages.FRETBOARD_FRET_IMAGE;
            Image image2 = SystemImages.FRETBOARD_FIRST_FRET_IMAGE;
            gC.drawImage(image2, 0, 0, image2.getBounds().width, image2.getBounds().height, this.frets[0] - 5, this.strings[0] - 5, image2.getBounds().width, this.strings[this.strings.length - 1]);
            this.paintFretPoints(gC, 0);
            for (n = 1; n < this.frets.length; ++n) {
                gC.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, this.frets[n], this.strings[0] - 5, image.getBounds().width, this.strings[this.strings.length - 1]);
                this.paintFretPoints(gC, n);
            }
            for (n = 0; n < this.strings.length; ++n) {
                gC.setForeground(COLOR_STRING);
                if (n > 2) {
                    gC.setLineWidth(2);
                }
                gC.drawLine(this.frets[0], this.strings[n], this.frets[this.frets.length - 1], this.strings[n]);
            }
            gC.setForeground(this.getDisplay().getSystemColor(9));
            gC.setLineWidth(10);
            for (MeasureComponent measureComponent : this.components) {
                if (!(measureComponent instanceof NoteCoords)) continue;
                NoteCoords noteCoords = (NoteCoords)measureComponent;
                int n2 = noteCoords.getNote().getValue();
                int n3 = noteCoords.getNote().getString() - 1;
                if (n2 < 0 || n2 >= this.frets.length || n3 < 0 || n3 >= this.strings.length) continue;
                int n4 = this.frets[n2];
                if (n2 > 0) {
                    n4 -= (this.frets[n2] - this.frets[n2 - 1]) / 2;
                }
                int n5 = this.strings[n3] - 3;
                gC.drawOval(n4, n5, 5, 5);
            }
            gC.setLineWidth(1);
            gC.setForeground(this.getDisplay().getSystemColor(2));
        }
    }

    private void paintFretPoints(GC gC, int n) {
        gC.setForeground(this.getDisplay().getSystemColor(1));
        if (n + 1 < this.frets.length) {
            int n2;
            for (n2 = n + 1; n2 >= 12; n2 -= 12) {
            }
            if (n2 == 0) {
                gC.setLineWidth(10);
                int n3 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n4 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 - this.stringSpan;
                int n5 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2 + this.stringSpan;
                gC.drawOval(n3, n4 - 2, 5, 5);
                gC.drawOval(n3, n5 - 2, 5, 5);
                gC.setLineWidth(1);
            } else if (n2 == 3 || n2 == 5 || n2 == 7 || n2 == 9) {
                gC.setLineWidth(10);
                int n6 = this.frets[n] + (this.frets[n + 1] - this.frets[n]) / 2;
                int n7 = this.strings[0] + (this.strings[this.strings.length - 1] - this.strings[0]) / 2;
                gC.drawOval(n6, n7 - 2, 5, 5);
                gC.setLineWidth(1);
            }
        }
    }

    private void hit(int n, int n2) {
        int n3 = this.getFretIndex(n);
        int n4 = this.getStringIndex(n2);
        this.editor.getTablature().getCaret().setStringNumber(n4 + 1);
        if (!this.removeNote(n3, n4 + 1)) {
            this.addNote(n3, n4 + 1);
        }
    }

    private int getStringIndex(int n) {
        int n2 = -1;
        for (int i = 0; i < this.strings.length; ++i) {
            if (n2 < 0) {
                n2 = i;
                continue;
            }
            int n3 = Math.abs(n - this.strings[n2]);
            int n4 = Math.abs(n - this.strings[i]);
            if (n4 >= n3) continue;
            n2 = i;
        }
        return n2;
    }

    private int getFretIndex(int n) {
        int n2 = this.frets.length;
        if (n - 10 <= this.frets[0] && this.frets[0] < this.frets[n2 - 1]) {
            return 0;
        }
        if (n + 10 >= this.frets[0] && this.frets[0] > this.frets[n2 - 1]) {
            return 0;
        }
        for (int i = 0; i < n2; ++i) {
            if (i + 1 >= n2 || (n <= this.frets[i] || n > this.frets[i + 1]) && (n <= this.frets[i + 1] || n > this.frets[i])) continue;
            return i + 1;
        }
        return n2 - 1;
    }

    private boolean removeNote(int n, int n2) {
        for (MeasureComponent measureComponent : this.components) {
            Note note;
            if (!(measureComponent instanceof NoteCoords) || (note = ((NoteCoords)measureComponent).getNote()).getValue() != n || note.getString() != n2) continue;
            UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
            Caret caret = this.editor.getTablature().getCaret();
            SongManager songManager = TuxGuitar.instance().getSongManager();
            songManager.getMeasureManager().removeNote(caret.getMeasureCoords().getMeasure(), note);
            this.editor.getUndoManager().addEdit(undoableComponentGeneric.endUndo());
            return true;
        }
        return false;
    }

    private int getStringCount() {
        return this.editor.getTablature().getCaret().getSongTrackCoords().getTrack().getStrings().size();
    }

    private void addNote(int n, int n2) {
        UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
        Caret caret = this.editor.getTablature().getCaret();
        Duration duration = (Duration)caret.getDuration().clone();
        Note note = new Note(n, caret.getPosition(), duration, 64, n2, false, new NoteEffect());
        SongManager songManager = TuxGuitar.instance().getSongManager();
        songManager.getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(), note);
        this.editor.getUndoManager().addEdit(undoableComponentGeneric.endUndo());
        caret.getMeasureCoords().playBeat(note.getStart());
    }

    private void afterAction() {
        this.editor.getTablature().getViewLayout().fireUpdate(this.editor.getTablature().getCaret().getMeasureCoords().getMeasure().getNumber(), false);
        TuxGuitar.instance().redraw();
        TuxGuitar.instance().updateItems();
    }

    public void redraw() {
        if (!super.isDisposed()) {
            super.redraw();
            this.fretBoardComposite.redraw();
            this.durationLabel.setImage(this.getDurationImage());
        }
    }

    public void redrawPlayingMode() {
        if (!super.isDisposed()) {
            this.fretBoardComposite.redraw();
        }
    }

    public void loadProperties() {
        int n = this.handSelector.getSelectionIndex();
        this.handSelector.removeAll();
        this.handSelector.add(TuxGuitar.getProperty("fretboard.right-mode"));
        this.handSelector.add(TuxGuitar.getProperty("fretboard.left-mode"));
        this.handSelector.select(n);
        this.layout();
    }

    public int getHeight() {
        return (this.stringSpan + 1) * this.strings.length + this.stringSpan + this.toolComposite.getBounds().height;
    }

    public int getWidth() {
        return this.frets[this.frets.length - 1];
    }

    public void layout() {
        super.layout();
    }

    public void layout(int n, int n2, int n3) {
        this.calculateFretSpan(n);
        this.calculateStringSpan(n2);
        this.initFrets(10, n3);
        this.initStrings(10, this.getStringCount());
    }

    public static void disposeColors() {
        COLOR_BACKGROUND.dispose();
        COLOR_STRING.dispose();
    }
}

