/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableMoveTrackUp;
import org.herac.tuxguitar.song.models.SongTrack;

public class MoveTrackUpAction
extends Action {
    public static final String NAME = "MOVE_TRACK_UP";

    public MoveTrackUpAction(TablatureEditor tablatureEditor) {
        super(NAME, false, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableMoveTrackUp undoableMoveTrackUp = UndoableMoveTrackUp.startUndo();
        Caret caret = this.getEditor().getTablature().getCaret();
        SongTrack songTrack = caret.getSongTrackCoords().getTrack();
        if (this.getSongManager().moveTrackUp(songTrack)) {
            this.updateTablature();
            TuxGuitar.instance().getMixer().update();
            this.redraw();
            this.getEditor().getUndoManager().addEdit(undoableMoveTrackUp.endUndo(songTrack));
        }
        return true;
    }
}

