/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInfoTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInstrumentTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.SongTrack;

public class ChangeTrackPropertiesAction
extends Action {
    public static final String NAME = "CHANGE_TRACK_PROPERTIES";
    private static final int MINIMUN_WIDTH = 200;
    private static final int MINIMUN_HEIGHT = 10;
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private Shell dialog;
    private Text nameText;
    private RGBColor trackColor;
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[7];
    private Spinner stringCountSpinner;
    private Combo offsetCombo;
    private int stringCount;
    private Combo instrumentCombo;
    private Button percussionCheckBox;

    public ChangeTrackPropertiesAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        if (songTrackCoords != null) {
            this.stringCount = songTrackCoords.getTrack().getStrings().size();
            this.trackColor = (RGBColor)songTrackCoords.getTrack().getColor().clone();
            this.initTempStirngs(songTrackCoords.getTrack().getStrings());
            this.dialog = new Shell(shell, 67680);
            this.dialog.setLayout((Layout)new GridLayout());
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));
            TabFolder tabFolder = new TabFolder((Composite)this.dialog, 0);
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            tabFolder.setLayout((Layout)new FormLayout());
            Composite composite = null;
            composite = this.makeTabItem(tabFolder, TuxGuitar.getProperty("track.properties.general"));
            this.initTrackInfo(composite, songTrackCoords);
            composite = this.makeTabItem(tabFolder, TuxGuitar.getProperty("tunning"));
            this.initTunningInfo(composite, songTrackCoords);
            composite = this.makeTabItem(tabFolder, TuxGuitar.getProperty("instrument.instrument"));
            this.initInstrumentFields(composite, songTrackCoords);
            this.initButtons((Composite)this.dialog);
            tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    selectionEvent.doit = false;
                }
            });
            this.updateTunningSpinner(!songTrackCoords.getTrack().isPercussionTrack());
            this.dialog.pack();
            this.dialog.open();
            int n = shell.getBounds().x + (shell.getBounds().width - this.dialog.getSize().x) / 2;
            int n2 = shell.getBounds().y + (shell.getBounds().height - this.dialog.getSize().y) / 2;
            this.dialog.setLocation(n, n2);
            while (!this.dialog.isDisposed()) {
                if (this.dialog.getDisplay().readAndDispatch()) continue;
                this.dialog.getDisplay().sleep();
            }
        }
    }

    private Composite makeTabItem(TabFolder tabFolder, String string) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(string);
        tabItem.setControl((Control)composite);
        return composite;
    }

    private void initTrackInfo(Composite composite, SongTrackCoords songTrackCoords) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(100, 15));
        label.setText(TuxGuitar.getProperty("track.name"));
        this.nameText = new Text(composite2, 2048);
        this.nameText.setLayoutData((Object)new GridData(250, 15));
        this.nameText.setText(songTrackCoords.getTrack().getName());
        Label label2 = new Label(composite2, 0);
        label2.setText(TuxGuitar.getProperty("track.color"));
        final Button button = new Button(composite2, 8);
        this.setButtonColor(button, new Color((Device)this.dialog.getDisplay(), this.trackColor.getR(), this.trackColor.getG(), this.trackColor.getB()));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(ChangeTrackPropertiesAction.this.dialog);
                colorDialog.setRGB(ChangeTrackPropertiesAction.this.dialog.getDisplay().getSystemColor(2).getRGB());
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    ChangeTrackPropertiesAction.this.setButtonColor(button, new Color((Device)ChangeTrackPropertiesAction.this.dialog.getDisplay(), rGB));
                }
            }
        });
    }

    private void setButtonColor(Button button, Color color) {
        Image image = new Image((Device)this.dialog.getDisplay(), 25, 25);
        GC gC = new GC((Drawable)image);
        gC.setBackground(color);
        gC.fillRectangle(0, 0, 25, 25);
        gC.dispose();
        button.setImage(image);
        this.trackColor.setR(color.getRed());
        this.trackColor.setG(color.getGreen());
        this.trackColor.setB(color.getBlue());
    }

    private void initTunningInfo(Composite composite, SongTrackCoords songTrackCoords) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.initTunningData(composite2, songTrackCoords);
        this.initTunningSpinners(composite2);
    }

    private void initTunningSpinners(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(7, false));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        String[] stringArray = this.getAllValueNames();
        for (int i = 0; i < 7; ++i) {
            this.stringSpinners[i] = new TunningSpinner(composite2, 0);
            this.stringSpinners[i].setTexts(stringArray);
        }
    }

    private void initTunningData(Composite composite, SongTrackCoords songTrackCoords) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(4, true));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 0);
        label.setText(TuxGuitar.getProperty("tunning.strings"));
        this.stringCountSpinner = new Spinner(composite2, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 30;
        this.stringCountSpinner.setLayoutData((Object)gridData);
        this.stringCountSpinner.setMinimum(4);
        this.stringCountSpinner.setMaximum(7);
        this.stringCountSpinner.setSelection(this.stringCount);
        this.stringCountSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.stringCount = ChangeTrackPropertiesAction.this.stringCountSpinner.getSelection();
                ChangeTrackPropertiesAction.this.setDefaultTunning();
                ChangeTrackPropertiesAction.this.updateTunningSpinner(!ChangeTrackPropertiesAction.this.percussionCheckBox.getSelection());
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText(TuxGuitar.getProperty("tunning.offset"));
        this.offsetCombo = new Combo(composite2, 4);
        for (int i = -24; i <= 24; ++i) {
            this.offsetCombo.add(Integer.toString(i));
            if (i != songTrackCoords.getTrack().getOffset()) continue;
            this.offsetCombo.select(i - -24);
        }
    }

    private void initButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.updateTrackProperties();
                new SyncThread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            ChangeTrackPropertiesAction.this.updateTablature();
                            TuxGuitar.instance().getMixer().update();
                            ChangeTrackPropertiesAction.this.redraw();
                            ChangeTrackPropertiesAction.this.dialog.dispose();
                        }
                    }
                }).start();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChangeTrackPropertiesAction.this.dialog.dispose();
            }
        });
    }

    private void initInstrumentFields(Composite composite, SongTrackCoords songTrackCoords) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Instrument[] instrumentArray = this.getInstruments();
        SongTrack songTrack = songTrackCoords.getTrack();
        Label label = new Label(composite2, 4);
        label.setText(TuxGuitar.getProperty("instrument.instrument"));
        this.instrumentCombo = new Combo(composite2, 0);
        if (instrumentArray != null) {
            int n = instrumentArray.length;
            if (n > 128) {
                n = 128;
            }
            for (int i = 0; i < n; ++i) {
                instrumentArray[i].getName();
                this.instrumentCombo.add(instrumentArray[i].getName());
            }
            this.instrumentCombo.setText(instrumentArray[songTrack.getChannel().getInstrument()].getName());
            this.instrumentCombo.setEnabled(!songTrack.isPercussionTrack());
        } else {
            this.instrumentCombo.setEnabled(false);
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.percussionCheckBox = new Button(composite2, 32);
        this.percussionCheckBox.setText(TuxGuitar.getProperty("instrument.percussion-track"));
        this.percussionCheckBox.setLayoutData((Object)gridData);
        if (instrumentArray != null) {
            this.percussionCheckBox.setSelection(songTrack.isPercussionTrack());
            this.percussionCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ChangeTrackPropertiesAction.this.instrumentCombo.setEnabled(!ChangeTrackPropertiesAction.this.percussionCheckBox.getSelection());
                    ChangeTrackPropertiesAction.this.setDefaultTunning();
                    ChangeTrackPropertiesAction.this.updateTunningSpinner(!ChangeTrackPropertiesAction.this.percussionCheckBox.getSelection());
                }
            });
        } else {
            this.percussionCheckBox.setEnabled(false);
        }
    }

    private Instrument[] getInstruments() {
        Instrument[] instrumentArray = null;
        Soundbank soundbank = this.getEditor().getSongManager().getPlayer().getSoundbank();
        if (soundbank != null) {
            instrumentArray = soundbank.getInstruments();
        }
        return instrumentArray;
    }

    private void updateTrackProperties() {
        int n;
        SongTrackCoords songTrackCoords = this.getEditor().getTablature().getCaret().getSongTrackCoords();
        String string = this.nameText.getText();
        RGBColor rGBColor = this.trackColor;
        int n2 = 1;
        ArrayList<InstrumentString> arrayList = new ArrayList<InstrumentString>();
        for (n = this.stringCount - 1; n >= 0; --n) {
            arrayList.add(new InstrumentString(n2, this.stringSpinners[n].getSelection()));
            ++n2;
        }
        n = -24 + this.offsetCombo.getSelectionIndex();
        int n3 = this.instrumentCombo.getSelectionIndex();
        boolean bl = this.percussionCheckBox.getSelection();
        boolean bl2 = this.hasInfoChanges(songTrackCoords, string, this.trackColor, n);
        boolean bl3 = this.hasTunningChanges(songTrackCoords, arrayList);
        boolean bl4 = this.hasInstrumentChanges(songTrackCoords, n3, bl);
        if (bl2 || bl3 || bl4) {
            UndoableEdit undoableEdit;
            JoinedUndoable joinedUndoable = new JoinedUndoable();
            UndoableTrackGeneric undoableTrackGeneric = null;
            if (bl3) {
                undoableTrackGeneric = UndoableTrackGeneric.startUndo(songTrackCoords.getTrack());
            }
            if (bl2) {
                undoableEdit = null;
                if (!bl3) {
                    undoableEdit = UndoableInfoTrack.startUndo(songTrackCoords.getTrack());
                }
                this.getEditor().getSongManager().getTrackManager().changeInfo(songTrackCoords.getTrack(), string, this.trackColor, n);
                if (!bl3) {
                    joinedUndoable.addUndoableEdit(((UndoableInfoTrack)undoableEdit).endUndo(songTrackCoords.getTrack()));
                }
            }
            if (bl3) {
                this.getEditor().getSongManager().getTrackManager().changeInstrumentStrings(songTrackCoords.getTrack(), arrayList);
            }
            if (bl4) {
                undoableEdit = null;
                if (!bl3) {
                    undoableEdit = UndoableInstrumentTrack.startUndo(songTrackCoords.getTrack());
                }
                this.getEditor().getSongManager().getTrackManager().changeInstrument(songTrackCoords.getTrack(), n3, bl);
                if (!bl3) {
                    joinedUndoable.addUndoableEdit(((UndoableInstrumentTrack)undoableEdit).endUndo(songTrackCoords.getTrack()));
                }
            }
            if (bl3) {
                joinedUndoable.addUndoableEdit(undoableTrackGeneric.endUndo(songTrackCoords.getTrack()));
            }
            this.getEditor().getUndoManager().addEdit(joinedUndoable.endUndo());
        }
    }

    private boolean hasInfoChanges(SongTrackCoords songTrackCoords, String string, RGBColor rGBColor, int n) {
        if (!string.equals(songTrackCoords.getTrack().getName())) {
            return true;
        }
        if (!rGBColor.isEqual(songTrackCoords.getTrack().getColor())) {
            return true;
        }
        return n != songTrackCoords.getTrack().getOffset();
    }

    private boolean hasTunningChanges(SongTrackCoords songTrackCoords, List list) {
        List list2 = songTrackCoords.getTrack().getStrings();
        if (list2.size() != list.size()) {
            return true;
        }
        for (int i = 0; i < list2.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)list2.get(i);
            boolean bl = false;
            for (int j = 0; j < list.size(); ++j) {
                InstrumentString instrumentString2 = (InstrumentString)list.get(j);
                if (!instrumentString2.isEqual(instrumentString)) continue;
                bl = true;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean hasInstrumentChanges(SongTrackCoords songTrackCoords, int n, boolean bl) {
        if (n < 0) {
            return false;
        }
        if (songTrackCoords.getTrack().getChannel().getInstrument() != n) {
            return true;
        }
        return songTrackCoords.getTrack().isPercussionTrack() != bl;
    }

    private void updateTunningSpinner(boolean bl) {
        int n = this.tempStrings.size() - 1;
        for (InstrumentString instrumentString : this.tempStrings) {
            this.stringSpinners[n].setSelection(instrumentString.getValue());
            this.stringSpinners[n].setVisible(true);
            this.stringSpinners[n].setEnabled(bl);
            --n;
        }
        for (int i = this.tempStrings.size(); i < 7; ++i) {
            this.stringSpinners[i].setSelection(0);
            this.stringSpinners[i].setVisible(false);
        }
    }

    private void initTempStirngs(List list) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            InstrumentString instrumentString = (InstrumentString)list.get(i);
            this.tempStrings.add(instrumentString.clone());
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();
        if (this.percussionCheckBox.getSelection()) {
            for (int i = 1; i <= this.stringCount; ++i) {
                this.tempStrings.add(new InstrumentString(i, 0));
            }
        } else {
            switch (this.stringCount) {
                case 7: {
                    this.tempStrings.add(new InstrumentString(1, 64));
                    this.tempStrings.add(new InstrumentString(2, 59));
                    this.tempStrings.add(new InstrumentString(3, 55));
                    this.tempStrings.add(new InstrumentString(4, 50));
                    this.tempStrings.add(new InstrumentString(5, 45));
                    this.tempStrings.add(new InstrumentString(6, 40));
                    this.tempStrings.add(new InstrumentString(7, 35));
                    break;
                }
                case 6: {
                    this.tempStrings.add(new InstrumentString(1, 64));
                    this.tempStrings.add(new InstrumentString(2, 59));
                    this.tempStrings.add(new InstrumentString(3, 55));
                    this.tempStrings.add(new InstrumentString(4, 50));
                    this.tempStrings.add(new InstrumentString(5, 45));
                    this.tempStrings.add(new InstrumentString(6, 40));
                    break;
                }
                case 5: {
                    this.tempStrings.add(new InstrumentString(1, 43));
                    this.tempStrings.add(new InstrumentString(2, 38));
                    this.tempStrings.add(new InstrumentString(3, 33));
                    this.tempStrings.add(new InstrumentString(4, 28));
                    this.tempStrings.add(new InstrumentString(5, 23));
                    break;
                }
                case 4: {
                    this.tempStrings.add(new InstrumentString(1, 43));
                    this.tempStrings.add(new InstrumentString(2, 38));
                    this.tempStrings.add(new InstrumentString(3, 33));
                    this.tempStrings.add(new InstrumentString(4, 28));
                }
            }
        }
    }

    private String[] getAllValueNames() {
        String[] stringArray = new String[120];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getValueName(i);
        }
        return stringArray;
    }

    private String getValueName(int n) {
        String string = null;
        int n2 = n / 12;
        switch (n -= n2 * 12) {
            case 0: {
                string = "C";
                break;
            }
            case 1: {
                string = "C#";
                break;
            }
            case 2: {
                string = "D";
                break;
            }
            case 3: {
                string = "D#";
                break;
            }
            case 4: {
                string = "E";
                break;
            }
            case 5: {
                string = "F";
                break;
            }
            case 6: {
                string = "F#";
                break;
            }
            case 7: {
                string = "G";
                break;
            }
            case 8: {
                string = "G#";
                break;
            }
            case 9: {
                string = "A";
                break;
            }
            case 10: {
                string = "Bb";
                break;
            }
            case 11: {
                string = "B";
            }
        }
        return string + n2;
    }

    private class ChannelIndex {
        private int index;
        private int channel;

        public ChannelIndex(int n, int n2) {
            this.index = n;
            this.channel = n2;
        }

        public int getChannel() {
            return this.channel;
        }

        public int getIndex() {
            return this.index;
        }
    }

    private class ChannelList {
        private List channelIndexs = new ArrayList();

        public void addChannel(int n, int n2) {
            this.channelIndexs.add(new ChannelIndex(n, n2));
        }

        public int getChannel(int n) {
            for (ChannelIndex channelIndex : this.channelIndexs) {
                if (n != channelIndex.getIndex()) continue;
                return channelIndex.getChannel();
            }
            return -1;
        }

        public void clear() {
            this.channelIndexs.clear();
        }
    }

    private class TunningSpinner
    extends Composite {
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;

        public TunningSpinner(Composite composite, int n) {
            super(composite, n);
            this.setLayout(this.createLayout(2));
            this.init();
        }

        private void init() {
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)new GridData(30, 22));
            this.buttonComposite = new Composite((Composite)this, 0);
            this.buttonComposite.setLayout(this.createLayout(1));
            this.upButton = new Button(this.buttonComposite, 132);
            this.upButton.setLayoutData((Object)new GridData(15, 15));
            this.downButton = new Button(this.buttonComposite, 1028);
            this.downButton.setLayoutData((Object)new GridData(15, 15));
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;
            this.text.setEditable(false);
            this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TunningSpinner.this.setSelection(TunningSpinner.this.selection + 1);
                }
            });
            this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TunningSpinner.this.setSelection(TunningSpinner.this.selection - 1);
                }
            });
        }

        private Layout createLayout(int n) {
            GridLayout gridLayout = new GridLayout(n, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            return gridLayout;
        }

        public void setTexts(String[] stringArray) {
            this.texts = stringArray;
            this.minSelection = 0;
            this.maxSelection = stringArray.length - 1;
        }

        public int getSelection() {
            return this.selection;
        }

        public void setSelection(int n) {
            if (n >= this.minSelection && n <= this.maxSelection) {
                this.selection = n;
                if (this.texts != null) {
                    this.text.setText(this.texts[n]);
                }
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.text.setEnabled(bl);
            this.upButton.setEnabled(bl);
            this.downButton.setEnabled(bl);
        }
    }
}

