/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.help;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.doc.DocReader;

public class ShowAboutHelpAction
extends Action {
    public static final String NAME = "SHOW_ABOUT_HELP";
    private static final String TUXGUITAR_VERSION = "TuxGuitar 0.7";
    private static final int IMAGE_WIDTH = 100;
    private static final int IMAGE_HEIGHT = 100;
    private static final int TAB_ITEM_WIDTH = 500;
    private static final int TAB_ITEM_HEIGHT = 200;
    private Canvas imageCanvas;
    private Image tabImage;

    public ShowAboutHelpAction(TablatureEditor tablatureEditor) {
        super(NAME, false, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("help.about"));
        Composite composite = new Composite((Composite)shell2, 0);
        this.imageCanvas = new Canvas(composite, 0);
        this.tabImage = SystemImages.ABOUT_DESCRIPTION;
        Label label = new Label(composite, 0);
        Font font = new Font((Device)shell2.getDisplay(), "Serif", 36, 3);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.imageCanvas.setLayoutData((Object)new GridData(100, 100));
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Rectangle rectangle = ShowAboutHelpAction.this.tabImage.getBounds();
                paintEvent.gc.drawImage(ShowAboutHelpAction.this.tabImage, (100 - rectangle.width) / 2, (100 - rectangle.height) / 2);
            }
        });
        label.setFont(font);
        label.setForeground(shell2.getDisplay().getSystemColor(15));
        label.setText(TUXGUITAR_VERSION);
        font.dispose();
        Composite composite2 = new Composite((Composite)shell2, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        final TabFolder tabFolder = new TabFolder(composite2, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        tabFolder.setLayout((Layout)new FormLayout());
        DocReader docReader = new DocReader();
        this.makeTabItem(tabFolder, "Description", docReader.read("Description").toString());
        this.makeTabItem(tabFolder, "Authors", docReader.read("Authors").toString());
        this.makeTabItem(tabFolder, "License", docReader.read("License").toString());
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (tabFolder.getSelectionIndex() == 0) {
                    ShowAboutHelpAction.this.tabImage = SystemImages.ABOUT_DESCRIPTION;
                } else if (tabFolder.getSelectionIndex() == 1) {
                    ShowAboutHelpAction.this.tabImage = SystemImages.ABOUT_AUTHORS;
                } else if (tabFolder.getSelectionIndex() == 2) {
                    ShowAboutHelpAction.this.tabImage = SystemImages.ABOUT_LICENSE;
                }
                ShowAboutHelpAction.this.imageCanvas.redraw();
            }
        });
        tabFolder.setSelection(0);
        Composite composite3 = new Composite((Composite)shell2, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)gridData);
        button.setText(TuxGuitar.getProperty("exit"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.pack();
        shell2.open();
        int n = shell.getBounds().x + (shell.getBounds().width - shell2.getSize().x) / 2;
        int n2 = shell.getBounds().y + (shell.getBounds().height - shell2.getSize().y) / 2;
        shell2.setLocation(n, n2);
    }

    private void makeTabItem(TabFolder tabFolder, String string, String string2) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new FormData(500, 200));
        Text text = new Text(composite, 2626);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        text.setEditable(false);
        text.append(string2);
        text.setSelection(0);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(string);
        tabItem.setControl((Control)composite);
    }
}

