/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

public class ChangeDeadNoteAction
extends Action {
    public static final String NAME = "CHANGE_DEAD_NOTE";

    public ChangeDeadNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
        Note note = null;
        Caret caret = this.getEditor().getTablature().getCaret();
        MeasureComponent measureComponent = caret.getMeasureCoords().getComponent(caret.getPosition(), caret.getSelectedString().getNumber());
        if (measureComponent instanceof NoteCoords) {
            note = ((NoteCoords)measureComponent).getNote();
        }
        if (note == null) {
            Duration duration = (Duration)caret.getDuration().clone();
            InstrumentString instrumentString = new InstrumentString(caret.getSelectedString().getNumber(), caret.getSelectedString().getValue());
            note = new Note(0, caret.getPosition(), duration, 64, instrumentString.getNumber(), false, new NoteEffect());
            this.getSongManager().getMeasureManager().addNote(caret.getMeasureCoords().getMeasure(), note);
        }
        this.getSongManager().getMeasureManager().changeDeadNote(note);
        this.updateTablature();
        this.getEditor().getUndoManager().addEdit(undoableComponentGeneric.endUndo());
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }
}

