/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.bend.BendEditor;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.NoteCoords;
import org.herac.tuxguitar.gui.undo.undoables.component.UndoableComponentGeneric;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Measure;

public class ChangeBendNoteAction
extends Action {
    public static final String NAME = "CHANGE_BEND_NOTE";
    private BendEditor editor;
    private DefaultBend[] defaultBends;
    private boolean isEditing;

    public ChangeBendNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, true, tablatureEditor);
    }

    public boolean doAction(TypedEvent typedEvent) {
        Caret caret = this.getEditor().getTablature().getCaret();
        MeasureComponent measureComponent = caret.getMeasureCoords().getComponent(caret.getPosition(), caret.getSelectedString().getNumber());
        if (measureComponent instanceof NoteCoords) {
            this.showEditor(this.getEditor().getTablature().getShell(), (NoteCoords)measureComponent);
        }
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        this.redraw();
    }

    private void showEditor(Shell shell, final NoteCoords noteCoords) {
        final Shell shell2 = new Shell(shell, 67680);
        shell2.setLayout((Layout)new GridLayout());
        shell2.setText(TuxGuitar.getProperty("bend.editor"));
        Composite composite = new Composite((Composite)shell2, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayout((Layout)new GridLayout());
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout());
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        this.isEditing = noteCoords.getNote().getEffect().isBend();
        this.editor = new BendEditor(composite4, 2048);
        this.editor.setLayoutData(new GridData(this.editor.getWidth() + 60, this.editor.getHeight() + 30));
        if (this.isEditing) {
            this.editor.setBend(noteCoords.getNote().getEffect().getBend());
        }
        Composite composite5 = new Composite(composite3, 0);
        composite5.setLayout((Layout)new GridLayout());
        composite5.setLayoutData((Object)new GridData(4, 4, true, true));
        final List list = new List(composite5, 2048);
        this.resetDefaultBends();
        for (int i = 0; i < this.defaultBends.length; ++i) {
            list.add(this.defaultBends[i].getName());
        }
        list.setLayoutData((Object)new GridData(4, 4, true, true));
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!ChangeBendNoteAction.this.isEditing) {
                    ChangeBendNoteAction.this.editor.setBend(ChangeBendNoteAction.this.defaultBends[list.getSelectionIndex()].getBend());
                    ChangeBendNoteAction.this.editor.redraw();
                }
                ChangeBendNoteAction.this.isEditing = false;
            }
        });
        Composite composite6 = new Composite(composite3, 0);
        composite6.setLayout((Layout)new GridLayout(2, false));
        composite6.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        Button button = new Button(composite6, 8);
        button.setLayoutData((Object)gridData);
        button.setText(TuxGuitar.getProperty("ok"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UndoableComponentGeneric undoableComponentGeneric = UndoableComponentGeneric.startUndo();
                Measure measure = ChangeBendNoteAction.this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasure();
                if (ChangeBendNoteAction.this.editor.isEmpty()) {
                    ChangeBendNoteAction.this.getSongManager().getMeasureManager().changeBendNote(measure, noteCoords.getNote().getStart(), noteCoords.getNote().getString(), null);
                } else {
                    BendEffect bendEffect = new BendEffect();
                    ChangeBendNoteAction.this.editor.addBendPoints(bendEffect);
                    ChangeBendNoteAction.this.getSongManager().getMeasureManager().changeBendNote(measure, noteCoords.getNote().getStart(), noteCoords.getNote().getString(), bendEffect);
                }
                ChangeBendNoteAction.this.updateTablature();
                ChangeBendNoteAction.this.getEditor().getUndoManager().addEdit(undoableComponentGeneric.endUndo());
                shell2.dispose();
            }
        });
        Button button2 = new Button(composite6, 8);
        button2.setLayoutData((Object)gridData);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.pack();
        shell2.open();
    }

    private void resetDefaultBends() {
        this.defaultBends = new DefaultBend[5];
        this.defaultBends[0] = new DefaultBend(TuxGuitar.getProperty("bend.bend"), new BendEffect());
        this.defaultBends[0].getBend().addPoint(0, 0);
        this.defaultBends[0].getBend().addPoint(6, 8);
        this.defaultBends[0].getBend().addPoint(12, 8);
        this.defaultBends[1] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release"), new BendEffect());
        this.defaultBends[1].getBend().addPoint(0, 0);
        this.defaultBends[1].getBend().addPoint(3, 8);
        this.defaultBends[1].getBend().addPoint(6, 8);
        this.defaultBends[1].getBend().addPoint(9, 0);
        this.defaultBends[1].getBend().addPoint(12, 0);
        this.defaultBends[2] = new DefaultBend(TuxGuitar.getProperty("bend.bend-release-bend"), new BendEffect());
        this.defaultBends[2].getBend().addPoint(0, 0);
        this.defaultBends[2].getBend().addPoint(2, 8);
        this.defaultBends[2].getBend().addPoint(4, 8);
        this.defaultBends[2].getBend().addPoint(6, 0);
        this.defaultBends[2].getBend().addPoint(8, 0);
        this.defaultBends[2].getBend().addPoint(10, 8);
        this.defaultBends[2].getBend().addPoint(12, 8);
        this.defaultBends[3] = new DefaultBend(TuxGuitar.getProperty("bend.prebend"), new BendEffect());
        this.defaultBends[3].getBend().addPoint(0, 8);
        this.defaultBends[3].getBend().addPoint(12, 8);
        this.defaultBends[4] = new DefaultBend(TuxGuitar.getProperty("bend.prebend-release"), new BendEffect());
        this.defaultBends[4].getBend().addPoint(0, 8);
        this.defaultBends[4].getBend().addPoint(4, 8);
        this.defaultBends[4].getBend().addPoint(8, 0);
        this.defaultBends[4].getBend().addPoint(12, 0);
    }

    private class DefaultBend {
        private String name;
        private BendEffect bend;

        public DefaultBend(String string, BendEffect bendEffect) {
            this.name = string;
            this.bend = bendEffect;
        }

        public BendEffect getBend() {
            return this.bend;
        }

        public String getName() {
            return this.name;
        }
    }
}

