/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.FretBoardEditor;
import org.herac.tuxguitar.gui.SongTableViewer;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionContainer;
import org.herac.tuxguitar.gui.config.SystemConfigManager;
import org.herac.tuxguitar.gui.fretboard.FretBoard;
import org.herac.tuxguitar.gui.helper.FileHistory;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.items.ItemContainerManager;
import org.herac.tuxguitar.gui.keybindings.KeyBindingManager;
import org.herac.tuxguitar.gui.language.LanguageManager;
import org.herac.tuxguitar.gui.mixer.SongMixer;
import org.herac.tuxguitar.gui.plugins.PluginManager;
import org.herac.tuxguitar.gui.table.SongTableInfo;
import org.herac.tuxguitar.gui.transport.SongTransport;
import org.herac.tuxguitar.gui.util.ArgumentParser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.song.managers.SongManager;

public class TuxGuitar {
    private static final String appConfigDomain = ".tuxguitar";
    private static final String appConfigDomainEnvVar = "TUXGUITAR_CONFIG_HOME";
    private static TuxGuitar instance;
    private Display display;
    private Shell shell;
    private SongManager songManager;
    private LanguageManager languageManager;
    private SystemConfigManager configManager;
    private KeyBindingManager keyBindingManager;
    private Composite sashComposite;
    private Sash sash;
    private TablatureEditor tablatureEditor;
    private SongTableViewer tableViewer;
    private SongMixer songMixer;
    private SongTransport songTransport;
    private FretBoardEditor fretBoardEditor;
    private ActionContainer actionContainer;
    private ItemContainerManager itemContainerManager;
    private FileHistory fileHistory;
    private PluginManager pluginManager;

    public static void main(String[] stringArray) {
        TuxGuitar.instance().displayGUI(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TuxGuitar instance() {
        if (instance != null) return instance;
        Class<TuxGuitar> clazz = TuxGuitar.class;
        synchronized (TuxGuitar.class) {
            instance = new TuxGuitar();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initLanguage() {
        this.languageManager = new LanguageManager();
        this.languageManager.setLanguage(this.getConfig().getStringConfigValue("LANGUAGE"));
    }

    public void displayGUI(String[] stringArray) {
        ArgumentParser argumentParser = new ArgumentParser(stringArray);
        if (argumentParser.printAndExit()) {
            return;
        }
        this.initConfigManager();
        this.initLanguage();
        this.display = new Display();
        Shell shell = this.getSplashShell(this.display);
        shell.open();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        this.shell.setImage(SystemImages.TUXGUITAR_ICON);
        this.songManager = new SongManager();
        this.pluginManager = new PluginManager();
        if (argumentParser.getFile() != null) {
            try {
                this.songManager.open(argumentParser.getFile().getPath());
            }
            catch (GPFormatException gPFormatException) {
                gPFormatException.printStackTrace();
                this.songManager.newSong();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.songManager.newSong();
            }
            catch (UnsupportedFormatException unsupportedFormatException) {
                unsupportedFormatException.printStackTrace();
                this.songManager.newSong();
            }
        }
        this.checkSoundbank();
        this.fileHistory = new FileHistory();
        this.tablatureEditor = new TablatureEditor(this.songManager);
        this.tableViewer = new SongTableViewer(this.tablatureEditor);
        this.fretBoardEditor = new FretBoardEditor(this.tablatureEditor);
        this.songMixer = new SongMixer();
        this.songTransport = new SongTransport();
        this.initActions();
        this.adjustKeyBindings();
        this.initItems();
        this.createComposites((Composite)this.shell);
        boolean bl = this.getConfig().getBooleanConfigValue("MAXIMIZED");
        this.shell.setMaximized(bl);
        if (!bl) {
            int n = this.getConfig().getIntConfigValue("WIDTH");
            int n2 = this.getConfig().getIntConfigValue("HEIGHT");
            if (n > 0 && n2 > 0) {
                this.shell.setSize(n, n2);
            }
        }
        this.tablatureEditor.getTablature().setFocus();
        this.shell.setMinimumSize(640, 480);
        shell.close();
        shell.dispose();
        this.shell.open();
        this.setDefaults();
        this.updateItems();
        this.pluginManager.initPLugins();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.songManager.getPlayer().close();
        this.pluginManager.closePLugins();
        this.dispose();
        if (!this.getDisplay().isDisposed()) {
            this.display.dispose();
        }
        System.exit(0);
    }

    private Shell getSplashShell(Display display) {
        Shell shell = new Shell(display, 262152);
        final Image image = SystemImages.TUXGUITAR_SPLASH;
        int n = image.getBounds().width;
        int n2 = image.getBounds().height;
        int n3 = (display.getBounds().width - display.getBounds().x) / 2 - n / 2;
        int n4 = (display.getBounds().height - display.getBounds().y) / 2 - n2 / 2;
        shell.setBounds(n3, n4, n, n2);
        shell.setImage(SystemImages.TUXGUITAR_ICON);
        shell.setText(TuxGuitar.getProperty("tuxguitar.title"));
        shell.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                paintEvent.gc.drawImage(image, 0, 0);
            }
        });
        return shell;
    }

    public void createComposites(Composite composite) {
        this.sashComposite = new Composite(composite, 0);
        this.sashComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.itemContainerManager.getCoolbar(), 5);
        formData.bottom = new FormAttachment(100, 0);
        this.sashComposite.setLayoutData((Object)formData);
        this.sash = new Sash(this.sashComposite, 258);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(75, 0);
        this.sash.setLayoutData((Object)formData);
        this.tablatureEditor.showTablature(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)this.sash, 0);
        this.tablatureEditor.getTablature().setLayoutData(formData);
        this.tableViewer.showMixer(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.sash, 10);
        formData.bottom = new FormAttachment(100, 0);
        this.tableViewer.getTableInfo().setLayoutData(formData);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ((TuxGuitar)TuxGuitar.this).sashComposite.getBounds().height;
                int n2 = selectionEvent.y * 100 / n;
                ((FormData)((TuxGuitar)TuxGuitar.this).sash.getLayoutData()).top = new FormAttachment(n2, 0);
            }
        });
        this.sash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TuxGuitar.this.sash.getParent().layout();
            }
        });
        this.fretBoardEditor.showFretBoard(composite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.sashComposite, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoardEditor.getFretBoard().setLayoutData(formData);
    }

    public void checkSoundbank() {
        boolean bl = this.getConfig().getBooleanConfigValue("SOUNDBANK_CUSTOM");
        if (bl && !this.getSongManager().getPlayer().loadSoundbank(new File(this.getConfig().getStringConfigValue("SOUNDBANK_CUSTOM_PATH")))) {
            String string = TuxGuitar.getProperty("soundbank.error");
            String string2 = TuxGuitar.getProperty("soundbank.error.custom");
            new MessageDialog(string, string2, 33).show(this.shell);
        }
    }

    public void setDefaults() {
        this.showFretBoard(this.getConfig().getBooleanConfigValue("SHOW_FRETBOARD"));
        if (this.getConfig().getBooleanConfigValue("SHOW_MIXER")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getMixer().show();
                }
            }).start();
        }
        if (this.getConfig().getBooleanConfigValue("SHOW_TRANSPORT")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getTransport().show();
                }
            }).start();
        }
    }

    public void showFretBoard(boolean bl) {
        if (bl) {
            this.showFretBoard();
        } else {
            this.hideFretBoard();
        }
    }

    public void showFretBoard() {
        this.fretBoardEditor.getFretBoard().setVisible(true);
        this.updateSashNumerator();
        this.fretBoardEditor.getFretBoard().getParent().layout();
    }

    public void hideFretBoard() {
        this.fretBoardEditor.getFretBoard().setVisible(false);
        ((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
        this.shell.setMinimumSize(640, 480);
        this.fretBoardEditor.getFretBoard().setVisible(false);
        this.updateSashNumerator();
        this.fretBoardEditor.getFretBoard().getParent().layout();
    }

    public void updateSashNumerator() {
        FormData formData = (FormData)this.sashComposite.getLayoutData();
        if (this.fretBoardEditor.getFretBoard().isVisible()) {
            int n = 100 - this.fretBoardEditor.getFretBoard().getHeight() * 100 / this.shell.getBounds().height;
            if (n < 0) {
                n = 0;
            }
            formData.bottom.numerator = n;
            this.shell.setMinimumSize(730, 520);
        } else {
            ((FormData)this.sashComposite.getLayoutData()).bottom.numerator = 100;
            this.shell.setMinimumSize(640, 480);
        }
    }

    public TablatureEditor getTablatureEditor() {
        return this.tablatureEditor;
    }

    public FretBoardEditor getFretBoardEditor() {
        return this.fretBoardEditor;
    }

    private void initItems() {
        this.itemContainerManager = new ItemContainerManager(this.tablatureEditor);
        this.itemContainerManager.createMenu(this.shell);
        this.itemContainerManager.createPopupMenu(this.shell);
        this.itemContainerManager.createToolbar(this.shell);
    }

    private void initActions() {
        this.actionContainer = new ActionContainer(this.tablatureEditor);
        this.actionContainer.initActions();
    }

    private void initConfigManager() {
        this.configManager = new SystemConfigManager();
        this.configManager.init();
    }

    private void adjustKeyBindings() {
        this.keyBindingManager = new KeyBindingManager();
        this.keyBindingManager.init();
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public SongMixer getMixer() {
        return this.songMixer;
    }

    public SongTransport getTransport() {
        return this.songTransport;
    }

    public SongTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void updateItems() {
        this.getItemContainerManager().updateItems();
        this.getTransport().updateItems();
    }

    public void reloadConfig() {
        String string = this.getConfig().getStringConfigValue("LANGUAGE");
        if (string != null && string.length() > 0) {
            this.getLanguageManager().setLanguage(string);
        }
        this.getTablatureEditor().reloadConfig();
        this.setDefaults();
        this.loadProperties();
    }

    public void redraw() {
        if (!this.getDisplay().isDisposed()) {
            this.tablatureEditor.getTablature().redraw();
            this.fretBoardEditor.getFretBoard().redraw();
            this.tableViewer.getTableInfo().redraw();
        }
    }

    public void redrawPayingMode() {
        if (!this.getDisplay().isDisposed()) {
            this.tablatureEditor.getTablature().redraw();
            this.fretBoardEditor.getFretBoard().redrawPlayingMode();
            this.tableViewer.getTableInfo().redrawPlayingMode();
            this.songTransport.redraw();
        }
    }

    public void fireUpdate() {
        this.tablatureEditor.getTablature().updateTablature();
        this.tableViewer.getTableInfo().fireUpdate();
    }

    public void loadProperties() {
        this.itemContainerManager.loadProperties();
        this.tableViewer.getTableInfo().loadProperties();
        this.fretBoardEditor.getFretBoard().loadProperties();
        this.songMixer.loadProperties();
        this.songTransport.loadProperties();
    }

    public Display getDisplay() {
        return this.display;
    }

    public Action getAction(String string) {
        return this.actionContainer.getAction(string);
    }

    public ItemContainerManager getItemContainerManager() {
        return this.itemContainerManager;
    }

    public ActionContainer getActionContainer() {
        return this.actionContainer;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public static String getProperty(String string) {
        return TuxGuitar.instance().languageManager.getProperty(string);
    }

    public SystemConfigManager getConfig() {
        return this.configManager;
    }

    public KeyBindingManager getkeyBindingManager() {
        return this.keyBindingManager;
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public static boolean isDisposed() {
        return TuxGuitar.instance().getDisplay().isDisposed();
    }

    private void dispose() {
        SystemImages.disposeImages();
        this.getTablatureEditor().getTablature().dispose();
        SongTableInfo.disposeColors();
        FretBoard.disposeColors();
    }

    public void showErrorMessage(Throwable throwable) {
        throwable.printStackTrace();
        String string = TuxGuitar.getProperty("error");
        String string2 = throwable.getMessage();
        new MessageDialog(string, string2, 1).show(this.shell);
    }
}

