/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.clipboard.ClipBoard;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.gui.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.layout.PageViewLayout;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.undo.UndoManager;
import org.herac.tuxguitar.song.managers.SongManager;

public class TablatureEditor {
    private SongManager songManager;
    private Tablature tablature;
    private UndoManager undoManager;
    private ClipBoard clipBoard;

    public TablatureEditor(SongManager songManager) {
        this.songManager = songManager;
        this.undoManager = new UndoManager();
        this.clipBoard = new ClipBoard();
    }

    public void showTablature(Composite composite) {
        this.tablature = new Tablature(composite, 0x20000B00);
        this.tablature.initGUI();
        this.tablature.setSongManager(this.songManager);
        this.tablature.initDefaults(this.getDefaultLayout());
        this.tablature.updateTablature();
        this.tablature.initCaret();
        this.initMouseActions();
        this.initKeyActions();
        this.initMenu();
    }

    private ViewLayout getDefaultLayout() {
        boolean bl = TuxGuitar.instance().getConfig().getBooleanConfigValue("SHOW_MULTITRACK");
        boolean bl2 = TuxGuitar.instance().getConfig().getBooleanConfigValue("SHOW_SCORE");
        int n = TuxGuitar.instance().getConfig().getIntConfigValue("LAYOUT_MODE");
        n = n == 0 ? 2 : n;
        switch (n) {
            case 1: {
                return new PageViewLayout(this.tablature, this.songManager, bl, bl2);
            }
            case 2: {
                return new LinearViewLayout(this.tablature, this.songManager, bl, bl2);
            }
        }
        return null;
    }

    private void initMouseActions() {
        this.tablature.addMouseListener(TuxGuitar.instance().getAction("SELECT_COMPONENT"));
    }

    private void initKeyActions() {
        this.tablature.addKeyListener((KeyListener)new TablatureKeyListener());
        TuxGuitar.instance().getkeyBindingManager().appendListenersTo(this.tablature);
    }

    private void initMenu() {
        this.tablature.setMenu(TuxGuitar.instance().getItemContainerManager().getPopupMenu());
        this.tablature.getMenu().addMenuListener((MenuListener)TuxGuitar.instance().getAction("SELECT_COMPONENT"));
    }

    public void resetDefaults() {
        this.getSongManager().getPlayer().reset();
        this.getUndoManager().discardAllEdits();
        this.getTablature().resetScroll();
        this.getTablature().updateTablature();
        this.getTablature().initCaret();
        TuxGuitar.instance().updateItems();
    }

    public void reloadConfig() {
        this.getTablature().reloadConfig(this.getDefaultLayout());
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public SongManager getSongManager() {
        return this.songManager;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public ClipBoard getClipBoard() {
        return this.clipBoard;
    }

    private class TablatureKeyListener
    extends KeyAdapter {
        private TablatureKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Action action = this.switchAction(keyEvent);
            if (action != null) {
                action.process((TypedEvent)keyEvent);
            }
        }

        private Action switchAction(KeyEvent keyEvent) {
            Action action = null;
            if (keyEvent.stateMask == 0 && this.isNumber(keyEvent.character)) {
                action = TuxGuitar.instance().getAction("CHANGE_NOTE");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000009) {
                action = TuxGuitar.instance().getAction("INSERT_NOTE");
            } else if (keyEvent.stateMask == 0 && (keyEvent.keyCode == 127 || keyEvent.keyCode == 8)) {
                action = TuxGuitar.instance().getAction("REMOVE_NOTE");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000001) {
                action = TuxGuitar.instance().getAction("GO_UP");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000002) {
                action = TuxGuitar.instance().getAction("GO_DOWN");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000004) {
                action = TuxGuitar.instance().getAction("GO_RIGHT");
            } else if (keyEvent.stateMask == 0 && keyEvent.keyCode == 0x1000003) {
                action = TuxGuitar.instance().getAction("GO_LEFT");
            } else if (keyEvent.stateMask == 0 && keyEvent.character == '+') {
                action = TuxGuitar.instance().getAction("INCREMENT_DURATION");
            } else if (keyEvent.stateMask == 0 && keyEvent.character == '-') {
                action = TuxGuitar.instance().getAction("DECREMENT_DURATION");
            }
            return action;
        }

        private boolean isNumber(char c) {
            return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
        }
    }
}

