/*
 * Decompiled with CFR 0.152.
 */
package net.sf.janel.ant;

public class Quantize {
    static final boolean QUICK = true;
    static final int MAX_RGB = 255;
    static final int MAX_NODES = 266817;
    static final int MAX_TREE_DEPTH = 8;
    static int[] SQUARES;
    static int[] SHIFT;

    public static int[] quantizeImage(int[][] nArray, int n) {
        Cube cube = new Cube(nArray, n);
        cube.classification();
        cube.reduction();
        cube.assignment();
        return cube.colormap;
    }

    static {
        int n;
        SQUARES = new int[511];
        for (n = -255; n <= 255; ++n) {
            Quantize.SQUARES[n + 255] = n * n;
        }
        SHIFT = new int[9];
        for (n = 0; n < 9; ++n) {
            Quantize.SHIFT[n] = 1 << 15 - n;
        }
    }

    static class Cube {
        int[][] pixels;
        int max_colors;
        int[] colormap;
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(int[][] nArray, int n) {
            this.pixels = nArray;
            this.max_colors = n;
            int n2 = n;
            this.depth = 1;
            while (n2 != 0) {
                n2 /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void classification() {
            int[][] nArray = this.pixels;
            int n = nArray.length;
            int n2 = nArray[0].length;
            int n3 = n;
            while (n3-- > 0) {
                int n4 = n2;
                while (n4-- > 0) {
                    int n5 = nArray[n3][n4];
                    int n6 = n5 >> 16 & 0xFF;
                    int n7 = n5 >> 8 & 0xFF;
                    int n8 = n5 >> 0 & 0xFF;
                    if (this.nodes > 266817) {
                        System.out.println("pruning");
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int i = 1; i <= this.depth; ++i) {
                        int n9 = (n6 > node.mid_red ? 1 : 0) << 0 | (n7 > node.mid_green ? 1 : 0) << 1 | (n8 > node.mid_blue ? 1 : 0) << 2;
                        if (node.child[n9] == null) {
                            new Node(node, n9, i);
                        }
                        node = node.child[n9];
                        node.number_pixels += SHIFT[i];
                    }
                    ++node.unique;
                    node.total_red += n6;
                    node.total_green += n7;
                    node.total_blue += n8;
                }
            }
        }

        void reduction() {
            int n = 1;
            while (this.colors > this.max_colors) {
                this.colors = 0;
                n = this.root.reduce(n, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new int[this.colors];
            this.colors = 0;
            this.root.colormap();
            int[][] nArray = this.pixels;
            int n = nArray.length;
            int n2 = nArray[0].length;
            Search search = new Search();
            int n3 = n;
            while (n3-- > 0) {
                int n4 = n2;
                while (n4-- > 0) {
                    int n5;
                    int n6 = nArray[n3][n4];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 >> 8 & 0xFF;
                    int n9 = n6 >> 0 & 0xFF;
                    Node node = this.root;
                    while (node.child[n5 = (n7 > node.mid_red ? 1 : 0) << 0 | (n8 > node.mid_green ? 1 : 0) << 1 | (n9 > node.mid_blue ? 1 : 0) << 2] != null) {
                        node = node.child[n5];
                    }
                    nArray[n3][n4] = node.color_number;
                }
            }
        }

        static class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nchild;
            int id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            int number_pixels;
            int unique;
            int total_red;
            int total_green;
            int total_blue;
            int color_number;

            Node(Cube cube) {
                this.cube = cube;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = 128;
                this.mid_green = 128;
                this.mid_blue = 128;
            }

            Node(Node node, int n, int n2) {
                this.cube = node.cube;
                this.parent = node;
                this.child = new Node[8];
                this.id = n;
                this.level = n2;
                ++this.cube.nodes;
                if (n2 == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++node.nchild;
                node.child[n] = this;
                int n3 = 1 << 8 - n2 >> 1;
                this.mid_red = node.mid_red + ((n & 1) > 0 ? n3 : -n3);
                this.mid_green = node.mid_green + ((n & 2) > 0 ? n3 : -n3);
                this.mid_blue = node.mid_blue + ((n & 4) > 0 ? n3 : -n3);
            }

            void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nchild != 0) {
                    for (int i = 0; i < 8; ++i) {
                        if (this.child[i] == null) continue;
                        this.child[i].pruneLevel();
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int n, int n2) {
                if (this.nchild != 0) {
                    for (int i = 0; i < 8; ++i) {
                        if (this.child[i] == null) continue;
                        n2 = this.child[i].reduce(n, n2);
                    }
                }
                if (this.number_pixels <= n) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < n2) {
                        n2 = this.number_pixels;
                    }
                }
                return n2;
            }

            void colormap() {
                int n;
                if (this.nchild != 0) {
                    for (n = 0; n < 8; ++n) {
                        if (this.child[n] == null) continue;
                        this.child[n].colormap();
                    }
                }
                if (this.unique != 0) {
                    n = (this.total_red + (this.unique >> 1)) / this.unique;
                    int n2 = (this.total_green + (this.unique >> 1)) / this.unique;
                    int n3 = (this.total_blue + (this.unique >> 1)) / this.unique;
                    this.cube.colormap[this.cube.colors] = 0xFF000000 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
                    this.color_number = this.cube.colors++;
                }
            }

            void closestColor(int n, int n2, int n3, Search search) {
                int n4;
                int n5;
                if (this.nchild != 0) {
                    for (n5 = 0; n5 < 8; ++n5) {
                        if (this.child[n5] == null) continue;
                        this.child[n5].closestColor(n, n2, n3, search);
                    }
                }
                if (this.unique != 0 && (n4 = Node.distance(n5 = this.cube.colormap[this.color_number], n, n2, n3)) < search.distance) {
                    search.distance = n4;
                    search.color_number = this.color_number;
                }
            }

            static final int distance(int n, int n2, int n3, int n4) {
                return SQUARES[(n >> 16 & 0xFF) - n2 + 255] + SQUARES[(n >> 8 & 0xFF) - n3 + 255] + SQUARES[(n >> 0 & 0xFF) - n4 + 255];
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.parent == this) {
                    stringBuffer.append("root");
                } else {
                    stringBuffer.append("node");
                }
                stringBuffer.append(' ');
                stringBuffer.append(this.level);
                stringBuffer.append(" [");
                stringBuffer.append(this.mid_red);
                stringBuffer.append(',');
                stringBuffer.append(this.mid_green);
                stringBuffer.append(',');
                stringBuffer.append(this.mid_blue);
                stringBuffer.append(']');
                return new String(stringBuffer);
            }
        }

        static class Search {
            int distance;
            int color_number;

            Search() {
            }
        }
    }
}

