/*
 * Created on 23-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.song.managers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;

import org.herac.tuxguitar.io.SongLoader;
import org.herac.tuxguitar.io.SongWriter;
import org.herac.tuxguitar.io.UnsupportedFormatException;
import org.herac.tuxguitar.io.gp.GPFormatException;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.defaultplayer.SongPlayer;
import org.herac.tuxguitar.song.helpers.TrackMeasure;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SongManager {
    public static short MAX_CHANNELS = 16;
    
    private Song song;
    private Player player;
    private SongTrackManager trackManager;
    private MeasureManager measureManager;
    
    public SongManager(){               
        this.player = new SongPlayer(this);
        this.newSong();
    }
    
    public void setSongName(String name){
        getSong().setName(name);
    }
    
    public Song getSong(){
        return this.song;
    }
    
    public void newSong(){
        setSong(makeNewSong());        
    }
    
    public void save(String fileName){                        
        try {
            new SongWriter(fileName).write(getSong());    
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (GPFormatException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }         
    }
    
    public boolean open(String fileName) throws GPFormatException, IOException, UnsupportedFormatException{
        SongLoader loader = new SongLoader(fileName);
        Song song = loader.load();
        if(song != null){
            setSong(song);
            return true;
        }            
        return false;
    }        

    public void setSong(Song song){
        this.song = song;
        this.player.reset();
    }
    
    public void setProperties(String name,String interpret,String album,String author){
        getSong().setName(name);
        getSong().setInterpret(interpret);
        getSong().setAlbum(album);
        getSong().setAuthor(author);
    }
    
    public Player getPlayer(){
        return this.player;
    }
    
    
    public void addTrack(SongTrack trackToAdd){
    	this.orderTracks();
    	int addIndex = -1;
    	for(int i = 0;i < getSong().getTracks().size();i++){
    		SongTrack track = (SongTrack)getSong().getTracks().get(i);
    		if(addIndex == -1 && track.getNumber() == trackToAdd.getNumber()){
    			addIndex = i;
    		}
    		if(addIndex >= 0){
    			track.setNumber(track.getNumber() + 1);
    		}
    	}
    	if(addIndex < 0){
    		addIndex = getSong().getTracks().size();
    	}
        getSong().getTracks().add(addIndex,trackToAdd);
    }
    
    public void removeTrack(long number){
    	this.orderTracks();
    	SongTrack trackToRemove = null;
    	
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack currTrack = (SongTrack)it.next();            
            if(trackToRemove == null && currTrack.getNumber() == number){
            	trackToRemove = currTrack;
            }else if(currTrack.getNumber() == (number + 1)){            	
            	currTrack.setNumber(number);
            	number ++;
            }
            
        }
        getSong().getTracks().remove(trackToRemove);
    }
    
    private void orderTracks(){
        for(int i = 0;i < getSong().getTracks().size();i++){
        	SongTrack minTrack = null;
            for(int trackIdx = i;trackIdx < getSong().getTracks().size();trackIdx++){
            	SongTrack track = (SongTrack)getSong().getTracks().get(trackIdx);
                if(minTrack == null || track.getNumber() < minTrack.getNumber()){
                	minTrack = track;
                }
            }
            getSong().getTracks().remove(minTrack);
            getSong().getTracks().add(i,minTrack);
        }
    }
    
    public SongTrack getTrack(Measure measure){
        SongTrack track = null;
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
            SongTrack currTrack = (SongTrack)it.next();
            if(currTrack.getMeasures().contains(measure)){
                track = currTrack;
                break;
            }
        }
        return track;
    }
    
    public static Song makeNewSong(){
        List tracks = new ArrayList();
        List strings = createDefaultInstrumentStrings();   
        List measureHeaders = new ArrayList();
        List measures = new ArrayList();
        MeasureHeader header = new MeasureHeader(1,1000,new TimeSignature(4,new Duration(Duration.QUARTER)),new Tempo(100),null,MeasureHeader.TRIPLET_FEEL_NONE,false,0);        
        measureHeaders.add(header);
        measures.add(new Measure(header,new ArrayList(),new ArrayList(),1,0));        
        tracks.add(new SongTrack(1,"Track 1",new SongChannel((short)0,(short)1,(short)0), measures, strings,0,RGBColor.RED));        
        return new Song(tracks,measureHeaders);  
    }    

    public long getNextTrackNumber(){
    	return countTracks() + 1;
    }
    
    public boolean isEmpty(){
    	return this.song.getTracks().isEmpty();
    }
    
    public SongChannel getFreeChannel(short instrument,boolean isPercusion){
        return getFreeChannel(getSong().getTracks(),instrument,isPercusion);
    }
 
    public static SongChannel getFreeChannel(List tracks,short instrument,boolean isPercusion){
    	if(isPercusion){
    		return SongChannel.getDefaultPercusionChannel();
    	}
        short channel = -1;
        short effectChannel = -1;
    	
        boolean[] usedChannels = getUsedChannels(tracks);
        boolean[] usedEffectChannels = getUsedEffectChannels(tracks);        
        for(short i = 0;i < MAX_CHANNELS;i++){
        	if(!usedChannels[i] && !usedEffectChannels[i]){
	            channel = (channel < 0)?i:channel;
	            effectChannel = (effectChannel < 0 && i != channel)?i:effectChannel;
        	}
        }
        if(channel < 0 || effectChannel < 0){
        	if(channel >= 0 ){
        		effectChannel = channel;
        	}else{
        		SongChannel songChannel = (SongChannel)((SongTrack)tracks.get(tracks.size() - 1)).getChannel();
        		return (SongChannel)songChannel.clone();
        	}
        }
    	return new SongChannel(channel,effectChannel,instrument);
    }
    
    public boolean[] getUsedEffectChannels(){
        return getUsedEffectChannels(getSong().getTracks());
    }
    
    public static boolean[] getUsedEffectChannels(List tracks){
        boolean[] usedEffectChannels = new boolean[MAX_CHANNELS];
        
        for(int i = 0;i < tracks.size();i++){
            SongTrack track = (SongTrack)tracks.get(i);            
            usedEffectChannels[track.getChannel().getEffectChannel()] = true;
        }        
        return usedEffectChannels;
    }
    
    public boolean[] getUsedChannels(){
    	return getUsedChannels(getSong().getTracks());
    }
    
    public static boolean[] getUsedChannels(List tracks){
        boolean[] usedChannels = new boolean[MAX_CHANNELS];
        
        for(int i = 0;i < tracks.size();i++){
            SongTrack track = (SongTrack)tracks.get(i);            
            usedChannels[track.getChannel().getChannel()] = true;
        }        
        return usedChannels;
    }    
    
    public SongChannel getUsedChannel(int channel){
        for(int i = 0;i < getSong().getTracks().size();i++){
            SongTrack track = (SongTrack)getSong().getTracks().get(i);            
            if(channel == track.getChannel().getChannel()){
            	return (SongChannel)track.getChannel().clone();
            }
        }   
        return null;
    }
    
    public int countTracksForChannel(int channel){
    	int count = 0;
        for(int i = 0;i < getSong().getTracks().size();i++){
            SongTrack track = (SongTrack)getSong().getTracks().get(i);            
            if(channel == track.getChannel().getChannel()){
            	count ++;
            }
        }   
        return count;
    }
    
    public void updateChannel(SongChannel channel){
        for(int i = 0;i < getSong().getTracks().size();i++){
            SongTrack track = (SongTrack)getSong().getTracks().get(i);            
            if(channel.getChannel() == track.getChannel().getChannel()){
            	track.setChannel((SongChannel)channel.clone());
            }
        }
    }
    
    public static List createDefaultInstrumentStrings(){
        List strings = new ArrayList();        
        strings.add(new InstrumentString(1, 64));
        strings.add(new InstrumentString(2, 59));
        strings.add(new InstrumentString(3, 55));
        strings.add(new InstrumentString(4, 50));
        strings.add(new InstrumentString(5, 45));
        strings.add(new InstrumentString(6, 40));
        return strings;
    }
    
    public static List createPercusionStrings(int stringCount){
        List strings = new ArrayList();      
        for(int i = 1;i <= stringCount; i++){
            strings.add(new InstrumentString(i, 0));
        }
        return strings;
    }        

    public void calculateMeasureStartWidthRepetitions(){
        boolean repeatOpen = true;        
        long repeatStart = 1000;
        
        long repeatEnd = 0;
        long startMove = 0;
        int repeatStartIndex = 0;
        int repeatNumber = 0;

        for (int headerIdx = 0; headerIdx < getSong().getMeasureHeaders().size(); headerIdx++) {
            MeasureHeader header = (MeasureHeader) getSong().getMeasureHeaders().get(headerIdx);
            
            //asigno el start con repeticiones
            if(!repeatOpen || header.getStart() + header.getLength() > repeatEnd){
            	header.setStartWidthRepetitions(header.getStart() + startMove);
                //calculo las notas dentro del compas
                Iterator it = getSong().getTracks().iterator();
                while(it.hasNext()){
                	SongTrack track = (SongTrack)it.next();
                	getMeasureManager().calculateNoteStartWidthRepetitions(getTrackManager().getMeasure(track,header.getNumber()),startMove);                	                	
                }
            }            

            //guardo el indice de el compas donde empieza una repeticion
            if (header.isRepeatStart()) {
                repeatStartIndex = headerIdx;                
                repeatStart = header.getStart();
                repeatOpen = true;
            }

            //si hay una repeticion la hago
            if (repeatOpen && header.getNumberOfRepetitions() > 0) {
                if (repeatNumber < header.getNumberOfRepetitions()) {
                    repeatEnd = header.getStart() + header.getLength();
                    startMove += repeatEnd - repeatStart;
                    headerIdx = repeatStartIndex - 1;
                    repeatNumber++;
                } else {
                    repeatStart = 0;
                    repeatNumber = 0;
                    repeatEnd = 0;
                    repeatOpen = false;
                }
            }

        }        
    }
    

    
    public String getInstrumentName(int instrument){
    	String name = null;
    	Soundbank soundBank = getPlayer().getSoundbank();
    	if(soundBank != null){
    		Instrument[] instruments = soundBank.getInstruments();
    		name = instruments[instrument].getName();
    	}else{
    		name = Integer.toString(instrument);
    	}
    	return name;
    }
    
    public int countTracks(){
    	return (getSong().getTracks().size());
    }

    public int countMeasures(){
    	return (getTrackManager().countMeasures(getFirstTrack()));
    }
    
    public SongTrackManager getTrackManager(){
    	if(this.trackManager == null){
    		this.trackManager = new SongTrackManager(this);
    	}
    	return this.trackManager;
    }
    
    public MeasureManager getMeasureManager(){
    	if(this.measureManager == null){
    		this.measureManager = new MeasureManager(this);
    	}
    	return this.measureManager;
    }
    
    
    
    
    
    
    
    
    
    
    
    public SongTrack getTrack(long number){
        SongTrack track = null;        
        for (int i = 0; i < getSong().getTracks().size(); i++) {
            SongTrack currTrack = (SongTrack) getSong().getTracks().get(i);            
            if(currTrack.getNumber() == number){
            	track = currTrack;
                break;
            }
        }     
        return track;
    }  
    
    
    public SongTrack getFirstTrack(){
        SongTrack track = null;
        if(!getSong().getTracks().isEmpty()){
            track = (SongTrack)getSong().getTracks().get(0);
        }
        return track;
    }       

    public SongTrack getLastTrack(){
        SongTrack track = null;
        if(!getSong().getTracks().isEmpty()){
            track = (SongTrack)getSong().getTracks().get(getSong().getTracks().size() - 1);
        }
        return track;
    }   

    public SongTrack cloneTrack(SongTrack track){
    	SongTrack clone = (SongTrack)track.clone(getMeasureHeaders());
    	clone.setNumber(getNextTrackNumber());
    	addTrack(clone);    	
    	return clone;
    }
    
    public boolean moveTrackUp(SongTrack track){  
    	if(track.getNumber() > 1){
    		SongTrack prevTrack = getTrack(track.getNumber() - 1);
    		prevTrack.setNumber(prevTrack.getNumber() + 1);        
    		track.setNumber(track.getNumber() - 1);    		
    		orderTracks();
    		return true;
    	}
    	return false;
    }       

    public boolean moveTrackDown(SongTrack track){  
    	if(track.getNumber() < this.countTracks()){
    		SongTrack nextTrack = getTrack(track.getNumber() + 1);
    		nextTrack.setNumber(nextTrack.getNumber() - 1);        
    		track.setNumber(track.getNumber() + 1);    		
    		orderTracks();
    		return true;
    	}
    	return false;
    }    

    private SongTrack makeNewTrack(){        
        //measures
        List measures = new ArrayList();        
        Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
            MeasureHeader header = (MeasureHeader)it.next();            
            measures.add(new Measure(header,new ArrayList(),new ArrayList(),1,0));
        }
        //Strings
        long number = getNextTrackNumber();
        String name = "Track " + number;
        SongChannel channel = getFreeChannel((short)0,false);
        List strings = createDefaultInstrumentStrings();

        return new SongTrack(number,name,channel,measures,strings,0,RGBColor.RED);
    }
    
    public SongTrack createTrack(){
        SongTrack track = null;
        if(getSong().getTracks().isEmpty()){
            setSong(makeNewSong());
        }else{
            track = makeNewTrack();
        }
        addTrack(track);
        return track;
    }

    public void removeTrack(SongTrack track){
    	removeTrack(track.getNumber());
    }    

    public void changeTimeSignature(long start,TimeSignature timeSignature,boolean toEnd){
        changeTimeSignature(getMeasureHeaderAt(start),timeSignature,toEnd);
    }
    

    public void changeTimeSignature(MeasureHeader header,TimeSignature timeSignature,boolean toEnd){        
        //asigno el nuevo ritmo
    	header.setTimeSignature((TimeSignature)timeSignature.clone());         

        long nextStart = header.getStart() + header.getLength();
        List measures = getMeasureHeadersBeforeEnd(header.getStart() + 1);
        Iterator it = measures.iterator();
        while(it.hasNext()){
            MeasureHeader nextHeader = (MeasureHeader)it.next();
            
            long theMove = nextStart - nextHeader.getStart();

            moveMeasureComponents(nextHeader,theMove,0);
            moveMeasureHeader(nextHeader,theMove,0);

            if(toEnd){           
            	nextHeader.setTimeSignature((TimeSignature)timeSignature.clone());  
            }
            
            nextStart = nextHeader.getStart() + nextHeader.getLength();
        }
                  
    }    

    public void changeTripletFeel(long start,int tripletFeel,boolean toEnd){
    	changeTripletFeel(getMeasureHeaderAt(start),tripletFeel,toEnd);
    }
    

    public void changeTripletFeel(MeasureHeader header,int tripletFeel,boolean toEnd){        
        //asigno el nuevo tripletFeel
    	header.setTripletFeel(tripletFeel);    

        if(toEnd){
            List measures = getMeasureHeadersBeforeEnd(header.getStart() + 1);
            Iterator it = measures.iterator();
            while(it.hasNext()){
                MeasureHeader nextHeader = (MeasureHeader)it.next();
                nextHeader.setTripletFeel(tripletFeel); 
            }            
        }                  
    }    
    
    
    public void changeTempo(long start,Tempo tempo,boolean toEnd){
        changeTempo(getMeasureHeaderAt(start),tempo,toEnd);
    }    
    
    public void changeTempo(MeasureHeader header,Tempo tempo,boolean toEnd){        
        //asigno el nuevo tempo
    	header.setTempo((Tempo)tempo.clone());        

        if(toEnd){
            List measures = getMeasureHeadersBeforeEnd(header.getStart() + 1);
            Iterator it = measures.iterator();
            while(it.hasNext()){
                MeasureHeader nextHeader = (MeasureHeader)it.next();
                nextHeader.setTempo((Tempo)tempo.clone()); 
            }            
        }
        
    }        

    public void changeOpenRepeat(long start){
        MeasureHeader header = getMeasureHeaderAt(start);
        header.setRepeatStart(!header.isRepeatStart());
    }    

    public void changeCloseRepeat(long start,int numberOfRepetitions){
        MeasureHeader header = getMeasureHeaderAt(start);
        header.setNumberOfRepetitions(numberOfRepetitions);
    }    
    
    public void addNewMeasureBeforeEnd(){        
    	MeasureHeader lastHeader = getLastMeasureHeader();    	
        TimeSignature timeSignature = (TimeSignature)lastHeader.getTimeSignature().clone();   
        Tempo tempo = (Tempo)lastHeader.getTempo().clone(); 
        int number = (lastHeader.getNumber() + 1);
        long start = (lastHeader.getStart() + lastHeader.getLength());        
        boolean repeatStart = false;
        int numberOfRepetitions = 0;                    
        int tripletFeel = lastHeader.getTripletFeel();
    	
        MeasureHeader header = new MeasureHeader(number,start,timeSignature,tempo,null,tripletFeel,repeatStart,numberOfRepetitions);    	
    	getSong().getMeasureHeaders().add(header);
    	
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            
            getTrackManager().addNewMeasureBeforeEnd(track,header);            
        }   
        calculateMeasureStartWidthRepetitions();
    }
       

        
    public List getMeasures(long start){
    	List measures = new ArrayList();
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            Measure measure = getTrackManager().getMeasureAt(track,start);
            if(measure != null){
            	measures.add(measure);
            }
        }  
        return measures;
    }    
    
    public SongTrack replaceTrack(SongTrack t){
    	SongTrack track = getTrack(t.getNumber());
    	if(track != null){
    		track.makeEqual(t,getMeasureHeaders());
    	}    	
    	return track;
    }
    
    public TracksMeasures copyMeasures(long p1, long p2){
    	TracksMeasures tracksMeasures = new TracksMeasures(); 
    	tracksMeasures.setMeasureHeaders(getMeasureHeadersBetween(p1,p2));
    	
    	List list = new ArrayList();
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
        	List measures = getTrackManager().copyMeasures(track,p1,p2);
        	tracksMeasures.addTrackMeasure(track.getNumber(),measures);
        }        
        return (TracksMeasures)tracksMeasures.clone();
    }
    
    public TracksMeasures copyMeasures(long p1, long p2,SongTrack track){
    	TracksMeasures tracksMeasures = new TracksMeasures(); 
    	tracksMeasures.setMeasureHeaders(getMeasureHeadersBetween(p1,p2));    	
    	
    	List list = new ArrayList();
        List measures = getTrackManager().copyMeasures(track,p1,p2);
        tracksMeasures.addTrackMeasure(track.getNumber(),measures);
            
        return (TracksMeasures)tracksMeasures.clone();
    }    
    
    
    public void insertMeasures(TracksMeasures tracksMeasures,int fromNumber,long move){       	
    	List measureHeaders = new ArrayList();
    	moveMeasureHeaders(tracksMeasures.getMeasureHeaders(),move,0,false);
    	
    	int headerNumber = fromNumber;
    	Iterator it = tracksMeasures.getMeasureHeaders().iterator();
    	while(it.hasNext()){
    		MeasureHeader header = (MeasureHeader)it.next();
    		header.setNumber(headerNumber);
    		measureHeaders.add(header);
    		headerNumber ++;
    	}    	
    	
    	//-----------------------------
        long start = ((MeasureHeader)measureHeaders.get(0)).getStart(); 
        long end = ((MeasureHeader)measureHeaders.get(measureHeaders.size() - 1)).getStart() + ((MeasureHeader)measureHeaders.get(measureHeaders.size() - 1)).getLength();    	
    	List headersBeforeEnd = getMeasureHeadersBeforeEnd(start);
    	moveMeasureHeaders(headersBeforeEnd,end - start,measureHeaders.size(),true);       
        /*
        it = getMeasureHeadersBeforeEnd(start).iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
            moveMeasureComponents(header,end - start,measureHeaders.size());            
        }
        it= getMeasureHeadersBeforeEnd(start).iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
            moveMeasureHeader(header,end - start,measureHeaders.size(),false);            
        }          
        */
        //---------------------------------------
    	
        it = tracksMeasures.getMeasureHeaders().iterator();
    	while(it.hasNext()){
    		MeasureHeader header = (MeasureHeader)it.next();
    		addMeasureHeader(header.getNumber() - 1,header);
    	}    	        
        
        it = getSong().getTracks().iterator();
        while (it.hasNext()) {
            SongTrack currTrack = (SongTrack) it.next();
            List measures = null;
                        
            Iterator trackMeasureIt = tracksMeasures.getTrackMeasures().iterator();
            while(trackMeasureIt.hasNext()){
            	TrackMeasure trackMeasure = (TrackMeasure)trackMeasureIt.next();
            	if(trackMeasure.getTrack() == currTrack.getNumber()){
            		measures = trackMeasure.getMeasures();
            		break;
            	}
            }            
            if(measures == null){
            	measures = getEmptyMeasures(((TrackMeasure)tracksMeasures.getTrackMeasures().get(0)).getMeasures());
            }             
            
        	for(int i = 0;i < measures.size();i++){
        		Measure measure = (Measure)measures.get(i);
        		measure.setHeader((MeasureHeader)measureHeaders.get(i));
        		getMeasureManager().moveAllComponents(measure,move);        		   	
        	}            

            getTrackManager().insertMeasures(currTrack,measures, fromNumber);
        }                        
        calculateMeasureStartWidthRepetitions();
    }
    
    private List getEmptyMeasures(List measures) {
        List emptyMeasures = new ArrayList();

        Iterator it = measures.iterator();
        while (it.hasNext()) {
            Measure measure = (Measure) it.next();
            int clef = measure.getClef();
            int keySignature = measure.getKeySignature();            
            
            emptyMeasures.add(new Measure(null, new ArrayList(), new ArrayList(),clef,keySignature));
        }
        return emptyMeasures;
    }    
    
    
    public void replaceMeasures(TracksMeasures tracksMeasures,long move) {
    	List measureHeaders = new ArrayList();
    	moveMeasureHeaders(tracksMeasures.getMeasureHeaders(),move,0,false);    	
    	Iterator it = tracksMeasures.getMeasureHeaders().iterator();
    	while(it.hasNext()){
    		MeasureHeader header = (MeasureHeader)it.next();    		
    		measureHeaders.add(replaceMeasureHeader(header));
    	}
    	
        it = tracksMeasures.getTrackMeasures().iterator();
        while(it.hasNext()){
        	TrackMeasure trackMeasure = (TrackMeasure)it.next();
        	
        	SongTrack currTrack = getTrack(trackMeasure.getTrack());
        	List measures = trackMeasure.getMeasures();        	
        	for(int i = 0;i < measures.size();i++){
        		Measure measure = (Measure)measures.get(i);
        		measure.setHeader((MeasureHeader)measureHeaders.get(i));
        		getMeasureManager().moveAllComponents(measure,move);
        		getTrackManager().replaceMeasure(currTrack,measure);        		
        	}
        }        
        calculateMeasureStartWidthRepetitions();        
    }        

    
	   
    public MeasureHeader getFirstMeasureHeader(){
        MeasureHeader firstHeader = null;    
        for(int i = 0;i < getSong().getMeasureHeaders().size();i++){
        	MeasureHeader currHeader = (MeasureHeader)getSong().getMeasureHeaders().get(i);
            if(firstHeader == null || (currHeader.getStart() < firstHeader.getStart())){
            	firstHeader = currHeader;
            }
        }        
        return firstHeader;
    }     

    public MeasureHeader getLastMeasureHeader(){
        int lastIndex = getSong().getMeasureHeaders().size() - 1; 
        return (MeasureHeader)getSong().getMeasureHeaders().get(lastIndex);
    }      
    
    public MeasureHeader getPrevMeasureHeader(MeasureHeader header){
        int prevIndex = header.getNumber() - 1; 
        if(prevIndex > 0){
            return (MeasureHeader)getSong().getMeasureHeaders().get(prevIndex - 1);
        }
        return null;
    }      
    
    public MeasureHeader getNextMeasureHeader(MeasureHeader header){
        int nextIndex = header.getNumber(); 
        if(nextIndex < getSong().getMeasureHeaders().size()){
            return (MeasureHeader)getSong().getMeasureHeaders().get(nextIndex);
        }
        return null;
    }       
  
    public MeasureHeader getMeasureHeaderAt(long start){
        Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();  
            long measureStart = header.getStart();
            long measureLength = header.getLength();
            if(start >= measureStart && start < measureStart + measureLength){
                return header;
            }
        }     
        return null;
    }           
    
    public MeasureHeader getMeasureHeader(int number){
        for (int i = 0; i < getSong().getMeasureHeaders().size(); i++) {
        	MeasureHeader header = (MeasureHeader)getSong().getMeasureHeaders().get(i);            
            if(header.getNumber() == number){
                return header;
            }
        }     
        return null;
    }   
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getMeasureHeadersBeforeEnd(long fromStart) {
        List headers = new ArrayList();        
        Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){           
        	MeasureHeader header = (MeasureHeader)it.next();
            if (header.getStart() >= fromStart) {
            	headers.add(header);
            }
        }
        return headers;
    }         
    
    /**
     * Retorna Todos los desde Start hasta el final del compas
     */
    public List getMeasureHeadersBetween(long p1,long p2) {
        List headers = new ArrayList();        
        Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){           
        	MeasureHeader header = (MeasureHeader)it.next();
            long start = header.getStart();
            if (start >= p1 && start <= p2) {
            	headers.add(header);
            }
        }
        return headers;
    }

    public List getMeasureHeaders(){
        return getSong().getMeasureHeaders();
    }    
    

    public void removeMeasures(long p1,long p2){
    	removeMeasureHeaders(p1,p2);
    }
    
    public void removeLastMeasure(){ 
    	removeLastMeasureHeader();
    }    
    
    public void removeMeasure(long start){
    	removeMeasureHeader(start);
    }
    
    
    
    /**
     * Agrega un Compas
     */
    public void addMeasureHeader(MeasureHeader measure){
        getSong().getMeasureHeaders().add(measure);
    }    
    
    /**
     * Agrega un Compas
     */
    public void addMeasureHeader(int index,MeasureHeader measure){
        getSong().getMeasureHeaders().add(index,measure);
    }        
    
    public void removeMeasureHeaders(long p1,long p2){
        List measures = new ArrayList();
        
        Iterator it = getMeasureHeadersBetween(p1,p2).iterator();
        while(it.hasNext()){
            MeasureHeader measure = (MeasureHeader)it.next();
            removeMeasureHeader(measure);
        }        
    }    
    
    public void removeLastMeasureHeader(){    
        removeMeasureHeader(getLastMeasureHeader());
    }
    
    public void removeMeasureHeader(long start){    
        removeMeasureHeader(getMeasureHeaderAt(start));
    }
    
    public void removeMeasureHeader(MeasureHeader header){        
        long start = header.getStart();
        long length = header.getLength();
        
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            getTrackManager().removeMeasure(track,start);     
        }   
        
        List nextMeasures = getMeasureHeadersBeforeEnd(start + 1);
        moveMeasureHeaders(nextMeasures,-length,-1,true);  
        /*
        it = nextMeasures.iterator();
        while(it.hasNext()){
            MeasureHeader currMeasure = (MeasureHeader)it.next();
            moveMeasureHeader(currMeasure,-length,-1,true);            
        }    
        */
        getSong().getMeasureHeaders().remove(header.getNumber() - 1);  
        
        calculateMeasureStartWidthRepetitions();
    }    
    
    public MeasureHeader replaceMeasureHeader(MeasureHeader newMeasure){    	
    	MeasureHeader measure = getMeasureHeaderAt(newMeasure.getStart());
    	measure.makeEqual((MeasureHeader)newMeasure.clone());
    	//measure.makeEqual(newMeasure);    	

 
    	return measure;
    }
    
    
    public void moveMeasureHeaders(List headers,long theMove,int numberMove,boolean moveComponents) {        
        if(moveComponents){
        	Iterator it = headers.iterator();
        	while(it.hasNext()){
        		MeasureHeader header = (MeasureHeader) it.next();
        		moveMeasureComponents(header,theMove,numberMove);     
        	}
        }    	    	
        Iterator it = headers.iterator();
        while (it.hasNext()) {
            MeasureHeader header = (MeasureHeader) it.next();
            moveMeasureHeader(header,theMove,numberMove);
        }
    }    
    
    /**
     * Mueve el compas
     */
    public void moveMeasureHeader(MeasureHeader header,long theMove,int numberMove){     
    	header.setNumber(header.getNumber() + numberMove);
    	header.setStart(header.getStart() + theMove);
    }    
    
    /**
     * Mueve el compas
     */
    public void moveMeasureComponents(MeasureHeader header,long theMove,int numberMove){     
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();
            getTrackManager().moveMeasure(track,getTrackManager().getMeasure(track,header.getNumber()),theMove,numberMove);     
        }
    }    
    
    
    /** 
     * Retorna true si el start esta en el rango del compas
     */
    public boolean isAtPosition(MeasureHeader header,long start){		
		return (start >= header.getStart() && start < header.getStart() + header.getLength());   	
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    public Marker updateMarker(int number,String title,RGBColor color){    
    	return updateMarker(new Marker(number,title,color));
    }     
    
    public Marker updateMarker(Marker marker){    
    	MeasureHeader header = getMeasureHeader(marker.getMeasure());
    	if(header != null){
    		header.setMarker(marker);
    	}
    	return null;
    }     
    
    public void removeMarker(Marker marker){
    	if(marker != null){
    		removeMarker(marker.getMeasure());
    	}
    }    
    
    public void removeMarker(int number){
    	MeasureHeader header = getMeasureHeader(number);
    	if(header != null && header.hasMarker()){
    		header.setMarker(null);
    	}
    }
    
    public void removeAllMarkers(){ 
    	Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
        	if(header.hasMarker()){
        		header.setMarker(null);
        	}
        }
    }

    public List getMarkers(){ 
    	List markers = new ArrayList();
    	Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
        	if(header.hasMarker()){
        		markers.add(header.getMarker());
        	}
        }  
        return markers;
    }    

    public Marker getMarker(int number){       
    	MeasureHeader header = getMeasureHeader(number);
    	if(header != null && header.hasMarker()){
    		return header.getMarker();
    	}
        return null;
    }      
    
    public Marker getPreviousMarker(int from){
    	MeasureHeader previous = null;    	
    	Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
        	if(header.hasMarker() && header.getNumber() < from){
        		if(previous == null || previous.getNumber() < header.getNumber()){
        			previous = header;
        		}
        	}
        }    	        
    	return (previous != null)?previous.getMarker():null;
    }         
    
    public Marker getNextMarker(int from){
    	MeasureHeader next = null;    	
    	Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
        	if(header.hasMarker() && header.getNumber() > from){
        		if(next == null || next.getNumber() > header.getNumber()){
        			next = header;
        		}
        	}
        }    	        
    	return (next != null)?next.getMarker():null;
    }        

    public Marker getFirstMarker(){
    	MeasureHeader first = null;    	
    	Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
        	if(header.hasMarker()){
        		if(first == null || header.getNumber() < first.getNumber()){
        			first = header;
        		}
        	}
        }    	        
    	return (first != null)?first.getMarker():null;
    }            
    
    public Marker getLastMarker(){
    	MeasureHeader next = null;    	
    	Iterator it = getSong().getMeasureHeaders().iterator();
        while(it.hasNext()){
        	MeasureHeader header = (MeasureHeader)it.next();
        	if(header.hasMarker()){
        		if(next == null || header.getNumber() > next.getNumber()){
        			next = header;
        		}
        	}
        }    	        
    	return (next != null)?next.getMarker():null;
    }        

    
    public void autoCompleteSilences(){
        Iterator it = getSong().getTracks().iterator();
        while(it.hasNext()){
        	SongTrack track = (SongTrack)it.next();      
            getTrackManager().autoCompleteSilences(track);
        }
    }
    
}
