package org.herac.tuxguitar.play.models.tg_player;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;

public class ReceiverImpl implements Receiver{
	private static final int SEQ_MIDIPUTC = 5;
	private static final int DEVICE_PORT = 2;
	private static final String DEVICE_NAME = "/dev/sequencer";
	
	private OutputStream stream;
	
	public ReceiverImpl(){
		open();
	}
	
	public void open(){
		try {
			this.stream = new FileOutputStream(DEVICE_NAME);
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

	public void close() {
		try {
			this.stream.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}	
	
	public void send(MidiMessage message, long timeStamp) {
		try {
			byte[] event = new byte[4];
			byte[] data = message.getMessage();			
			for (int i = 0; i < data.length; i++){
		    	event[0] = SEQ_MIDIPUTC;
		    	event[1] = data[i];
		    	event[2] = DEVICE_PORT;
		    	event[3] = 0;				
		    	this.stream.write(event);
			}			
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

}
