package org.herac.tuxguitar.play.models.defaultplayer;

import javax.sound.midi.Instrument;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;

public class SoundbankImpl implements Soundbank{

	private String name;
	private String version;
	private String vendor;
	private String description;
	private SoundbankResource[] resources;
	private Instrument[] instruments;

	public SoundbankImpl(Soundbank soundbank){
		this.load(soundbank);
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Instrument[] getInstruments() {
		return instruments;
	}

	public void setInstruments(Instrument[] instruments) {
		this.instruments = instruments;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public SoundbankResource[] getResources() {
		return resources;
	}

	public void setResources(SoundbankResource[] resources) {
		this.resources = resources;
	}

	public String getVendor() {
		return vendor;
	}

	public void setVendor(String vendor) {
		this.vendor = vendor;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public Instrument getInstrument(Patch patch) {
		// TODO Auto-generated method stub
		return null;
	}

	
	private void load(Soundbank soundbank){
		setName(soundbank.getName());
		setVersion(soundbank.getVersion());
		setVendor(soundbank.getVendor());
		setDescription(soundbank.getDescription());
		
		this.resources = new SoundbankResource[soundbank.getResources().length];
		for(int i = 0;i < soundbank.getResources().length;i ++){
			SoundbankResource resource = soundbank.getResources()[i];
			this.resources[i] = new SoundbankResourceImpl(this,resource.getName(),resource.getDataClass(),resource.getData());
		}
		
		this.instruments = new Instrument[soundbank.getInstruments().length];
		for(int i = 0;i < soundbank.getInstruments().length;i ++){
			Instrument instrument = soundbank.getInstruments()[i];
			Patch patch = new Patch(0,i);
			this.instruments[i] = new InstrumentImpl(this,patch,instrument.getName(),instrument.getDataClass(),instrument.getData());
		}
	}
	
}
class InstrumentImpl extends Instrument{
	private Object data;
	
	protected InstrumentImpl(Soundbank soundbank, Patch patch, String name, Class<?> dataClass,Object data) {
		super(soundbank, patch, name, dataClass);
		this.data = data;
	}

	public Object getData() {
		return data;
	}
	
}

class SoundbankResourceImpl extends SoundbankResource{
	private Object data;
	
	public SoundbankResourceImpl(Soundbank soundBank, String name, Class<?> dataClass,Object data) {
		super(soundBank, name, dataClass);
		this.data = data;
	}
	
	protected SoundbankResourceImpl(Soundbank soundBank, String name, Class<?> dataClass) {
		super(soundBank, name, dataClass);
	}
	

	public Object getData() {
		return data;
	}
	
}