package org.herac.tuxguitar.play.models.defaultplayer;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

public class MidiMessageUtils {
		
	private static ShortMessage message = new ShortMessage();
	
	public static MidiMessage noteOn(int channel,int note,int velocity){				
		try {
			message.setMessage(ShortMessage.NOTE_ON, channel, note, velocity);
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static MidiMessage noteOff(int channel,int note,int velocity){				
		try {			
			message.setMessage(ShortMessage.NOTE_OFF, channel, note, velocity);
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}	
	
	public static MidiMessage controlChange(int channel,int controller,int value){				
		try {
			message.setMessage(ShortMessage.CONTROL_CHANGE,channel,controller,value);
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
	
	public static MidiMessage programChange(int channel,int instrument){				
		try {
			message.setMessage(ShortMessage.PROGRAM_CHANGE, channel, instrument, 0);
			return message;
		} catch (InvalidMidiDataException e) {
			e.printStackTrace();
		}
		return null;
	}
	
}
