/*
 * Created on 16-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TGOutputStream extends TGStream{
    private static final String TG_VERSION = "TG_DEVEL-0.8";
    private DataOutputStream dataOutputStream;       
    
    public TGOutputStream(FileOutputStream file) throws FileNotFoundException {
        this.dataOutputStream = new DataOutputStream(file);
    }

    public TGOutputStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(new File(fileName)));
    }
    
    public void write(Song song){        
        try {
            this.writeVersion();
            this.writeSong(song);
            this.dataOutputStream.flush();
            this.dataOutputStream.close();
        } catch (IOException e) {            
            e.printStackTrace();
        }
    }

    private void writeVersion(){
        writeString(TG_VERSION);
    }
    
    
    private void writeSong(Song song){
        //escribo el nombre
        writeString(song.getName());
        
        //escribo el interprete
        writeString(song.getInterpret());
        
        //escribo el album
        writeString(song.getAlbum());

        //escribo el autor
        writeString(song.getAuthor());        
        
        //escribo la cantidad de measure headers 
        writeShort((short)song.getMeasureHeaders().size());
        
        //escribo las pistas
        MeasureHeader lastHeader = null;
        for(int i = 0;i < song.getMeasureHeaders().size();i++){
        	MeasureHeader header = (MeasureHeader)song.getMeasureHeaders().get(i);
            writeMeasureHeader(header,lastHeader);
            
            lastHeader = header;
        }        
        
        //escribo la cantidad de pistas 
        writeByte(song.getTracks().size());
        
        //escribo las pistas
        for(int i = 0;i < song.getTracks().size();i++){
            SongTrack track = (SongTrack)song.getTracks().get(i);
            writeTrack(track);
        }
        
    }
    
    private void writeTrack(SongTrack track){    	
    	//escribo el nombre
    	writeString(track.getName());
    	
        //escribo el canal
    	writeChannel(track.getChannel());

        //escribo los compases
    	Measure lastMeasure = null;
        Iterator measureIt  = track.getMeasures().iterator();
        while(measureIt.hasNext()){
            Measure measure = (Measure)measureIt.next();
            writeMeasure(measure,lastMeasure);
            lastMeasure = measure;
        }                       
        
        //escribo la cantidad de cuerdas 
        writeByte(track.getStrings().size());        
        
        //escribo las cuerdas
        Iterator stringIt  = track.getStrings().iterator();
        while(stringIt.hasNext()){
            InstrumentString string = (InstrumentString)stringIt.next();
            writeInstrumentString(string);
        }       
        
        //escribo el offset
        writeByte(track.getOffset() - SongTrack.MIN_OFFSET);
        
        //escribo el color
        writeRGBColor(track.getColor());
    }
    
    

    private void writeMeasureHeader(MeasureHeader measureheader,MeasureHeader lastMeasureHeader){
    	int header = 0;
    	if(lastMeasureHeader == null){
    		header |= MEASURE_HEADER_TIMESIGNATURE;
    		header |= MEASURE_HEADER_TEMPO;
    		if(measureheader.getTripletFeel() != MeasureHeader.TRIPLET_FEEL_NONE){ 
    			header |= MEASURE_HEADER_TRIPLET_FEEL;    			
    		}
    	}else{
    		//Time Signature
    		int numerator = measureheader.getTimeSignature().getNumerator();
    		int value = measureheader.getTimeSignature().getDenominator().getValue();
    		int prevNumerator = lastMeasureHeader.getTimeSignature().getNumerator();
    		int prevValue = lastMeasureHeader.getTimeSignature().getDenominator().getValue();            
    		if(numerator != prevNumerator || value != prevValue){
    			header |= MEASURE_HEADER_TIMESIGNATURE;
    		}     		
    		//Tempo
    		if(measureheader.getTempo().getValue() != lastMeasureHeader.getTempo().getValue()){
    			header |= MEASURE_HEADER_TEMPO;
    		}
    		//Triplet Feel
    		if(measureheader.getTripletFeel() != lastMeasureHeader.getTripletFeel()){
    			header |= MEASURE_HEADER_TRIPLET_FEEL;
    		}
    	}
    	header = (measureheader.isRepeatStart())?header |= MEASURE_HEADER_OPEN_REPEAT:header;
    	header = (measureheader.getNumberOfRepetitions() > 0)?header |= MEASURE_HEADER_CLOSE_REPEAT:header;
    	header = (measureheader.hasMarker())?header |= MEASURE_HEADER_MARKER:header;    	
    	
    	writeHeader(header);

        //escribo el timeSignature      
        if(((header & MEASURE_HEADER_TIMESIGNATURE) != 0)){
        	writeTimeSignature(measureheader.getTimeSignature());
        }
        
        //escribo el tempo
        if(((header & MEASURE_HEADER_TEMPO) != 0)){
        	writeTempo(measureheader.getTempo());                         
        }
        
        //escribo el numero de repeticiones
        if(((header & MEASURE_HEADER_CLOSE_REPEAT) != 0)){
        	writeShort((short)measureheader.getNumberOfRepetitions());
        }
                
        //escribo el marker
        if(((header & MEASURE_HEADER_MARKER) != 0)){
        	writeMarker(measureheader.getMarker());
        }
        
        //escribo el triplet feel
        if(((header & MEASURE_HEADER_TRIPLET_FEEL) != 0)){
        	writeByte(measureheader.getTripletFeel());
        }    
    }        
    
    
    private void writeMeasure(Measure measure,Measure lastMeasure){      
    	int header = 0;    	
    	if(lastMeasure == null){
    		header |= MEASURE_CLEF;
    		header |= MEASURE_KEYSIGNATURE;
    	}else{
    		//Clef
    		if(measure.getClef() != lastMeasure.getClef()){
    			header |= MEASURE_CLEF;
    		}     		
    		//KeySignature
    		if(measure.getKeySignature() != lastMeasure.getKeySignature()){
    			header |= MEASURE_KEYSIGNATURE;
    		}                    	     	     	
    	}    	    	
    	writeHeader(header);
    	

        List components = getMeasureComponents(measure);
		//escribo la cantidad de notas 
		writeShort((short)components.size());        
    
		//escribo las cuerdas
		Component lastComponent = null;
		Iterator it  = components.iterator();
		while(it.hasNext()){
			Component component = (Component)it.next();
			writeComponent(component,lastComponent);
			lastComponent = component;
		}     	        

        //escribo la clave
        if(((header & MEASURE_CLEF) != 0)){
        	writeByte(measure.getClef());
        }
    	
        //escribo el key signature
        if(((header & MEASURE_KEYSIGNATURE) != 0)){
        	writeByte(measure.getKeySignature());
        }
    }    

    private void writeChannel(SongChannel channel){                
    	int header = 0;    	
    	header = (channel.isSolo())?header |= CHANNEL_SOLO:header;
    	header = (channel.isMute())?header |= CHANNEL_MUTE:header;
    	writeHeader(header);
    	
        //escribo el canal        
        writeByte(channel.getChannel());

        //escribo el canal de efectos        
        writeByte(channel.getEffectChannel());
        
        //escribo el instrumento        
        writeByte(channel.getInstrument());
        
        //escribo el volumen        
        writeByte(channel.getVolume());
        
        //escribo el balance        
        writeByte(channel.getBalance());
        
        //escribo el chorus        
        writeByte(channel.getChorus());
        
        //escribo el reverb        
        writeByte(channel.getReverb());
        
        //escribo el phaser        
        writeByte(channel.getPhaser());
        
        //escribo el tremolo        
        writeByte(channel.getTremolo());        
    }      

    private void writeComponent(Component component,Component lastComponent){        
    	int header = 0;
    	if(component instanceof Note){
    		Note note = (Note)component;    		
    		header |= COMPONENT_NOTE;
        	header = (note.isTiedNote())?header |= COMPONENT_TIEDNOTE:header;
        	header = (note.getEffect().hasEffects() || note.getEffect().isDeadNote())?header |= COMPONENT_EFFECT:header;
    	}else if(component instanceof Silence){
    		header |= COMPONENT_SILENCE;
    	}
    	header = (lastComponent == null || component.getStart() != lastComponent.getStart())?header |= COMPONENT_NEXT_BEAT:header;
    	header = (lastComponent == null || !component.getDuration().isEqual(lastComponent.getDuration()))?header |= COMPONENT_NEXT_DURATION:header;
    	
    	writeHeader(header);

        //escribo la duracion
    	if(((header & COMPONENT_NEXT_DURATION) != 0)){
    		writeDuration(component.getDuration());
    	}
        if(((header & COMPONENT_NOTE) != 0)){
        	Note note = (Note)component;  
        	
        	//escribo el valor
        	writeByte(note.getValue());
        
        	//escribo el velocity
        	writeByte(note.getVelocity());
        
        	//escribo la cuerda
        	writeByte(note.getString());
        
        	//escribo los efectos
        	if(((header & COMPONENT_EFFECT) != 0)){
        		writeNoteEffect(note.getEffect());
        	}        
        }
    }    
    
    
    private void writeInstrumentString(InstrumentString string){        
        //escribo el valor
    	writeByte(string.getValue());                          
    }
    
    
    private void writeTempo(Tempo tempo){
        //escribo el valor
    	writeShort((short)tempo.getValue());
    }    
    
    
    private void writeTimeSignature(TimeSignature timeSignature){
        //escribo el numerador
    	writeByte(timeSignature.getNumerator());
        
        //escribo el denominador
        writeDuration(timeSignature.getDenominator());
    }
    
    private void writeDuration(Duration duration){        
        int header = 0;
    	header = (duration.isDotted())?header |= DURATION_DOTTED:header;    	
    	header = (duration.isDoubleDotted())?header |= DURATION_DOUBLE_DOTTED:header;        
    	header = (!duration.getTupleto().isEqual(Duration.NO_TUPLETO))?header |= DURATION_TUPLETO:header;
        writeHeader(header);
        
        //escribo el valor
    	writeByte(duration.getValue());
    	
        //escribo el tupleto
    	if(((header & DURATION_TUPLETO) != 0)){
    		writeTupleto(duration.getTupleto());
    	}
    }    
    
    private void writeTupleto(Tupleto tupleto){                
        //escribo los enters
    	writeByte(tupleto.getEnters());
        
        //escribo los tiempos
    	writeByte(tupleto.getTimes());
    }       
    
    
    private void writeNoteEffect(NoteEffect effect){
    	int header = 0;
    	
    	header = (effect.isVibrato())?header |= EFFECT_VIBRATO:header;
    	
    	header = (effect.isBend())?header |= EFFECT_BEND:header;
    	
    	header = (effect.isDeadNote())?header |= EFFECT_DEAD_NOTE:header;
    	
    	header = (effect.isSlide())?header |= EFFECT_SLIDE:header;
    	
    	header = (effect.isHammer())?header |= EFFECT_HAMMER:header;
    	
    	//escribo el header
    	writeHeader(header);
    	
    	//escribo el bend
    	if(((header & EFFECT_BEND) != 0)){
            writeBendEffect(effect.getBend());
        }
    }    
    
    private void writeBendEffect(BendEffect bend){        
        //escribo la cantidad de puntos
        writeByte(bend.getPoints().size());
        
        Iterator it = bend.getPoints().iterator();
        while(it.hasNext()){
            BendEffect.BendPoint point = (BendEffect.BendPoint)it.next();
            
            //escribo la posicion
            writeByte(point.getPosition());
            
            //escribo el valor
            writeByte(point.getValue());            
        }        
    }
    
    private void writeMarker(Marker marker){
    	//escribo el titulo
    	writeString(marker.getTitle());
    	
    	//escribo el color
        writeRGBColor(marker.getColor());        
    }    
    
    private void writeRGBColor(RGBColor color){                
        //escribo el RGB
        writeShort((short)color.getR());
        writeShort((short)color.getG());
        writeShort((short)color.getB());
    }   
    
    
    
    private List getMeasureComponents(Measure measure){
        List components = new ArrayList();
        components.addAll(measure.getNotes());
        components.addAll(measure.getSilences());    	
    	
        for(int i = 0;i < components.size();i++){
            Component minComponent = null;
            for(int j = i;j < components.size();j++){
                Component component = (Component)components.get(j);
                if(minComponent == null || component.getStart() < minComponent.getStart()){
                    minComponent = component;
                }
            }
            components.remove(minComponent);
            components.add(i,minComponent);
        }
        return components;
    }    
    
    public void writeByte(int v){
        try {
            this.dataOutputStream.write(v);            
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }      
    
    private void writeString(String v){
        try {        	
            this.dataOutputStream.write(v.length());
            this.dataOutputStream.writeChars(v);
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }
    
    public void writeHeader(int v){
        try {
            this.dataOutputStream.write(v);            
        } catch (IOException e) {            
            e.printStackTrace();
        }                
    }    
    
    public void writeShort(short v){
        try {       	
            this.dataOutputStream.writeShort(v);              
        } catch (IOException e) {            
            e.printStackTrace();
        } 
    }    

}
