/*
 * Created on 16-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.RGBColor;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.Tupleto;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TGInputStream extends TGStream{
    private static final String TG_VERSION = "TG_DEVEL-0.8";
    private DataInputStream dataInputStream;
    private String version;

    public TGInputStream(FileInputStream file) throws FileNotFoundException {
        this.dataInputStream = new DataInputStream(file);
    }

    public TGInputStream(String fileName) throws FileNotFoundException {        
        this(new FileInputStream(new File(fileName)));             
    }          
    
    public boolean isSupportedVersion(String version){
    	return (version.equals(TG_VERSION));
    }
    
    public boolean isSupportedVersion(){
    	try{
    		readVersion();
    		return isSupportedVersion(version);
    	}catch(Exception e){
    		return false;
    	}catch(Error e){
    		return false;
    	}    	
    }    
    
    public Song read(){        
        try {     
            this.readVersion();
            Song song = this.readSong();            
            this.dataInputStream.close();
            return song;
        } catch (IOException e) {
            e.printStackTrace();
        }        
        return null;
    }
    
    private void readVersion(){
    	if(this.version == null){
    		this.version = readString();
    	}
    }

    private Song readSong(){
        //leo el nombre
        String name = readString();
        
        //leo el interprete
        String interpret = readString();
        
        //leo el album
        String album = readString();

        //leo el autor
        String author = readString();
        
        //leo la cantidad de measure headers
        int headerCount = readShort();
        
        //leo las pistas
        long headerStart = 1000;
        MeasureHeader lastHeader = null;
        List headers = new ArrayList(headerCount);
        for(int i = 0;i < headerCount;i++){
        	MeasureHeader header = readMeasureHeader(i + 1,headerStart,lastHeader);
        	headers.add(header);
        	headerStart += header.getLength();
        	lastHeader = header;
        }        
        
        //leo la cantidad de pistas
        int trackCount = readByte();
        
        //leo las pistas
        List tracks = new ArrayList(trackCount);
        for(int i = 0;i < trackCount;i++){
            tracks.add(readTrack(i + 1,headers));
        }
        
        return new Song(name,interpret,album,author,tracks,headers,Song.MAX_VOLUME);
    }
    
    private SongTrack readTrack(int number,List headers){
    	//leo el nombre
    	String name = readString();
    	
        //leo el canal
    	SongChannel channel = readChannel();
    
        //leo la cantidad de compases
    	int measureCount = headers.size();
    	
        //leo los compases
    	Measure lastMeasure = null;
        List measures = new ArrayList(measureCount);
        for(int i = 0;i < measureCount;i++){
        	Measure measure = readMeasure((MeasureHeader)headers.get(i),lastMeasure);
            measures.add(measure);
            lastMeasure = measure;
        }                        
        
        //leo la cantidad de cuerdas
        int stringCount = readByte();
        
        //leo las cuerdas
        List strings = new ArrayList(stringCount);
        for(int i = 0;i < stringCount;i++){
            strings.add(readInstrumentString(i + 1));
        }        
        
        //leo el offset
        int offset = (SongTrack.MIN_OFFSET + readByte());
        
        //leo el color
        RGBColor color = readRGBColor();
        
        return new SongTrack(number,name,channel,measures,strings,offset,color);
    }
    
    private MeasureHeader readMeasureHeader(int number,long start,MeasureHeader lastMeasureHeader){
    	int header = readHeader();
    	
        //leo el time signature
        TimeSignature timeSignature = null;
        if(((header & MEASURE_HEADER_TIMESIGNATURE) != 0)){
        	timeSignature = readTimeSignature();
        }else{
        	timeSignature = (TimeSignature)lastMeasureHeader.getTimeSignature().clone(); 
        }        
        
        //leo el tempo
        Tempo tempo = null;        
        if(((header & MEASURE_HEADER_TEMPO) != 0)){
        	tempo = readTempo();
        }else{
        	tempo = (Tempo)lastMeasureHeader.getTempo().clone();
        }        
        
        //leo el comienzo de la repeticion
        boolean repeatStart = ((header & MEASURE_HEADER_OPEN_REPEAT) != 0);           
        
        //leo el numero de repeticiones
        int numberOfRepetitions = 0;
        if(((header & MEASURE_HEADER_CLOSE_REPEAT) != 0)){
        	numberOfRepetitions = readShort();   
        }
        
        //leo el marker
        Marker marker = null;
        if(((header & MEASURE_HEADER_MARKER) != 0)){
        	marker = readMarker(number);
        }
        
        int tripletFeel = ((lastMeasureHeader != null)?lastMeasureHeader.getTripletFeel():MeasureHeader.TRIPLET_FEEL_NONE);
        if(((header & MEASURE_HEADER_TRIPLET_FEEL) != 0)){
        	tripletFeel = readByte();
        }
        
        return new MeasureHeader(number,start,timeSignature,tempo,marker,tripletFeel,repeatStart,numberOfRepetitions);
        
    }    
    
    private Measure readMeasure(MeasureHeader measureHeader,Measure lastMeasure){
    	int header = readHeader();

    	List notes = new ArrayList();
    	List silences = new ArrayList();
    	
		//leo la cantidad de componentes
    	Component lastComponent = null;
		int componentCount = readShort();
		for(int i = 0;i < componentCount;i++){
			lastComponent = readComponent(measureHeader,notes,silences,lastComponent);
    	}		

        //leo la clave
        int clef = 0;
        if(((header & MEASURE_CLEF) != 0)){
        	clef = readByte();
        }else{
        	clef = lastMeasure.getClef();
        }     	
    	
    	//leo el key signature
        int keySignature = 0;
        if(((header & MEASURE_KEYSIGNATURE) != 0)){
        	keySignature = readByte();
        }else{
        	keySignature = lastMeasure.getKeySignature();
        } 
        
        return new Measure(measureHeader,notes,silences,clef,keySignature);
        
    }    
    
    private SongChannel readChannel(){     
    	int header = readHeader();
    	
        //leo el canal        
        short channel = (short)readByte();
        
        //leo el canal de efectos        
        short effectChannel = (short)readByte();
        
        //leo el instrumento        
        short instrument = (short)readByte();
        
        //leo el volumen        
        short volume = (short)readByte();
        
        //leo el balance        
        short balance = (short)readByte();
        
        //leo el chorus        
        short chorus = (short)readByte();
        
        //leo el reverb        
        short reverb = (short)readByte();
        
        //leo el phaser        
        short phaser = (short)readByte();
        
        //leo el tremolo        
        short tremolo = (short)readByte();
        
        //leo el solo        
        boolean solo = ((header & CHANNEL_SOLO) != 0);
        
        //leo el mute        
        boolean mute = ((header & CHANNEL_MUTE) != 0);
        
        return new SongChannel(channel,effectChannel,instrument,volume,balance,chorus,reverb,phaser,tremolo,solo,mute);
    }      

    private Component readComponent(MeasureHeader measure,List notes,List silences,Component lastComponent){        
    	int header = readHeader();
        
        //leo el start
    	long start = 0;
    	if(lastComponent == null){
    		start = measure.getStart();
    	}else if(((header & COMPONENT_NEXT_BEAT) != 0)){
    		start = (lastComponent.getStart() + lastComponent.getDuration().getTime());
    	}else{
    		start = lastComponent.getStart();
    	}    	
    	
        //leo la duracion
    	Duration duration = null;
    	if(((header & COMPONENT_NEXT_DURATION) != 0)){
    		duration = readDuration();    	
    	}else{
    		duration = (Duration)lastComponent.getDuration().clone();
    	}
        if(((header & COMPONENT_NOTE) != 0)){
        	//leo el valor
        	int value = readByte();
        
        	//leo el velocity
        	int velocity = readByte();
        
        	//leo la cuerda
        	int string = readByte();    
        
        	//leo la ligadura
        	boolean tiedNote = ((header & COMPONENT_TIEDNOTE) != 0);
        
        	//leo los efectos
        	NoteEffect effect = new NoteEffect();
        	if(((header & COMPONENT_EFFECT) != 0)){
        		effect = readNoteEffect();
        	}
        	
        	Note note = new Note(value,start,duration,velocity,string,tiedNote,effect);
        	notes.add(note);
        	return note;
        }else if(((header & COMPONENT_SILENCE) != 1)){
        	Silence silence = new Silence(start,duration); 
        	silences.add(silence);
        	return silence;
        }
        return null;
    }        
    
    private InstrumentString readInstrumentString(int number){
        //leo el valor
    	int value = readByte();       
                
        return new InstrumentString(number,value);
    }           
    
    private Tempo readTempo(){
        //leo el valor
    	int value = readShort();
        
        return new Tempo(value);
    }    
    
    
    private TimeSignature readTimeSignature(){
        //leo el numerador
    	int numerator = readByte();
        
        //leo el denominador
        Duration denominator = readDuration();
        
        return new TimeSignature(numerator,denominator); 
    }
    
    private Duration readDuration(){
        int header = readHeader();        
        boolean dotted = ((header & DURATION_DOTTED) != 0);
        boolean doubleDotted = ((header & DURATION_DOUBLE_DOTTED) != 0);
        
        //leo el valor
    	int value = readByte();

        //leo el tupleto
    	Tupleto tupleto = Duration.NO_TUPLETO;
    	if(((header & DURATION_TUPLETO) != 0)){
    		tupleto = readTupleto();
    	}
        return new Duration(value,dotted,doubleDotted,tupleto);
    }    
    
    private Tupleto readTupleto(){                
        //leo los enters
    	int enters = readByte();
        
        //leo los tiempos
    	int times = readByte();
        
        return new Tupleto(enters,times);
    }           
    
    private NoteEffect readNoteEffect(){
        NoteEffect effect = new NoteEffect();
        
        int header = readHeader();
        
        //leo el vibrato
        effect.setVibrato(((header & EFFECT_VIBRATO) != 0));
        
        //leo el bend
        if(((header & EFFECT_BEND) != 0)){
            effect.setBend(readBendEffect());
        }
                
        //leo la nota muerta
    	effect.setDeadNote(((header & EFFECT_DEAD_NOTE) != 0));
        
        //leo el slide
    	effect.setSlide(((header & EFFECT_SLIDE) != 0));
        
        //leo el hammer
    	effect.setHammer(((header & EFFECT_HAMMER) != 0));
        
        return effect;
    }
    
    private BendEffect readBendEffect(){
        BendEffect bend = new BendEffect();
        
        //leo la cantidad de puntos
        int count = readByte();
        
        for(int i = 0;i < count;i++){            
            //leo la posicion
            int position = readByte();
            
            //leo el valor
            int value = readByte();
            
            //agrego el punto
            bend.addPoint(position,value);
        }        
        return bend;
    }
    
    private Marker readMarker(int measure){                
        //leo el titulo
        String title = readString();
    	
        //leo el color
        RGBColor color = readRGBColor();
        
    	return new Marker(measure,title,color);
    }      
    
    private RGBColor readRGBColor(){                
        //escribo el RGB
        int r = readShort();
        int g = readShort();
        int b = readShort();
        
        return new RGBColor(r,g,b);
    }   
    
    
    private int readByte(){
        try {
            return this.dataInputStream.read();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
          
    
    private int readHeader(){
        try {
            return this.dataInputStream.read();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }
        
    
    private short readShort(){        	
    	try {
			return this.dataInputStream.readShort();
		} catch (IOException e) {
			e.printStackTrace();
		}        
		return 0;
    }
    
    private String readString(){
        try {
            int length = this.dataInputStream.read();
            char[] chars = new char[length];
            for(int i = 0;i < chars.length; i++){
                chars[i] = this.dataInputStream.readChar();
            }
            return String.copyValueOf(chars);
        } catch (IOException e) {            
            e.printStackTrace();
        }
        return null;
        
    }        
    
}
