/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.io.gp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.tab.TablatureUtil;
import org.herac.tuxguitar.song.models.BendEffect;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.MeasureHeader;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongChannel;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;
import org.herac.tuxguitar.song.models.RGBColor;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class GP5OutputStream {
    private static final String GP5_VERSION = "FICHIER GUITAR PRO v5.00";

    private OutputStream outputStream;

    public GP5OutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeSong(Song song) throws IOException {
        try {
            SongTrack firstTrack = null;
            Measure firstMeasure = null;
            int numberOfTracks = song.getTracks().size();
            if (numberOfTracks > 0) {
                firstTrack = (SongTrack) song.getTracks().get(0);
            }

            int numberOfMeasures = 0;
            if (firstTrack != null) {
                numberOfMeasures = firstTrack.getMeasures().size();
            }
            if (numberOfMeasures > 0) {
                firstMeasure = (Measure) firstTrack.getMeasures().get(0);
            }

            //version
            writeStringByte(GP5_VERSION, 30);
            //title
            writeStringIntegerPlusOne(song.getName());
            //subtitle
            writeStringIntegerPlusOne("");
            //interpret
            writeStringIntegerPlusOne(song.getInterpret());
            //album
            writeStringIntegerPlusOne(song.getAlbum());
            //songAuthor
            writeStringIntegerPlusOne(song.getAuthor());
            //music
            writeStringIntegerPlusOne("");
            //copyright
            writeStringIntegerPlusOne("");
            //pieceAuthor
            writeStringIntegerPlusOne("");
            //instructions
            writeStringIntegerPlusOne("");

            //notes
            writeInt(0);
            
            //tripletFeel
            //writeBoolean(false);
            
            //-----------------------------------------------------
            writeInt(0);
            for (int i = 0; i < 5; i++) {
                writeInt(1);
                writeStringInteger("");
            }
            //----------------------------------------------------

            skipBytes(30);
            for (int i = 0; i < 11; i++) {
            	writeInt(0);
            	writeStringByte("",0);
            }  
            
            
            //tempo
            Tempo tempo = new Tempo(120);
            if (firstMeasure != null) {
                tempo = (Tempo) firstMeasure.getTempo().clone();
            }
            writeInt(tempo.getValue());
            //key
            writeByte((byte)0);

            //octave
            writeInt(0);
            
            
            SongChannel[] channels = makeChannels(song);
            for (int i = 0; i < channels.length; i++) {
                //instrument
                writeInt(channels[i].getInstrument());
                //volume
                writeByte(toChannelByte(channels[i].getVolume()));
                //balance
                writeByte(toChannelByte(channels[i].getBalance()));
                //chorus
                writeByte(toChannelByte(channels[i].getChorus()));
                //reverb
                writeByte(toChannelByte(channels[i].getReverb()));
                //phaser
                writeByte(toChannelByte(channels[i].getPhaser()));
                //tremolo
                writeByte(toChannelByte(channels[i].getTremolo()));

                byte[] b = { 0, 0 };
                this.outputStream.write(b);
            }
            skipBytes(42);
            
            //numberOfMeasures
            writeInt(numberOfMeasures);
            //numberOfTracks
            writeInt(numberOfTracks);

            createMeasures(song.getMeasureHeaders());
            
            createTracks(song.getTracks());

            skipBytes(2);
            
            for (int i = 0; i < numberOfMeasures; i++) {
                for (int j = 0; j < numberOfTracks; j++) {
                    SongTrack track = (SongTrack) song.getTracks().get(j);
                    Measure measure = (Measure) track.getMeasures().get(i);

                    addMeasureComponents(track.getStrings().size(), measure, tempo);
                    skipBytes(1);
                }
            }

            this.outputStream.flush();
            this.outputStream.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMeasures(List measures) throws IOException {
        TimeSignature timeSignature = new TimeSignature(0, new Duration(0));
        if (measures.size() > 0) {
            for (int i = 0; i < measures.size(); i++) {
            	if(i > 0 ){
            		skipBytes(1);
            	}
                MeasureHeader measure = (MeasureHeader) measures.get(i);
                createMeasureHeader(measure, timeSignature);

                timeSignature.setNumerator(measure.getTimeSignature().getNumerator());
                timeSignature.getDenominator().setValue(measure.getTimeSignature().getDenominator().getValue());
            }
        }
    }

    private void createMeasureHeader(MeasureHeader measure, TimeSignature currTimeSignature) throws IOException {
        //-----------------------
        int header = 0;
        //numerator
        if (measure.getTimeSignature().getNumerator() != currTimeSignature.getNumerator()) {
            header |= 0x01;
        }
        //denominator
        if (measure.getTimeSignature().getDenominator().getValue() != currTimeSignature.getDenominator().getValue()) {
            header |= 0x02;
        }
        //repeatStart
        if (measure.isRepeatStart()) {
            header |= 0x04;
        }

        //numberOfRepetitions
        if (measure.getNumberOfRepetitions() > 0) {
            header |= 0x08;
        }
        
        //marker
        if (measure.hasMarker()) {
            header |= 0x20;
        }        
        
        writeUnsignedByte(header);
        //---------------------------------------------
        if ((header & 0x01) != 0) {
            //numerator
            writeByte((byte) measure.getTimeSignature().getNumerator());
        }

        if ((header & 0x02) != 0) {
            //denominator
            writeByte((byte) measure.getTimeSignature().getDenominator().getValue());
        }

        if ((header & 0x08) != 0) {
            //numberOfRepetitions
            writeByte((byte) measure.getNumberOfRepetitions());
        }

        if ((header & 0x20) != 0) {
        	//marker
        	writeMarker(measure.getMarker());
        }   
        int numberOfAlternateEnding = 0;
        if(numberOfAlternateEnding == 0){
        	skipBytes(1);	
        }   
              
        if ((header & 0x01) != 0) {
        	skipBytes(4);          	
        }
        
        //triplet feel
        byte gpTripletFeel = 0;
        if(measure.getTripletFeel() == MeasureHeader.TRIPLET_FEEL_EIGHTH){
        	gpTripletFeel = (byte)1;
        }else if(measure.getTripletFeel() == MeasureHeader.TRIPLET_FEEL_SIXTEENTH){
        	gpTripletFeel = (byte)2;
        }
        writeByte(gpTripletFeel);
        //skipBytes(1);  
    }

    private void createTracks(List tracks) throws IOException {
        for (int i = 0; i < tracks.size(); i++) {
            SongTrack track = (SongTrack) tracks.get(i);
            createTrack(track);
        }
    }

    private void createTrack(SongTrack track) throws IOException {
        //---------------------------------------------
        int header = 0;

        //numberOfRepetitions
        if (track.isPercussionTrack()) {
            header |= 0x01;
        }

        writeUnsignedByte(header);
        //---------------------------------------------
        skipBytes(1);
        
        //name
        writeStringByte(track.getName(), 40);

        //numberOfStrings
        writeInt(track.getStrings().size());

        for (int i = 0; i < 7; i++) {
            int value = 0;
            if (track.getStrings().size() > i) {
                InstrumentString string = (InstrumentString) track.getStrings().get(i);
                value = string.getValue();
            }
            writeInt(value);
        }

        //port
        writeInt(1);

        //channel
        writeInt(track.getChannel().getChannel() + 1);

        //effects
        writeInt(track.getChannel().getEffectChannel() + 1);

        //numberOfFrets
        writeInt(24);

        //capo
        writeInt(0);

        //color
        writeColor(track.getColor());

        skipBytes(44);
    }

    private void addMeasureComponents(int strings, Measure measure, Tempo tempo) throws IOException, GPFormatException {
        List beats = getBeats(measure);
        //numberOfBeats
        writeInt(beats.size());

        for (int i = 0; i < beats.size(); i++) {
            MeasureBeat beat = (MeasureBeat) beats.get(i);
            addNotes(beat, strings, measure, tempo);
        }
        
        writeInt(0);
/*
        writeInt(beats.size());

        for (int i = 0; i < beats.size(); i++) {
            MeasureBeat beat = (MeasureBeat) beats.get(i);
            addNotes(beat, strings, measure, tempo);
        }
        */
    }
    
    private void addNotes(MeasureBeat beat, int strings, Measure measure, Tempo songTempo) throws IOException, GPFormatException {
        Duration duration = beat.getDuration();
        //---------------------------------------------
        int header = 0;

        if (duration.isDotted()) {
            header |= 0x01;
        }
        if (!duration.getTupleto().isEqual(Duration.NO_TUPLETO)) {
            header |= 0x20;
        }
        if (measure.getTempo().getValue() != songTempo.getValue()) {
            header |= 0x10;
        }
        NoteEffect effect = null;
        if (beat.isSilence()) {
            header |= 0x40;
        }
        writeUnsignedByte(header);
        //---------------------------------------------

        if ((header & 0x40) != 0) {
            writeUnsignedByte(0x02);
        }

        //duration value
        writeByte(parseDuration(duration));

        if ((header & 0x20) != 0) {
            //tupleto
            writeInt(duration.getTupleto().getEnters());
        }

        if ((header & 0x10) != 0) {
            writeMixChange(measure.getTempo());
        }

        int stringHeader = 0;
        if (!beat.isSilence()) {

            for (int i = 0; i < beat.getNotes().size(); i++) {
                Note playedNote = (Note) beat.getNotes().get(i);
                int string = (7 - playedNote.getString());
                stringHeader |= (1 << string);
            }
        }

        writeUnsignedByte(stringHeader);

        for (int i = 0; i < beat.getNotes().size(); i++) {
            Note playedNote = (Note) beat.getNotes().get(i);
            writeNote(playedNote);
        }

        
        skipBytes(2);
    }

    private void writeNote(Note note) throws IOException {
        int header = 0x20;
        if (note.getEffect().hasEffects()) {
            header |= 0x08;
        }
        writeUnsignedByte(header);

        if ((header & 0x20) != 0) {
            int typeHeader = 0x01;
            if (note.isTiedNote()) {
                typeHeader = 0x02;
            }else if(note.getEffect().isDeadNote()){
            	typeHeader = 0x03;
            }
            writeUnsignedByte(typeHeader);
        }

        if ((header & 0x20) != 0) {
            writeByte((byte) note.getValue());
        }

        skipBytes(1);
        if ((header & 0x08) != 0) {
            writeNoteEffects(note.getEffect());
        }

    }

    private byte parseDuration(Duration duration) {
        byte value = 0;
        switch (duration.getValue()) {
        case Duration.WHOLE:
            value = -2;
            break;
        case Duration.HALF:
            value = -1;
            break;
        case Duration.QUARTER:
            value = 0;
            break;
        case Duration.EIGHTH:
            value = 1;
            break;
        case Duration.SIXTEENTH:
            value = 2;
            break;
        case Duration.THIRTY_SECOND:
            value = 3;
            break;
        case Duration.SIXTY_FOURTH:
            value = 4;
            break;
        }
        return value;
    }

    private void writeNoteEffects(NoteEffect effect) throws IOException {
        int header1 = 0;
        int header2 = 0;
        if (effect.isBend()) {
            header1 |= 0x01;
        }
        if (effect.isHammer()) {
            header1 |= 0x02;
        }
        if (effect.isSlide()) {
            header2 |= 0x08;
            
        }
        if (effect.isVibrato()) {
            header2 |= 0x40;
        }        
        writeUnsignedByte(header1);
        writeUnsignedByte(header2);
        
        if ((header1 & 0x01) != 0) {
            writeBend(effect.getBend());
        }
        if ((header2 & 0x08) != 0) {
            writeByte((byte)0);
        }
    }

    private void writeBend(BendEffect bend) throws IOException {
        //type
        writeByte((byte) 0);
        //value
        writeInt(0);

        int numPoints = bend.getPoints().size();
        writeInt(numPoints);

        for (int i = 0; i < numPoints; i++) {
            BendEffect.BendPoint point = (BendEffect.BendPoint) bend.getPoints().get(i);

            int bendPosition = (int) (point.getPosition() * 60 / BendEffect.MAX_POSITION_LENGTH);
            int bendValue = (point.getValue() * 100 / 8);

            //bendPosition
            writeInt(bendPosition);
            //bendValue
            writeInt(bendValue);
            //bendVibrato
            writeByte((byte) 0);
        }

    }

    private void writeMixChange(Tempo tempo) throws IOException {
        for (int i = 0; i < 7; i++) {
            writeByte((byte) -1);
            
        }
        writeInt(tempo.getValue());
        
        writeByte((byte) 0);   
        
        //apply to all tracks
        writeUnsignedByte(1);
    }


    private void writeMarker(Marker marker) throws IOException {
        writeStringIntegerPlusOne(marker.getTitle());    	
    	writeColor(marker.getColor());
    }
    
    private List getBeats(Measure measure) {
        boolean hasSilences = (!measure.getSilences().isEmpty());
        orderNotes(measure);
        List beats = new ArrayList();
        MeasureBeat beat = null;
        Iterator it = null;
        //-----notas---------------------------------------
        it = measure.getNotes().iterator();
        while (it.hasNext()) {
            Note note = (Note) it.next();
            if (beat == null) {
                beat = new MeasureBeat(note.getDuration(), note.getStart());
            }

            //verifico si tengo que autocompletar silencios
            if (!hasSilences) {
                if (beats.isEmpty() && beat.getStart() != measure.getStart()) {
                    long silenceLength = (beat.getStart() - measure.getStart());
                    if (silenceLength > 10) {
                        createSilenceBeats(beats, (beat.getStart() + beat.getDuration().getTime()), silenceLength);
                    }
                }
            }

            //verifico si termino el beat
            if (note.getStart() != beat.getStart()) {
                beats.add(beat);

                //verifico si tengo que autocompletar silencios
                if (!hasSilences) {
                    long silenceLength = (note.getStart() - (beat.getStart() + beat.getDuration().getTime()));
                    if (silenceLength > 10) {
                        createSilenceBeats(beats, (beat.getStart() + beat.getDuration().getTime()), silenceLength);
                    }
                }
                //creo el siguiente beat
                beat = new MeasureBeat(note.getDuration(), note.getStart());
            }
            beat.addNote(note);
        }
        if (beat != null) {
            beats.add(beat);
        }

        //agrego los silencios
        if (hasSilences) {
            it = measure.getSilences().iterator();
            while (it.hasNext()) {
                Silence silence = (Silence) it.next();
                beats.add(new MeasureBeat(silence.getDuration(), silence.getStart()));
            }
        }

        //ordeno los beats
        for (int i = 0; i < beats.size(); i++) {
            MeasureBeat minBeat = null;
            for (int beatIdx = i; beatIdx < beats.size(); beatIdx++) {
                MeasureBeat currBeat = (MeasureBeat) beats.get(beatIdx);
                if (minBeat == null || currBeat.getStart() < minBeat.getStart()) {
                    minBeat = currBeat;
                }
            }
            beats.remove(minBeat);
            beats.add(i, minBeat);
        }

        return beats;
    }

    private void createSilenceBeats(List beats, long start, long length) {
        List durations = TablatureUtil.createDurations(length);
        Iterator it = durations.iterator();
        while (it.hasNext()) {
            Duration duration = (Duration) it.next();
            beats.add(new MeasureBeat(duration, start));
            start += duration.getTime();
        }
    }

    private void orderNotes(Measure measure) {
        for (int i = 0; i < measure.getNotes().size(); i++) {
            Note minNote = null;
            for (int noteIdx = i; noteIdx < measure.getNotes().size(); noteIdx++) {
                Note note = (Note) measure.getNotes().get(noteIdx);
                if (minNote == null || (note.getStart() < minNote.getStart())
                        || (note.getStart() == minNote.getStart() && (note.getString() < minNote.getString()))) {
                    minNote = note;
                }
            }
            measure.getNotes().remove(minNote);
            measure.getNotes().add(i, minNote);
        }
    }
    
    private SongChannel[] makeChannels(Song song) {
        SongChannel[] channels = new SongChannel[64];
        for (int i = 0; i < channels.length; i++) {
            channels[i] = new SongChannel((short)i,(short)i, (short) 24, (short) 13, (short) 8, (short) 0, (short) 0, (short) 0, (short) 0,false,false);
        }

        Iterator it = song.getTracks().iterator();
        while (it.hasNext()) {
            SongTrack track = (SongTrack) it.next();
            channels[track.getChannel().getChannel()].setInstrument(track.getChannel().getInstrument());
            channels[track.getChannel().getChannel()].setVolume(track.getChannel().getVolume());            
            channels[track.getChannel().getChannel()].setBalance(track.getChannel().getBalance());            
            channels[track.getChannel().getEffectChannel()].setInstrument(track.getChannel().getInstrument());            
            channels[track.getChannel().getEffectChannel()].setVolume(track.getChannel().getVolume());
            channels[track.getChannel().getEffectChannel()].setBalance(track.getChannel().getBalance());
        }

        return channels;
    }

    private void writeColor(RGBColor color) throws IOException {
        //red
        writeUnsignedByte(color.getR());
        //green
        writeUnsignedByte(color.getG());
        //blue
        writeUnsignedByte(color.getB());

        this.outputStream.write(0);
    }

    //-----------------------------------------------------------------------------------
    private void skipBytes(int count) throws IOException {
    	for(int i = 0;i < count;i++){
    		this.outputStream.write(0);
    	}
    }
    
    private void writeBoolean(boolean v) throws IOException {
        this.outputStream.write(v ? 1 : 0);
    }
    
    private void writeByte(byte v) throws IOException {
        this.outputStream.write(v);
    }

    private void writeUnsignedByte(int v) throws IOException {
        this.outputStream.write(v);
    }

    private void writeStringByte(String v, int expectedLength) throws IOException {
        byte[] bytes = v.getBytes();

        this.writeUnsignedByte(bytes.length);

        if (expectedLength != 0) {
            byte[] tempBytes = new byte[expectedLength];
            for (int i = 0; i < bytes.length; i++) {
                tempBytes[i] = bytes[i];
            }
            bytes = tempBytes;
        }
        this.outputStream.write(bytes);
    }

    private void writeStringIntegerPlusOne(String v) throws IOException {
        byte[] b = v.getBytes();

        this.writeInt(b.length + 1);
        this.outputStream.write(b.length);
        this.outputStream.write(b);
    }

    private void writeStringInteger(String v) throws IOException {
        byte[] bytes = v.getBytes();
        this.writeInt(bytes.length);
        this.outputStream.write(bytes);
    }

    private void writeInt(int v) throws IOException {
        byte[] bytes = new byte[4];
        bytes[0] = (byte) (v & 0x00FF);
        bytes[1] = (byte) ((v >> 8) & 0x000000FF);
        bytes[2] = (byte) ((v >> 16) & 0x000000FF);
        bytes[3] = (byte) ((v >> 24) & 0x000000FF);

        this.outputStream.write(bytes);
    }

    //-----------------------------------------------------------------------------------

    private class MeasureBeat {
        private Duration duration;
        private List notes;
        private boolean silence;
        private long start;

        public MeasureBeat(Duration duration, long start) {
            this.duration = duration;
            this.start = start;
            this.notes = new ArrayList();
            this.silence = true;
        }

        public long getStart() {
            return start;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public Duration getDuration() {
            return duration;
        }

        public void addNote(Note note) {
            this.getNotes().add(note);
            this.silence = false;
        }

        public List getNotes() {
            return notes;
        }

        private boolean isSilence() {
            return silence;
        }

    }


    private byte toChannelByte(short s){
    	s = (short)((s * (short)16) / (short)127);
    	s = (s <= 16)?s:16;
    	return (byte)s;
    }
}