/*
 * Created on 08-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.util;

import java.io.File;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FileChooser {
    
    public static FilterFormat OPEN_FORMAT = instance().new FilterFormat(new String[] {  "*.tg;*.gp3;*.gp4;*.gp5;*.ptb" },new String[] {  "Suported Files (*.tg,*.gp3,*.gp4,*.gp5,*.ptb)"});
    
    public static FilterFormat IMPORT_MIDI_FORMAT = instance().new FilterFormat(new String[] { "*.mid" },new String[] { "Suported Files (*.mid)" });    
    
    public static FilterFormat SAVE_FORMAT = instance().new FilterFormat(new String[] { "*.gp4", "*.gp3", "*.tg" },null);
    
    public static FilterFormat EXPORT_MIDI_FORMAT = instance().new FilterFormat(new String[] { "*.mid" },null);
    
    public static FilterFormat EXPORT_PDF_FORMAT = instance().new FilterFormat(new String[] { "*.pdf" },null);
    
    public static FilterFormat EXPORT_ASCII_FORMAT = instance().new FilterFormat(new String[] { "*.tab" },null);
    
    public static FilterFormat ALL_FORMAT = instance().new FilterFormat(null,null);
	
	private static FileChooser instance;
	private String path;
	
    public FileChooser() {
    }    

    public static FileChooser instance() {
    	if(instance == null){
    		instance = new FileChooser();
    	}
		return instance;
	}
	
    public String open(Shell parent,FilterFormat format,String fileName) {
        FileDialog dialog = new FileDialog(parent,SWT.OPEN);

        dialog.setFilterPath(getPath());
        dialog.setFileName("*");        
        dialog.setFilterNames(format.filterNames);        
        dialog.setFilterExtensions(format.filterExtensions);        
        
        String path = dialog.open();
        setPath(path);
        
        return path;
    }
    
    public String save(Shell parent, FilterFormat format,String fileName) {
        FileDialog dialog = new FileDialog(parent,SWT.SAVE);
        
        dialog.setFilterPath(getPath());
        dialog.setFileName(fileName);
        dialog.setFilterNames(format.filterNames);
        dialog.setFilterExtensions(format.filterExtensions);
        
        String path = dialog.open();
        setPath(path);

        return path;
    }    

    private String getPath(){
    	return this.path;
    }
    
    private void setPath(String path){
    	if(path != null && path.length() > 0){
    		this.path = new File(path).getParent();
    	}
    }
        
    
    private class FilterFormat{
    	private String[] filterExtensions;
    	private String[] filterNames;
		
    	private FilterFormat(String[] filterExtensions, String[] filterNames) {
			this.filterExtensions = filterExtensions;
			this.filterNames = filterNames;
		}    	    	
    }
}