package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableTrackGeneric implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private UndoTrack undoTrack;
	private RedoTrack redoTrack;
	
	private UndoableTrackGeneric(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		redoTrack.redo();
		this.redoCaret.update();
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}		        
		undoTrack.undo();		
		this.undoCaret.update();
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
   
    
    public static UndoableTrackGeneric startUndo(SongTrack track){
    	Caret caret = getCaret(); 
    	UndoableTrackGeneric undoable = new UndoableTrackGeneric();	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.undoTrack = undoable.new UndoTrack(track);	
    	
    	return undoable;
    }
    
    public UndoableTrackGeneric endUndo(SongTrack track){    
    	Caret caret = getCaret(); 
    	this.redoCaret = new UndoableCaretHelper();
		this.redoTrack = new RedoTrack(track);	
		return this;
    }
    
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
    
    private class UndoTrack{
    	private SongTrack track;
    	
    	public UndoTrack(SongTrack track){
    		if(track != null){
    			this.track = (SongTrack)track.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders());
    		}
    	}
    	
    	public void undo(){    
    		if(this.track != null){
    			TuxGuitar.instance().getSongManager().replaceTrack(track);    			
    			TuxGuitar.instance().fireUpdate();   
    			TuxGuitar.instance().getMixer().update();
    		}
    	}
    }
    
    private class RedoTrack{
    	private SongTrack track;
    	
    	public RedoTrack(SongTrack track){
    		if(track != null){
    			this.track = (SongTrack)track.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders());
    		}
    	}
    	
    	public void redo(){
    		if(this.track != null){
    			TuxGuitar.instance().getSongManager().replaceTrack(track);    			
    			TuxGuitar.instance().fireUpdate();
    			TuxGuitar.instance().getMixer().update();
    		}
    	}
    }
}
