package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableRemoveTrack implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private SongTrack undoableTrack;
	
	private UndoableRemoveTrack(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		TuxGuitar.instance().getSongManager().removeTrack(this.undoableTrack);
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}			
		TuxGuitar.instance().getSongManager().addTrack((SongTrack)this.undoableTrack.clone(TuxGuitar.instance().getSongManager().getMeasureHeaders()));
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableRemoveTrack startUndo(){
    	UndoableRemoveTrack undoable = new UndoableRemoveTrack();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();	    	    	
    	undoable.undoableTrack = caret.getSongTrackCoords().getTrack();
    	
    	return undoable;
    }
    
    public UndoableRemoveTrack endUndo(){
    	this.redoCaret = new UndoableCaretHelper();
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
