package org.herac.tuxguitar.gui.undo.undoables.track;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableInstrumentTrack implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private long trackNumber;
	private short undoInstrument;
	private short redoInstrument;
	private boolean undoPercusion;
	private boolean redoPercusion;
	
	private UndoableInstrumentTrack(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}   
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.getTrackManager().changeInstrument(manager.getTrack(trackNumber),redoInstrument,redoPercusion);
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();
		this.redoCaret.update();		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}					
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.getTrackManager().changeInstrument(manager.getTrack(trackNumber),undoInstrument,undoPercusion);
		TuxGuitar.instance().fireUpdate();
		TuxGuitar.instance().getMixer().update();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableInstrumentTrack startUndo(SongTrack track){
    	UndoableInstrumentTrack undoable = new UndoableInstrumentTrack();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();	    	    	
    	undoable.trackNumber = track.getNumber();
    	undoable.undoInstrument = track.getChannel().getInstrument();
    	undoable.undoPercusion = track.isPercussionTrack();
    	
    	return undoable;
    }
    
    public UndoableInstrumentTrack endUndo(SongTrack track){
    	this.redoCaret = new UndoableCaretHelper();	    	    	
    	this.redoInstrument = track.getChannel().getInstrument();
    	this.redoPercusion = track.isPercussionTrack();
    	
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
