package org.herac.tuxguitar.gui.undo.undoables.measure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.helpers.TracksMeasures;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Marker;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableRemoveMeasure implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;
	private long p1;
	private long p2;	
	private TracksMeasures tracksMeasures;
	private UndoMarkers undoMarkers;
	
	public UndoableRemoveMeasure(long p1,long p2){
    	Caret caret = getCaret();    	    	
    	this.doAction = UNDO_ACTION;
    	this.undoCaret = new UndoableCaretHelper();
    	this.p1 = p1;
    	this.p2 = p2;
    	this.tracksMeasures = TuxGuitar.instance().getSongManager().copyMeasures(p1,p2);
    	this.undoMarkers = new UndoMarkers();	
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		TuxGuitar.instance().getSongManager().removeMeasures(this.p1,this.p2);    
		TuxGuitar.instance().fireUpdate();
		
		this.redoCaret.update();				
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}			
		int fromNumber = 0;
		SongManager manager = TuxGuitar.instance().getSongManager();
		Measure fromMeasure = manager.getTrackManager().getMeasureAt(manager.getFirstTrack(),this.p1);
		if(fromMeasure == null){
			fromNumber = manager.getTrackManager().getLastMeasure(manager.getFirstTrack()).getNumber() + 1;
		}else{
			fromNumber = fromMeasure.getNumber();
		}
		 
		manager.insertMeasures((TracksMeasures)tracksMeasures.clone(),fromNumber,0);

		TuxGuitar.instance().fireUpdate();
		this.undoMarkers.undo();	
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  
    
    public UndoableRemoveMeasure endUndo(){
    	this.redoCaret = new UndoableCaretHelper();
    	return this;
    }

    
    private class UndoMarkers{
    	private List markers;
    	
    	public UndoMarkers(){
    		this.markers = new ArrayList();    		
    		Iterator it = TuxGuitar.instance().getSongManager().getMarkers().iterator();
    		while(it.hasNext()){
    			this.markers.add(((Marker)it.next()).clone());
    		}
    	}
    	
    	public void undo(){    
    		TuxGuitar.instance().getSongManager().removeAllMarkers();
    		Iterator it = this.markers.iterator();
    		while(it.hasNext()){
    			Marker marker = (Marker)it.next();
    			TuxGuitar.instance().getSongManager().updateMarker((Marker)marker.clone());
    		}    		
    	}
    }        
}
