package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;

public class UndoableChangeTripletFeel implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private long position;		
	private int redoableTripletFeel;
	private int undoableTripletFeel;
	private List nextTripletFeelPositions;
	private boolean toEnd;
	
	private UndoableChangeTripletFeel(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		TuxGuitar.instance().getSongManager().changeTripletFeel(position,redoableTripletFeel,toEnd);
		TuxGuitar.instance().fireUpdate();
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}	
		SongCoords songCoords = getCaret().getSongCoords();
		TuxGuitar.instance().getSongManager().changeTripletFeel(position,undoableTripletFeel,this.toEnd);
		if(this.toEnd){
			Iterator it = this.nextTripletFeelPositions.iterator();
			while(it.hasNext()){		
				TripletFeelPosition tfp = (TripletFeelPosition)it.next();
				TuxGuitar.instance().getSongManager().changeTripletFeel(tfp.getPosition(),tfp.getTripletFeel(),true);
			}
		}
		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableChangeTripletFeel startUndo(){
    	UndoableChangeTripletFeel undoable = new UndoableChangeTripletFeel();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.position = caret.getPosition();
    	undoable.undoableTripletFeel = caret.getMeasureCoords().getMeasure().getTripletFeel();
    	undoable.nextTripletFeelPositions = new ArrayList();    	
    	
    	int prevTripletFeel = undoable.undoableTripletFeel;
    	Iterator it = caret.getSongCoords().getFirstTrack().getMeasuresCoords().iterator();
    	while(it.hasNext()){
    		MeasureCoords measureCoords = (MeasureCoords)it.next();
    		if(measureCoords.getMeasure().getStart() > undoable.position){
    			int currTripletFeel = measureCoords.getMeasure().getTripletFeel();                           
                if(prevTripletFeel != currTripletFeel){
                	TripletFeelPosition tfp = undoable.new TripletFeelPosition(measureCoords.getMeasure().getStart(),currTripletFeel);
                	undoable.nextTripletFeelPositions.add(tfp);
                }    			
                prevTripletFeel = currTripletFeel;
    		}
    	}    	
    	return undoable;
    }
    
    public UndoableChangeTripletFeel endUndo(int tripletFeel,boolean toEnd){
    	this.redoCaret = new UndoableCaretHelper();
    	this.redoableTripletFeel = tripletFeel;
    	this.toEnd = toEnd;
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  
    
    
    private class TripletFeelPosition{
    	private long position;
    	private int tripletFeel;
    	
		public TripletFeelPosition(long position,int tripletFeel) {
			this.position = position;
			this.tripletFeel = tripletFeel;
		}
		public long getPosition() {
			return position;
		}
		public int getTripletFeel() {
			return tripletFeel;
		}    	
    }
}
