package org.herac.tuxguitar.gui.undo.undoables.custom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongCoords;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.TimeSignature;

public class UndoableChangeTimeSignature implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private long position;		
	private TimeSignature redoableTimeSignature;
	private TimeSignature undoableTimeSignature;
	private List nextTimeSignaturePositions;
	private boolean toEnd;
	
	private UndoableChangeTimeSignature(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		TuxGuitar.instance().getSongManager().changeTimeSignature(position,(TimeSignature)redoableTimeSignature.clone(),toEnd);
		TuxGuitar.instance().fireUpdate();
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}	
		SongCoords songCoords = getCaret().getSongCoords();
		TuxGuitar.instance().getSongManager().changeTimeSignature(position,(TimeSignature)undoableTimeSignature.clone(),this.toEnd);
		if(this.toEnd){
			Iterator it = this.nextTimeSignaturePositions.iterator();
			while(it.hasNext()){		
				TimeSignaturePosition tsp = (TimeSignaturePosition)it.next();
				TuxGuitar.instance().getSongManager().changeTimeSignature(tsp.getPosition(),(TimeSignature)tsp.getTimeSignature().clone(),true);
			}
		}
		TuxGuitar.instance().fireUpdate();
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableChangeTimeSignature startUndo(){
    	UndoableChangeTimeSignature undoable = new UndoableChangeTimeSignature();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.position = caret.getPosition();
    	undoable.undoableTimeSignature = (TimeSignature)caret.getMeasureCoords().getMeasure().getTimeSignature().clone();
    	undoable.nextTimeSignaturePositions = new ArrayList();    	
    	
    	TimeSignature prevTimeSignature = undoable.undoableTimeSignature;
    	Iterator it = caret.getSongCoords().getFirstTrack().getMeasuresCoords().iterator();
    	while(it.hasNext()){
    		MeasureCoords measureCoords = (MeasureCoords)it.next();
    		if(measureCoords.getMeasure().getStart() > undoable.position){
    			TimeSignature currTimeSignature = measureCoords.getMeasure().getTimeSignature();
                int numerator = prevTimeSignature.getNumerator();
                int value = prevTimeSignature.getDenominator().getValue();
                int currNumerator = currTimeSignature.getNumerator();
                int currValue = currTimeSignature.getDenominator().getValue();            
                if(numerator != currNumerator || value != currValue){
                	TimeSignaturePosition tsp = undoable.new TimeSignaturePosition(measureCoords.getMeasure().getStart(),(TimeSignature)currTimeSignature.clone());
                	undoable.nextTimeSignaturePositions.add(tsp);
                }    			
                prevTimeSignature = currTimeSignature;
    		}
    	}
    	
    	return undoable;
    }
    
    public UndoableChangeTimeSignature endUndo(TimeSignature timeSignature,boolean toEnd){
    	this.redoCaret = new UndoableCaretHelper();
    	this.redoableTimeSignature = (TimeSignature)timeSignature.clone();
    	this.toEnd = toEnd;
    	return this;
    }
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  
    
    
    private class TimeSignaturePosition{
    	private long position;
    	private TimeSignature timeSignature;
    	
		public TimeSignaturePosition(long position, TimeSignature timeSignature) {
			this.position = position;
			this.timeSignature = timeSignature;
		}
		public long getPosition() {
			return position;
		}
		public TimeSignature getTimeSignature() {
			return timeSignature;
		}    	
    }
}
