package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;

public class UndoableChangeOpenRepeat implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;		
	private long position;	
	
	private UndoableChangeOpenRepeat(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        		
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.changeOpenRepeat(position);
		Measure measure = manager.getTrackManager().getMeasureAt(manager.getFirstTrack(),position);
		TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false);
		this.redoCaret.update();
		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}	
		SongManager manager = TuxGuitar.instance().getSongManager();
		manager.changeOpenRepeat(position);
		Measure measure = manager.getTrackManager().getMeasureAt(manager.getFirstTrack(),position);
		TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false);
		this.undoCaret.update();
		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
      
    public static UndoableChangeOpenRepeat startUndo(){
    	UndoableChangeOpenRepeat undoable = new UndoableChangeOpenRepeat();
    	Caret caret = getCaret();    	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.position = caret.getPosition();    	
    	
    	return undoable;
    }
    
    public UndoableChangeOpenRepeat endUndo(){
    	this.redoCaret = new UndoableCaretHelper();
    	return this;
    }    
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }  

}
