package org.herac.tuxguitar.gui.undo.undoables.custom;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.gui.undo.undoables.UndoableCaretHelper;
import org.herac.tuxguitar.song.models.Marker;

public class UndoableChangeMarker implements UndoableEdit{
	private int doAction;
	private UndoableCaretHelper undoCaret;
	private UndoableCaretHelper redoCaret;	
	private Marker undoMarker;
	private Marker redoMarker;
	
	private UndoableChangeMarker(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		if(redoMarker != null){
			TuxGuitar.instance().getSongManager().updateMarker((Marker)redoMarker.clone());
		}else if(undoMarker != null){
			TuxGuitar.instance().getSongManager().removeMarker((Marker)undoMarker.clone());
		}
		this.redoCaret.update();
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}		        
		if(undoMarker != null){
			TuxGuitar.instance().getSongManager().updateMarker((Marker)undoMarker.clone());
		}else if(redoMarker != null){
			TuxGuitar.instance().getSongManager().removeMarker((Marker)redoMarker.clone());
		}
		this.undoCaret.update();
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
   
    
    public static UndoableChangeMarker startUndo(Marker marker){
    	Caret caret = getCaret(); 
    	UndoableChangeMarker undoable = new UndoableChangeMarker();	    	
    	undoable.doAction = UNDO_ACTION;
    	undoable.undoCaret = new UndoableCaretHelper();
    	undoable.undoMarker = (marker == null)?null:(Marker)marker.clone();
    	
    	return undoable;
    }
    
    public UndoableChangeMarker endUndo(Marker marker){    
    	Caret caret = getCaret(); 
    	this.redoCaret = new UndoableCaretHelper();    	
    	this.redoMarker = (marker == null)?null:(Marker)marker.clone();
		return this;
    }
    
    
    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
    

}
