package org.herac.tuxguitar.gui.undo.undoables.component;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.SongTrack;

public class UndoableComponentChange implements UndoableEdit{
	private int doAction;
	private long trackNumber;
	private long caretPosition;
	private int caretString;
	private UndoComponent undoComponent;
	private RedoComponent redoComponent;
	
	private UndoableComponentChange(){
		
	}
	
	public void redo() throws CannotRedoException {	
		if(!canRedo()){
			throw new CannotRedoException();
		}        
		redoComponent.redo();		
		this.doAction = UNDO_ACTION;
	}

	public void undo() throws CannotUndoException {
		if(!canUndo()){
			throw new CannotUndoException();
		}		        
		undoComponent.undo();		
		this.doAction = REDO_ACTION;
	}

    public boolean canRedo() {
        return (doAction == REDO_ACTION);
    }

    public boolean canUndo() {
        return (doAction == UNDO_ACTION);
    }
   
    
    
    public static UndoableComponentChange startUndo(){    	    	
    	Caret caret = getCaret();   	
    	MeasureComponent undoComponent = caret.getMeasureCoords().getComponentOrSilence(caret.getPosition(),caret.getSelectedString().getNumber());
    	
    	UndoableComponentChange undoable = new UndoableComponentChange();
    	undoable.doAction = UNDO_ACTION;
    	undoable.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
    	undoable.caretPosition = caret.getPosition();
    	undoable.caretString = caret.getSelectedString().getNumber();
    	undoable.undoComponent = undoable.new UndoComponent(((undoComponent == null)?null:undoComponent.getComponent()));	
    	
    	return undoable;
    }
    
    public static UndoableComponentChange startUndo(Component component){    	    	
    	Caret caret = getCaret();   	
    	
    	UndoableComponentChange undoable = new UndoableComponentChange();
    	undoable.doAction = UNDO_ACTION;
    	undoable.trackNumber = caret.getSongTrackCoords().getTrack().getNumber();
    	undoable.caretPosition = caret.getPosition();
    	undoable.caretString = caret.getSelectedString().getNumber();
    	undoable.undoComponent = undoable.new UndoComponent(component);	
    	
    	return undoable;
    }
    
    public UndoableComponentChange endUndo(Component component){    	    	
		this.redoComponent = new RedoComponent(component);	
		return this;
    }

    private static Caret getCaret(){
    	return TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
    }
    
    private class UndoComponent{
    	private Component component;
    	
    	public UndoComponent(Component component){
    		if(component != null){
    			this.component = (Component)component.clone();
    		}
    	}
    	
    	public void undo(){
    		SongManager manager = TuxGuitar.instance().getSongManager();
    		SongTrack track = manager.getTrack(trackNumber);
    		Measure measure = manager.getTrackManager().getMeasureAt(track,caretPosition);    	
    		if(measure != null){
    			if(this.component instanceof Note){
    				manager.getMeasureManager().addNote(measure,(Note)component.clone());
    			}else if(this.component instanceof Silence){
    				manager.getMeasureManager().addSilence(measure,(Silence)component.clone());
    			}else{
    				manager.getMeasureManager().removeComponentsAt(measure,caretPosition,caretString,true);
    			}    			
    			
    			TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false); 
    			getCaret().update(trackNumber,caretPosition,caretString);
    		}
    	}
    }
    
    private class RedoComponent{
    	private Component component;
    	
    	public RedoComponent(Component component){
    		if(component != null){
    			this.component = (Component)component.clone();
    		}
    	}
    	
    	public void redo(){
    		SongManager manager = TuxGuitar.instance().getSongManager();
    		SongTrack track = manager.getTrack(trackNumber);
    		Measure measure = manager.getTrackManager().getMeasureAt(track,caretPosition);     		    		    		
			if(this.component instanceof Note){
				manager.getMeasureManager().addNote(measure,(Note)component.clone());
			}else if(this.component instanceof Silence){
				manager.getMeasureManager().addSilence(measure,(Silence)component.clone());
			}else{
				manager.getMeasureManager().removeComponentsAt(measure,caretPosition,caretString,true);
			}
    		
			TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(measure.getNumber(),false); 
			getCaret().update(trackNumber,caretPosition,caretString);
    	}
    }
}
