/*
 * Created on 04-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.QuarterSpanHelper;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.tab.Tablature;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.SongTrack;


/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class ViewLayout {	
	public static final int MODE_PAGE = 1;
	public static final int MODE_LINEAR = 2; 
	public static final int DEFAULT_MODE = MODE_LINEAR;
	
	public static final boolean AUTO_SPACING_ENABLED = TuxGuitar.instance().getConfig().getBooleanConfigValue(PropertyNames.AUTO_SPACING_ENABLE);
	protected static final int MIN_SCORE_TAB_SPAN =  TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.MIN_SCORE_TABLATURE_SPAN);
	protected static final int DEFAULT_SCORE_LINE_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.SCORE_LINE_SPAN);	
	protected static final int DEFAULT_SCORE_SPAN = ((DEFAULT_SCORE_LINE_SPAN * 5) + MIN_SCORE_TAB_SPAN);
	private static final int DEFAULT_FIRST_TRACK_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.FIRST_TRACK_SPAN);
	protected static final int DEFAULT_TRACK_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.TRACK_SPAN);
	protected static final int DEFAULT_STRING_SPAN = TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.TAB_LINE_SPAN);

    private Tablature tablature; 
    private SongManager songManager;        
    private boolean multitrack;
    private boolean scoreEnabled;
    private List quarterSpanHelpers;
    private int width;
    private int height;
 
    
    public ViewLayout(Tablature tablature,SongManager songManager,boolean multitrack,boolean scoreEnabled){
        this.tablature = tablature;
        this.songManager = songManager;
        this.multitrack = multitrack;
        this.scoreEnabled = scoreEnabled;
        this.quarterSpanHelpers = new ArrayList();  
    }
    
    public abstract void paintSong(GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintTracks(List tracksCoords,GC gc,Rectangle clientArea,int fromX,int fromY);
    public abstract void paintMeasures(SongTrackCoords trackCoords,List measuresCoords,GC gc,int fromX, int fromY,Rectangle clientArea);    
    //public abstract SongTrackCoords getTrackAt(List tracksCoords,int y,int vScroll);
    public abstract void followMeasure(MeasureCoords measure,boolean redraw);
    
    public void paintMeasure(MeasureCoords measureCoords,GC gc,int fromX,int fromY,int span,Rectangle clientArea) {
        measureCoords.setSpan(span);                
        measureCoords.paintMeasure(this,gc,fromX,fromY,clientArea);
    }    
    
    public void updateSong(){    	
        createTracks();
        updateTracks();       
        updateCaret();
    }
    
    public void createTracks() {
        getTablature().getSongCoords().getTrackCoords().clear();        
        getQuarterSpans().clear();   
        
        for (int trackIdx = 0; trackIdx < getSongManager().getSong().getTracks().size(); trackIdx++) {
            SongTrack track = (SongTrack) getSongManager().getSong().getTracks().get(trackIdx);
            SongTrackCoords trackCoords = new SongTrackCoords(getTablature(),getSongManager(), track);
            createMeasures(trackCoords);
            getTablature().getSongCoords().getTrackCoords().add(trackCoords);            
        }
    }    
    
    public void updateTracks() {
        int height = 0;
        int maxWidth = 0;

        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            updateMeasures(trackCoords);
            if(trackCoords.getWidth() > maxWidth){
                maxWidth = trackCoords.getWidth();
            }
            height += trackCoords.getHeight() + DEFAULT_TRACK_SPAN;
           
        } 
        songManager.calculateMeasureStartWidthRepetitions();
    }    
    
    public void createMeasures(SongTrackCoords trackCoords) {
        long caretPosition = getTablature().getCaret().getPosition();
        
        trackCoords.getMeasuresCoords().clear();
        for (int measureIdx = 0; measureIdx < trackCoords.getTrack().getMeasures().size(); measureIdx++) {
            Measure measure = (Measure) trackCoords.getTrack().getMeasures().get(measureIdx);
            MeasureCoords measureCoords = new MeasureCoords(getSongManager(),getTablature(), measure,trackCoords);            
            measureCoords.create(this);                                    
            trackCoords.getMeasuresCoords().add(measureCoords);
            
            if(getQuarterSpans().size() > measureIdx){                                
                getQuarterSpan(measureIdx).setQuarterSpan(measureCoords.getQuarterSpan());
            }else{
                addQuarterSpan(new QuarterSpanHelper(measureCoords.getQuarterSpan()));
            }
        }
    }
    
    public void updateMeasures(SongTrackCoords trackCoords) {
        //int width = 0;
        //int maxHeight = 0;
    	int posX = 0;
        for (int measureIdx = 0; measureIdx < trackCoords.getMeasuresCoords().size(); measureIdx++) {
            MeasureCoords measureCoords =  (MeasureCoords) trackCoords.getMeasuresCoords().get(measureIdx);                             
            
            //si es en modo multitrack. asigno mayor quarterSpan para este compas.
            measureCoords.setQuarterSpan(getQuarterSpan(getQuarterSpan(measureIdx),measureCoords));     
            
            //asigno la posicion dentro del compas
            measureCoords.setPosX(posX);
            measureCoords.setPosY(0);    
            
            measureCoords.update(this);
            
            posX += measureCoords.getWidth();
            //width += measureCoords.getWidth();
            //if(measureCoords.getHeight() > maxHeight){
            //    maxHeight = measureCoords.getHeight();
            //}                    
        }
        
        //trackCoords.setWidth(width);
        //trackCoords.setHeight(maxHeight);
    }    

    private void updateCaret(){
    	tablature.getCaret().update();
    }
    
    
    public void fireUpdate(int measureNumber,boolean isNew){
    	int measureIndex = (measureNumber - 1);
    	
        QuarterSpanHelper quarterSpan = null;
        if(getQuarterSpans().size() > measureIndex){                                
            quarterSpan = getQuarterSpan(measureIndex);
            quarterSpan.reset();
        }else{
            quarterSpan = new QuarterSpanHelper();
            getQuarterSpans().add(quarterSpan);
        }         
        
        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            trackCoords.fireChanges(this,measureIndex,quarterSpan,isNew);   
        } 
        for (int trackIdx = 0; trackIdx < getTablature().getSongCoords().getTrackCoords().size(); trackIdx++) {
            SongTrackCoords trackCoords = (SongTrackCoords)getTablature().getSongCoords().getTrackCoords().get(trackIdx);
            trackCoords.fireUpdate(this,measureIndex,quarterSpan);
        }     
        updateCaret();
    }    
    
    /**
     * Calcula el espacio minimo entre negras, dependiendo de la duracion de la nota 
     */
    public int getSpanForQuarter(Duration duration){        
        double span = ((double)Duration.QUARTER_TIME / (double)duration.getTime()) * getMinSpan(duration);
        return  (int)span;
    }   
    
    /**
     * Calcula el Espacio minimo que quedara entre nota y nota
     */
    private int getMinSpan(Duration duration){
        int minSpan = 0;
        switch(duration.getValue()){
        	case Duration.WHOLE:
        	    minSpan = 50;
        	    break;
        	case Duration.HALF:
        	    minSpan = 30;
        	    break;
        	case Duration.QUARTER:
        	    minSpan = 25;
        	    break;
        	case Duration.EIGHTH:
        	    minSpan = 20;
        	    break;       
        	default:
        	    minSpan = 18;
        	    break;
        }        
        return minSpan;        
    }    
    
    
    public boolean isCaretVisible(){
    	return true;
    }

    public boolean isPlayModeEnabled(){
    	return true;
    }
    
    public void setDefaultStyle(GC gc){
    	gc.setFont(tablature.getDefaultFont());
    }
    
    public void setNoteStyle(GC gc){
    	gc.setFont(tablature.getNoteFont());    	
    }
    
    public void setTimeSignatureStyle(GC gc){
    	gc.setFont(tablature.getTimeSignatureFont());    	
    }

    public void setScoreNoteColor(GC gc){
    	gc.setForeground(tablature.getScoreNoteColor());    	
    }        
    
    public void setTabNoteColor(GC gc){
    	gc.setForeground(tablature.getTabNoteColor());    	
    }    

    public void setPlayNoteColor(GC gc){
    	gc.setForeground(tablature.getPlayNoteColor());    	
    }        

    public Point getNoteOrientation(GC gc,int x,int y,Note note){

    	String noteAsString = null;    	    	
    	if (note.isTiedNote()){
    		noteAsString = "L";
    	}else if(note.getEffect().isDeadNote()){
    		noteAsString = "X";
    	}else{
    		noteAsString = Integer.toString(note.getValue());
    	}
    	Point point = gc.stringExtent(noteAsString);
    	point.x = (x - (point.x / 2));
    	point.y = (y - (point.y / 2));    	
        return point;        

    }
    
    protected boolean isMultiTrack(){
        return true;
    }

    protected int getTrackCount(){
        if(multitrack){
            return songManager.getSong().getTracks().size();
        }
        return 1;
    }           
    
    
    public int getQuarterSpan(QuarterSpanHelper quarterSpan,MeasureCoords measure){
        if(isMultitrack()){
            return quarterSpan.getQuarterSpan();
        }else{
            return measure.getQuarterSpan();
        }
    }    
    
    
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    public Tablature getTablature() {
        return tablature;
    }
    public void setTablature(Tablature tablature) {
        this.tablature = tablature;
    }
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }
    
    
    public boolean isMultitrack() {
        return multitrack;
    }
    public void setMultitrack(boolean multitrack) {
        this.multitrack = multitrack;
    }

	public boolean isScoreEnabled() {
		return scoreEnabled;
	}

	public void setScoreEnabled(boolean scoreEnabled) {
		this.scoreEnabled = scoreEnabled;
	}

	public List getQuarterSpans(){
        return this.quarterSpanHelpers;
    }
    
    public QuarterSpanHelper getQuarterSpan(int i){
        return (QuarterSpanHelper)this.quarterSpanHelpers.get(i);
    }    

    public void addQuarterSpan(QuarterSpanHelper quarterSpan){
        this.quarterSpanHelpers.add(quarterSpan);
    }    
    
    public int getStringSpan(){
    	return DEFAULT_STRING_SPAN;
    }
        
    public int getScoreLineSpan(){
    	return DEFAULT_SCORE_LINE_SPAN;
    }    
    
    /*
    public int getScoreSpan(){
    	return DEFAULT_SCORE_SPAN;
    }        
    */
    private int scoreSpan;
    public int getScoreSpan(){
    	return scoreSpan;
    }  
    public void setScoreSpan(int scoreSpan){
    	this.scoreSpan = scoreSpan;
    }  
    
    
    public int getDefaultFirstTrackSpan(){
    	if(isScoreEnabled()){
    		return DEFAULT_FIRST_TRACK_SPAN + 10;	
    	}
    	return DEFAULT_FIRST_TRACK_SPAN;
    }

    
    private List trackPositions = new ArrayList();
    
    protected void clearTrackPositions(){
    	this.trackPositions.clear();
    }
    
    protected void addTrackPosition(int track,int posY,int height){
    	this.trackPositions.add(new TrackPosition(track,posY,height));
    }
    
    public int getTrackNumberAt(List tracksCoords,int y,int vScroll){
        /*
    	if(!isMultitrack()){
            tracksCoords = new ArrayList();
            tracksCoords.add(getTablature().getCaret().getSongTrackCoords());
        }        
        SongTrackCoords trackCoords = null;
        int posY = getDefaultFirstTrackSpan() + vScroll;        
        for (int trackIdx = 0; trackIdx < tracksCoords.size(); trackIdx++) {
            SongTrackCoords track = (SongTrackCoords) tracksCoords.get(trackIdx);            
            int trackWidth = track.getWidth();
            int trackHeight = track.getHeight();

            if(y >= posY && y <= posY + trackHeight){
                trackCoords = track;
            }            
            if(isScoreEnabled()){
            	posY += getScoreSpan();
            }            
            posY += DEFAULT_TRACK_SPAN;
        }     
        */
        Iterator it = trackPositions.iterator();
        while(it.hasNext()){
        	TrackPosition trackPos = (TrackPosition)it.next();
            
        	if(y >= trackPos.getPosY() && y <= trackPos.getPosY() + trackPos.getHeight()){
                return trackPos.getTrack();
            }         	
        }
        return -1;
    }    
    
    protected class TrackPosition{
    	private int track;
    	private int posY;
    	private int height;
    	
    	public TrackPosition(int track,int posY,int height){
    		this.track = track;
    		this.posY = posY;
    		this.height = height;
    	}

		public int getPosY() {
			return posY;
		}
		
		public int getHeight() {
			return height;
		}
		
		public int getTrack() {
			return track;
		}    	
    }
}
