package org.herac.tuxguitar.gui.tab.layout;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TuxGuitar;


public class TabFonts {
	private Font[] fonts;
    
    public TabFonts(DefaultFontProperty[] fonts){    	    	
    	this.fonts = new Font[fonts.length];
    	for(int i = 0; i < fonts.length; i++){
    		this.fonts[i] = loadFont(TuxGuitar.instance().getDisplay(),fonts[i]);
    	}
    }
        
    public Font loadFont(Display display,DefaultFontProperty dfp){    	    	
    	String name = TuxGuitar.instance().getConfig().getStringConfigValue(dfp.getProperty() + "_NAME");
    	int size = TuxGuitar.instance().getConfig().getIntConfigValue(dfp.getProperty() + "_SIZE");
    	int style = TuxGuitar.instance().getConfig().getIntConfigValue(dfp.getProperty() + "_STYLE");
    	
    	if(name != null && name.length() > 0 && size > 0){    	
    		return new Font(display,name,size, style);
    	}
    	return new Font(display,dfp.getFontName(),dfp.getFontSize(),dfp.getFontStyle());
    }

    public void disposeFonts(){
    	for(int i = 0; i < this.fonts.length; i++){
    		this.fonts[i].dispose(); 
    	}
    }    
    
	public Font getFont(int index) {
		return this.fonts[index];
	}

}