/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;



/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class Tablature extends Composite {	
    private SongManager songManager;
    private SongCoords songCoords;
    private Caret caret;
    private int width;
    private int height;    
    private ViewLayout viewLayout;    
    private Font defaultFont;
    private Font noteFont;
    private Font timeSignatureFont;     
    private Font printerDefaultFont;
    private Font printerNoteFont;
    private Font printerTimeSignatureFont;     
    
    private Color scoreNoteColor;
    private Color tabNoteColor;
    private Color playNoteColor;
    
    public Tablature(final Composite parent, int style) {
        super(parent, style);        
        this.setBackground(new Color(getDisplay(), 255, 255, 255));
        this.loadFonts();
        this.loadColors();
    }    
    
    
    public void initGUI(){
        this.addPaintListener(new TablaturePaintListener(this));
                        
        final Point origin = new Point(0, 0);
        final ScrollBar hBar = getHorizontalBar();
        hBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {
            int hSelection = hBar.getSelection();
            int destX = -hSelection - origin.x;
            Rectangle rect = getClientArea();
            getShell().scroll(destX, 0, 0, 0, rect.width, rect.height, false);
            origin.x = -hSelection;           
            redraw();
          }
        });
        final ScrollBar vBar = getVerticalBar();
        vBar.addListener(SWT.Selection, new Listener() {
          public void handleEvent(Event e) {
            int vSelection = vBar.getSelection();
            int destY = -vSelection - origin.y;
            Rectangle rect = getBounds();
            getShell().scroll(0, destY, 0, 0, rect.width, rect.height, false);
            origin.y = -vSelection;            
            redraw();
          }
        });         
        
        this.addControlListener(new ControlAdapter() {		
			public void controlResized(ControlEvent arg0) {
				updateScroll();
			}		
		});
    }
    
    public void initDefaults(ViewLayout viewLayout){
        this.viewLayout = viewLayout;
        this.songCoords = new SongCoords(this,this.songManager);        
        this.caret = new Caret(this,this.songManager,this.songCoords);
    }    
    
    public void updateTablature(){
        getViewLayout().updateSong();
    }

    public void initCaret(){
    	this.caret.update(1,1000,1);
    }
    
    public void loadFonts(){
        this.defaultFont = getFont(PropertyNames.FONT_DEFAULT);
        this.noteFont = getFont(PropertyNames.FONT_NOTE);
        this.timeSignatureFont = getFont(PropertyNames.FONT_TIME_SIGNATURE);
        this.printerDefaultFont = getFont(PropertyNames.FONT_PRINTER_DEFAULT);
        this.printerNoteFont = getFont(PropertyNames.FONT_PRINTER_NOTE);	        
        this.printerTimeSignatureFont = getFont(PropertyNames.FONT_PRINTER_TIME_SIGNATURE);        
    }    
    
    public void loadColors(){
        this.scoreNoteColor = getColor(PropertyNames.COLOR_SCORE_NOTE);
        this.tabNoteColor = getColor(PropertyNames.COLOR_TAB_NOTE);
        this.playNoteColor = getColor(PropertyNames.COLOR_PLAY_NOTE);        
    }     
    
    public void paintTablature(GC gc){      	
    	//Si estoy reproduciendo muevo el scroll al compas que se esta ejecutando
    	if(songManager.getPlayer().isRunning()){
    		MeasureCoords measure = getCaret().getSongTrackCoords().getMeasureCoords(songManager.getPlayer().getTickPosition());
    		if(measure != null){
    			getViewLayout().followMeasure(measure,false);
    		}
    	}        
    	
    	int hScroll = getHorizontalBar().getSelection();
    	int vScroll = getVerticalBar().getSelection();                	
    	
    	this.getViewLayout().paintSong(gc,getClientArea(),-hScroll,-vScroll);
            	    	
    	this.width = this.viewLayout.getWidth();
    	this.height = this.viewLayout.getHeight();
        
    	this.updateScroll();
        
    	//Si no estoy reproduciendo muevo el scroll al compas que tiene el caret
    	if(getCaret().hasChanges() && !songManager.getPlayer().isRunning()){   
    		getCaret().setChanges(false);
    		if(getCaret().getMeasureCoords() != null){
    			getViewLayout().followMeasure(getCaret().getMeasureCoords(),true);
    		}
    	}         
    }

    public void updateScroll(){
		Rectangle rect = getBounds();
		Rectangle client = getClientArea();        
        ScrollBar hBar = getHorizontalBar();
        ScrollBar vBar = getVerticalBar();
		hBar.setMaximum(width + 22);
		vBar.setMaximum(height);
		hBar.setThumb(Math.min(rect.width, client.width));
		vBar.setThumb(Math.min(rect.height, client.height));
    }
    
    public void moveScrollHorizontalTo(MeasureCoords measure,int leftSencibility,int rightSencibility,boolean redraw){
        if(measure != null){
            int selectcionX = getHorizontalBar().getSelection();
            int selectionWidth = getClientArea().width;
            
            int measureX = measure.getPosX();
            int measureWidth = measure.getWidth();
            
            if(measureX <= selectcionX){
                getHorizontalBar().setSelection(measureX - leftSencibility);
                if(redraw){
                    redraw();
                }
            }else if((measureX + measureWidth) >= (selectcionX + selectionWidth)){
                getHorizontalBar().setSelection((measureX - selectionWidth) + rightSencibility );
                if(redraw){
                    redraw();
                }
            }
        }           
    }
    
    public void moveScrollVerticalTo(MeasureCoords measure,int topSencibility,int bottomSencibility,boolean redraw){
        if(measure != null){
            int selectcionY = getVerticalBar().getSelection();
            int selectionHeight = getClientArea().height;
            
            int measureY = measure.getPosY();
            int measureHeight = measure.getTabHeight() + measure.getScoreSpan();
            //int measureHeight = measure.getHeight();
            
            if(measureY + selectcionY <= selectcionY){
                getVerticalBar().setSelection(selectcionY + (measureY)  - (topSencibility ));
                if(redraw){
                    redraw();
                }
            }else if((measureY + measureHeight + selectcionY) >= (selectcionY + selectionHeight)){                         
                getVerticalBar().setSelection(selectcionY + (selectionHeight - (selectionHeight - (measureY - measureHeight))) - (bottomSencibility ));
                if(redraw){
                    redraw();
                }
            }
        }           
    }    
    

	public Font getDefaultFont() {
		return defaultFont;
	}

	public Font getNoteFont() {
		return noteFont;
	}

	public Font getTimeSignatureFont() {
		return timeSignatureFont;
	}
	
	public Font getPrinterDefaultFont() {
		return printerDefaultFont;
	}
    
	public Font getPrinterNoteFont() {
		return printerNoteFont;
	}

	public Font getPrinterTimeSignatureFont() {
		return printerTimeSignatureFont;
	}


	public Color getPlayNoteColor() {
		return playNoteColor;
	}


	public Color getScoreNoteColor() {
		return scoreNoteColor;
	}


	public Color getTabNoteColor() {
		return tabNoteColor;
	}


	public void redraw(){
        if(!super.isDisposed()){
            super.redraw();
        }
    }
    
    public void resetScroll(){
        getHorizontalBar().setSelection(0);
        getVerticalBar().setSelection(0);
    }

    public Caret getCaret(){
        return this.caret;
    }
   
    public SongManager getSongManager() {
        return songManager;
    }
    public void setSongManager(SongManager songManager) {
        this.songManager = songManager;
    }
    
    public SongCoords getSongCoords(){
        return this.songCoords;
    }
    
    public void changeCursor(int style){
        setCursor(new Cursor(getDisplay(),style));
    }    
    
    public ViewLayout getViewLayout(){
        return this.viewLayout;
    }
    
    public void setViewLayout(ViewLayout viewLayout){
        this.viewLayout = viewLayout;
        this.getHorizontalBar().setSelection(0);
        this.getVerticalBar().setSelection(0);
    }

    public void reloadConfig(ViewLayout layout){
    	this.disposeGraphics();
        this.loadFonts();
        this.loadColors();
        this.setViewLayout(layout);
    }
    
    
    private static final Font getFont(String key){
    	FontData data = TuxGuitar.instance().getConfig().getFontDataConfigValue(key);
    	if(data == null){
    		data = new FontData();
    	}
    	return new Font(TuxGuitar.instance().getDisplay(),data);
    }
    
    private static final Color getColor(String key){
    	RGB rgb = TuxGuitar.instance().getConfig().getRGBConfigValue(key);
    	if(rgb == null){
    		rgb = new RGB(0,0,0);
    	}
    	return new Color(TuxGuitar.instance().getDisplay(),rgb);  
    }
    
    public void dispose(){
    	super.dispose();
    	this.disposeGraphics();
    }
    
    public void disposeGraphics(){
        this.defaultFont.dispose();
        this.noteFont.dispose();
        this.timeSignatureFont.dispose();
        this.printerDefaultFont.dispose();
        this.printerNoteFont.dispose();
        this.printerTimeSignatureFont.dispose();
        this.scoreNoteColor.dispose();
        this.tabNoteColor.dispose();
        this.playNoteColor.dispose();
    }
}