/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.SongTrack;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SongTrackCoords {    
    /**
     * Espacio por defecto para la posicion X
     */
    public static final int DEFAULT_HORIZONTAL_SPAN = 20;    
    
    private Tablature tablature;
    private SongManager songManager;
    private SongTrack track;
    private List measuresCoords;
    
    private int posX;
    private int posY;
    private int width;
    private int height;
    
    public SongTrackCoords(Tablature tablature,SongManager songManager,SongTrack track/*,ViewLayout layout*/) {
        this.tablature = tablature;
        this.track = track;
        this.songManager = songManager;
        this.measuresCoords = new ArrayList();
        this.posX = DEFAULT_HORIZONTAL_SPAN;
    }

    public void fireChanges(ViewLayout layout,int measureId,QuarterSpanHelper quarterSpan,boolean isNew){  
        MeasureCoords measureCoords = null;
        if(isNew){
            Measure measure = (Measure) track.getMeasures().get(measureId);
            measureCoords = new MeasureCoords(this.songManager,this.tablature, measure, this);
            getMeasuresCoords().add(measureCoords);
        }else{
            measureCoords =  (MeasureCoords) getMeasuresCoords().get(measureId);
        }
        measureCoords.create(layout);            
        quarterSpan.setQuarterSpan(measureCoords.getQuarterSpan());

        
    }
    
    public void fireUpdate(ViewLayout layout,int measureId,QuarterSpanHelper quarterSpan){        
        MeasureCoords measureCoords =  (MeasureCoords) getMeasuresCoords().get(measureId); 
        
        measureCoords.setQuarterSpan(tablature.getViewLayout().getQuarterSpan(quarterSpan,measureCoords));
        int oldWidth = measureCoords.getWidth();
        this.width -= oldWidth;
        
        measureCoords.update(layout);     
        this.width += measureCoords.getWidth();
    }    
    
    public void checkPosX(int fromX){
        this.posX = DEFAULT_HORIZONTAL_SPAN;
        if(fromX <= -this.posX){
            this.posX = 0;
        }
    }
    
    public void paintTrack(ViewLayout layout,GC gc,int fromX, int fromY,Rectangle clientArea){
        checkPosX(fromX);
        layout.paintMeasures(this,measuresCoords ,gc,fromX,fromY,clientArea);
    }
        
    public List getMeasuresCoords(){
        return this.measuresCoords;
    }
    
    public SongTrack getTrack(){
        return this.track;
    }
    
    
    public MeasureCoords getFirstMeasure(){
        MeasureCoords firstMeasure = null;    
        for(int measureIdx = 0;measureIdx < measuresCoords.size();measureIdx++){
            MeasureCoords currMeasure = (MeasureCoords)measuresCoords.get(measureIdx);
            if(firstMeasure == null || (currMeasure.getMeasure().getStart() < firstMeasure.getMeasure().getStart())){
                firstMeasure = currMeasure;
            }
        }        
        return firstMeasure;
    }     

    public MeasureCoords getLastMeasure(){
        int lastIndex = this.measuresCoords.size() - 1; 
        return (MeasureCoords)measuresCoords.get(lastIndex);
    }      
    
    public MeasureCoords getPrevMeasure(MeasureCoords measureCoords){
    	int prevNumber = measureCoords.getMeasure().getNumber() - 1;
    	int prevIndex = prevNumber - 1;
        if(prevIndex >= 0){
            return (MeasureCoords)measuresCoords.get(prevIndex);
        }        
        return null;
    }      
    
    public MeasureCoords getNextMeasure(MeasureCoords measureCoords){
    	int nextNumber = measureCoords.getMeasure().getNumber() + 1; 
    	int nextIndex = nextNumber - 1; 
        if(nextIndex < measuresCoords.size()){
            return (MeasureCoords)measuresCoords.get(nextIndex);
        }
        return null;        
    }       

    public MeasureCoords getMeasureCoords(long start){
        MeasureCoords measureCoords = null;
        for (int measureIdx = 0; measureIdx < this.measuresCoords.size(); measureIdx++) {
            MeasureCoords measure = (MeasureCoords) this.measuresCoords.get(measureIdx);  
            long measureStart = measure.getMeasure().getStart();
            long measureLength = measure.getMeasure().getLength();
            if(start >= measureStart && start < measureStart + measureLength){
                return measure;
            }
        }     
        return null;
    }          
    
    public MeasureCoords getMeasure(Measure measure){
        MeasureCoords measureCoords = null;
        for (int measureIdx = 0; measureIdx < this.measuresCoords.size(); measureIdx++) {
            MeasureCoords currMeasure = (MeasureCoords) this.measuresCoords.get(measureIdx);            
            if(currMeasure.getMeasure().equals(measure)){
                measureCoords = currMeasure;
                break;
            }
        }     
        return measureCoords;
    }      
    
    public MeasureCoords getMeasureAt(int x,int y,int hScroll,int vScroll){
        MeasureCoords measureCoords = null;
        long posX = this.posX + hScroll;
        int stringSpan = this.tablature.getViewLayout().getStringSpan();
        
        Iterator it = measuresCoords.iterator();
        while(it.hasNext()){           
            MeasureCoords currMeasure = (MeasureCoords)it.next();

            //int measureHeight = currMeasure.getHeight();
            int measureHeight = currMeasure.getTabHeight() + currMeasure.getScoreSpan();

            boolean isAtX = (x >= posX + currMeasure.getPosX() && x <= posX + currMeasure.getPosX() + currMeasure.getWidth() + currMeasure.getSpan());
            boolean isAtY = (y + stringSpan >= currMeasure.getPosY()  && y - stringSpan <= currMeasure.getPosY()  + measureHeight);    
            if(isAtX && isAtY){
                measureCoords = currMeasure;
                break;
            }     

        }
        return measureCoords;
    }    

    
    public boolean hasCaret(){
        return (this.equals(this.tablature.getCaret().getSongTrackCoords()));
    }
    
    public int getHeight() {
        return height;
    }
    public void setHeight(int height) {
        this.height = height;
    }
    public int getPosX() {
        return posX;
    }
    public void setPosX(int posX) {
        this.posX = posX;
    }
    public int getPosY() {
        return posY;
    }
    public void setPosY(int posY) {
        this.posY = posY;
    }
    public int getWidth() {
        return width;
    }
    public void setWidth(int width) {
        this.width = width;
    }

	
}