package org.herac.tuxguitar.gui.tab;

import org.herac.tuxguitar.gui.tab.layout.ViewLayout;


public class ScoreBeatHelper {
	private static final int SCORE_MIDDLE_KEYS[] = new int[]{60,40,40,50};
	private static final int SCORE_SHARP_POSITIONS[] = new int[]{7,7,6,6,5,4,4,3,3,2,2,1};	
	private static final int SCORE_FLAT_POSITIONS[] = new int[]{7,6,6,5,5,4,3,3,2,2,1,1};
	
	public static final int DIRECTION_UP = 1;
	public static final int DIRECTION_DOWN = 2;
	
	private int direction;
	private NoteCoords firstMinNote;
	private NoteCoords firstMaxNote;
	private NoteCoords lastMinNote;
	private NoteCoords lastMaxNote;
	private NoteCoords maxNote;
	private NoteCoords minNote;
	
	public ScoreBeatHelper(){
		this.direction = DIRECTION_UP;
		this.firstMinNote = null;
		this.firstMaxNote = null;
		this.lastMinNote = null;
		this.lastMaxNote = null;
		this.maxNote = null;
		this.minNote = null;
	}
	
	public void check(NoteCoords note,int clef){
		int value = note.getRealValue();
		
		//FIRST MIN NOTE
		if(firstMinNote == null || note.getStart() < firstMinNote.getStart()){			
			firstMinNote = note;
		}else if(note.getStart() == firstMinNote.getStart()){
			if(note.getRealValue() < firstMinNote.getRealValue()){
				firstMinNote = note;
			}
		}
		//FIRST MAX NOTE
		if(firstMaxNote == null || note.getStart() < firstMaxNote.getStart()){			
			firstMaxNote = note;
		}else if(note.getStart() == firstMaxNote.getStart()){
			if(note.getRealValue() > firstMaxNote.getRealValue()){
				firstMaxNote = note;
			}
		}
				
		//LAST MIN NOTE
		if(lastMinNote == null || note.getStart() > lastMinNote.getStart()){
			lastMinNote = note;
		}else if(note.getStart() == lastMinNote.getStart()){
			if(note.getRealValue() < lastMinNote.getRealValue()){
				lastMinNote = note;
			}
		}	
		//LAST MIN NOTE
		if(lastMaxNote == null || note.getStart() > lastMaxNote.getStart()){
			lastMaxNote = note;
		}else if(note.getStart() == lastMaxNote.getStart()){
			if(note.getRealValue() > lastMaxNote.getRealValue()){
				lastMaxNote = note;
			}
		}	
		
		if(maxNote == null || value > maxNote.getRealValue()){
			maxNote = note;
		}
		if(minNote == null || value < minNote.getRealValue()){
			minNote = note;
		}
						
		int max = Math.abs(minNote.getRealValue() - (SCORE_MIDDLE_KEYS[clef - 1] + 100));
		int min = Math.abs(maxNote.getRealValue() - (SCORE_MIDDLE_KEYS[clef - 1] - 100));		
		if(max > min){
			this.direction = DIRECTION_UP;			
		}else{
			this.direction = DIRECTION_DOWN;
		}
	}

	public int getY1(ViewLayout layout,NoteCoords note,int key,int clef){
		double scale = (layout.getScoreLineSpan() / 2.00);
		int noteValue = note.getRealValue();
		
		int scoreLineY = 0;
		if(key <= 7){
			scoreLineY = (int)((SCORE_SHARP_POSITIONS[noteValue % 12]) * scale - (7 * (noteValue / 12)) * scale);
		}else{
			scoreLineY = (int)((SCORE_FLAT_POSITIONS[noteValue % 12]) * scale - (7 * (noteValue / 12)) * scale);
		}

		scoreLineY += MeasureCoords.SCORE_KEY_OFFSETS[clef - 1] * scale; 
		
		//scoreLineY += MeasureCoords.SCORE_KEY_OFFSETS[clef - 1] * layout.getScoreLineSpan();
		
		
		return scoreLineY;
	}
	
	public int getY2(ViewLayout layout,int x,int key,int clef){		
		int maxDistance = 10;
		if(direction == DIRECTION_DOWN){
			if(minNote != firstMinNote && minNote != lastMinNote){
				return getY1(layout,minNote,key,clef) + 35;	
			}
			
			int x1 = firstMinNote.getPosX() + firstMinNote.getSpan();
			int x2 = lastMinNote.getPosX() + lastMinNote.getSpan();						
			int y1 = getY1(layout,firstMinNote,key,clef) + 35;
			int y2 = getY1(layout,lastMinNote,key,clef) + 35;
			
			if(y1 > y2 && (y1 - y2) > maxDistance) y2 = (y1 - maxDistance);
			if(y2 > y1 && (y2 - y1) > maxDistance) y1 = (y2 - maxDistance);			
			int y = (int)((((double)y1 -(double)y2) / ((double)x1 - (double)x2)) * ((double)x1 - (double)x));
			return y1 - y;
			//return getY1(layout,minNote,key) + 35;
		}else{
			if(maxNote != firstMaxNote && maxNote != lastMaxNote){
				return getY1(layout,maxNote,key,clef) - 28;	
			}			
			int x1 = firstMaxNote.getPosX() + firstMaxNote.getSpan();
			int x2 = lastMaxNote.getPosX() + lastMaxNote.getSpan();											
			int y1 = getY1(layout,firstMaxNote,key,clef) - 28;
			int y2 = getY1(layout,lastMaxNote,key,clef) - 28;
			
			if(y1 < y2 && (y2 - y1) > maxDistance) y2 = (y1 + maxDistance);
			if(y2 < y1 && (y1 - y2) > maxDistance) y1 = (y2 + maxDistance);			
			int y = (int)((((double)y1 -(double)y2) / ((double)x1 - (double)x2)) * ((double)x1 - (double)x));
			return y1 - y;			 
			//return getY1(layout,maxNote,key) - 35;	
		}
		
	}	
	
	public int getDirection() {
		return direction;
	}
	
}
