/*
 * Created on 29-nov-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.tab;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteCoords implements MeasureComponent {
	private static final int NATURAL = 0;
	private static final int SHARP = 1;
	private static final int FLAT = 2;
	
	
	private static final int SCORE_SHARP_NOTES[] = new int[]{0,0,1,1,2,3,3,4,4,5,5,6};
	private static final int SCORE_FLAT_NOTES[] = new int[]{0,1,1,2,2,3,4,4,5,5,6,6};
	
	private static final int KEY_SIGNATURES[][] = new int[][]{
		//------------NATURAL------------------------------------
		{NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,NATURAL}, // NATURAL
		//------------SHARPS------------------------------------
		{NATURAL,NATURAL,NATURAL,SHARP,NATURAL,NATURAL,NATURAL}, // 1 SHARP
		{SHARP,NATURAL,NATURAL,SHARP,NATURAL,NATURAL,NATURAL}, // 2 SHARPS
		{SHARP,NATURAL,NATURAL,SHARP,SHARP,NATURAL,NATURAL}, // 3 SHARPS
		{SHARP,SHARP,NATURAL,SHARP,SHARP,NATURAL,NATURAL}, // 4 SHARPS
		{SHARP,SHARP,NATURAL,SHARP,SHARP,SHARP,NATURAL}, // 5 SHARPS
		{SHARP,SHARP,SHARP,SHARP,SHARP,SHARP,NATURAL}, // 6 SHARPS
		{SHARP,SHARP,SHARP,SHARP,SHARP,SHARP,SHARP}, // 7 SHARPS
		//------------FLATS------------------------------------		
		{NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,NATURAL,FLAT}, // 1 FLAT
		{NATURAL,NATURAL,FLAT,NATURAL,NATURAL,NATURAL,FLAT}, // 2 FLATS
		{NATURAL,NATURAL,FLAT,NATURAL,NATURAL,FLAT,FLAT}, // 3 FLATS
		{NATURAL,FLAT,FLAT,NATURAL,NATURAL,FLAT,FLAT}, // 4 FLATS
		{NATURAL,FLAT,FLAT,NATURAL,FLAT,FLAT,FLAT}, // 5 FLATS
		{FLAT,FLAT,FLAT,NATURAL,FLAT,FLAT,FLAT}, // 6 FLATS
		{FLAT,FLAT,FLAT,FLAT,FLAT,FLAT,FLAT}, // 7 FLATS
	};
	
	
	
	//private static final int SCORE_NOTES[] = new int[]{12,12,14,14,16,17,17,19,19,21,21,23};
	
	/**
	 * Notas que tienen sostenido
	 */	
	private static final boolean NO_NATURAL_NOTES[] = new boolean[]{false,true,false,true,false,false,true,false,true,false,true,false};	
    /**
     * desviacion a la izquierda
     */
    private static final int JOINED_TYPE_NONE_LEFT = 1;
    /**
     * desviacion a la derecha
     */
    private static final int JOINED_TYPE_NONE_RIGHT = 2;    
    /**
     * Union a la izquierda
     */
    private static final int JOINED_TYPE_LEFT = 3;
    /**
     * Union a la derecha
     */
    private static final int JOINED_TYPE_RIGHT = 4;
    
    private boolean joinedGreaterThanQuarter;
    /**
     * Widget de la tablatura
     */
    private Tablature tablature;    
    /**
     * Coordenadas del compas
     */
    private MeasureCoords meassureCoords;
    /**
     * Nota de Referencia
     */
    private Note note;
    /**
     * Valor real de la nota, sumado a el valor de la cuerda
     */    
    private int realValue;       
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /**
     * Posicion Y dentro del compas
     */
    private int posY;
    /**
     * Ultimo from X
     */
    private int lastFromX;
    /**
     * Ultimo from Y
     */
    private int lastFromY;
    /**
     * Coordenadas de los dibujos de las figuras
     */
    private DurationCoords durationCoords;
    /**
     * Tipo de union de notas
     */
    private int joinedType;
    /**
     * Pista de Referencia
     */
    private SongTrackCoords trackCoords;

    /**
     * Helper para la partitura
     */
    private ScoreBeatHelper scoreBeatHelper;
    
    private Image bendImage;    
    
    private int pointX;
    
    private int pointY;
    
    private int scorePosY;
    
    public NoteCoords(Tablature tablature, SongTrackCoords trackCoords, MeasureCoords meassureCoords, Note note, int posX, int posY) {
        this.tablature = tablature;
        this.trackCoords = trackCoords;
        this.meassureCoords = meassureCoords;
        this.note = note;
        this.posX = posX;
        this.posY = posY;
        this.durationCoords = new DurationCoords();
        this.calculateRealValue();
    }

    /**
     * Actualiza los valores para dibujar
     */
    public void update(ViewLayout layout) {    	
        this.joinedType = JOINED_TYPE_NONE_RIGHT;
        this.joinedGreaterThanQuarter = false;
        this.durationCoords.setNote1(this);
        this.durationCoords.setNote2(this);
        this.durationCoords.setEighthY(meassureCoords.getTabHeight() + 25);
        this.durationCoords.setSixteenthY(meassureCoords.getTabHeight() + 20);
        this.durationCoords.setThirtySecondY(meassureCoords.getTabHeight() + 15);
        this.durationCoords.setSixtyFourthY(meassureCoords.getTabHeight() + 10);

        boolean noteJoined = false;
        boolean withPrev = false;

        MeasureComponent prevComponent = meassureCoords.getPreviousComponent(this);
        MeasureComponent nextComponent = meassureCoords.getNextComponent(this);
        NoteCoords prevNote = null;
        NoteCoords nextNote = null;

        //trato de unir con el componente anterior
        if (prevComponent instanceof NoteCoords) {
            prevNote = (NoteCoords) prevComponent;
            if (meassureCoords.areInSameBeat(this, prevNote)) {
            	withPrev = true;
                if (prevNote.getNote().getDuration().getValue() >= note.getDuration().getValue()) {
                    this.durationCoords.setNote1(prevNote);
                    if (nextNote == null || nextNote.getNote().getDuration().getValue() < note.getDuration().getValue()) {
                        this.durationCoords.setNote2(this);
                    }
                    noteJoined = true;
                    this.joinedType = JOINED_TYPE_LEFT;
                }
                if (prevNote.getNote().getDuration().getValue() > Duration.QUARTER){
                	this.joinedGreaterThanQuarter = true;
                }
            }
        }

        //trato de unir con el componente que le sigue
        if (nextComponent instanceof NoteCoords) {
            nextNote = (NoteCoords) nextComponent;
            if (meassureCoords.areInSameBeat(this, nextNote)) {
                if (nextNote.getNote().getDuration().getValue() >= note.getDuration().getValue()) {
                    this.durationCoords.setNote2(nextNote);
                    if (prevNote == null || prevNote.getNote().getDuration().getValue() < note.getDuration().getValue()) {
                        this.durationCoords.setNote1(this);
                    }
                    noteJoined = true;
                    this.joinedType = JOINED_TYPE_RIGHT;
                }
                if (nextNote.getNote().getDuration().getValue() > Duration.QUARTER){
                	this.joinedGreaterThanQuarter = true;
                }                
            }

        }

        //si no hubo union decido para que lado girar la figura
        if (!noteJoined && withPrev) {            
            this.joinedType = JOINED_TYPE_NONE_LEFT;            
        }

        this.scorePosY = scoreBeatHelper.getY1(layout,this,meassureCoords.getMeasure().getKeySignature(),meassureCoords.getMeasure().getClef());
        this.updateUsedStrings();
        this.updateEffects();                
    }

    private void updateUsedStrings() {
        if (note.getDuration().getValue() >= Duration.QUARTER) {
            boolean[] usedStrings = new boolean[trackCoords.getTrack().getStrings().size()];
            List notesAtBeat = this.meassureCoords.getComponents(getStart());
            Iterator it = notesAtBeat.iterator();
            while (it.hasNext()) {
                MeasureComponent component = (MeasureComponent) it.next();
                if (component instanceof NoteCoords) {
                    NoteCoords currNote = (NoteCoords) component;
                    usedStrings[currNote.getNote().getString() - 1] = true;
                }
            }
            this.durationCoords.setUsedStrings(usedStrings);
        }
    }

    
    private void updateEffects(){
        
        if(getNote().getEffect().hasEffects()){
        	this.bendImage = SystemImages.BEND_IMAGE;
        }
        
    }
    
    public void calculateRealValue(){
    	this.realValue = (getNote().getValue() + ((InstrumentString)trackCoords.getTrack().getStrings().get((getNote().getString() - 1))).getValue());    	
    }        
    
    /**
     * Pinta la nota
     */
    public void paint(ViewLayout layout,GC gc, int fromX, int fromY) {    	    	
        int x = fromX + getPosX() + getSpan();
        int y = fromY + getPosY();
        this.pointX = x;

    	//SCORE NOTE
    	if(layout.isScoreEnabled()){        		
    		paintScoreDuration(layout,gc, fromX, fromY);        		        		
    		y += layout.getScoreSpan();
    	}
        
        if(layout.isPlayModeEnabled() && isPlaying()){
        	layout.setPlayNoteColor(gc);
        }else{
        	layout.setTabNoteColor(gc);
        }
        if (getNote().isTiedNote()) {   
        	if(!layout.isScoreEnabled()){     
        		NoteCoords noteForTie = getNoteForTie();
        		if (noteForTie != null && noteForTie.isAtSameLine(fromY)) {               		        	
        			int ligadureX = noteForTie.getPointX();
        			int ligadureY = noteForTie.getLastFromY() + noteForTie.getPosY() + 10;
        			gc.drawArc(ligadureX, ligadureY, (x - ligadureX), -30, 225, 90);
            	
        		}else{        		
        			Point p = layout.getNoteOrientation(gc,x,y,note);
        			gc.drawString("L", p.x, p.y);            	
        		}   
        	}
        } else {        	        	
        	Point p = layout.getNoteOrientation(gc,x,y,note);
        	String visualNote = (note.getEffect().isDeadNote())?"X":Integer.toString(getNote().getValue());
        	gc.drawString(visualNote, p.x, p.y); 
        }        
        
                        
        if(layout.isPlayModeEnabled() && isPlaying()){
        	//gc.drawString(">", (fromX + getPosX() + getSpan()) - 2,fromY +  this.meassureCoords.getTabHeight() + 50);
        	int span = (meassureCoords.getScoreSpan() > 0 )?meassureCoords.getScoreSpan() + 10:50;
        	gc.drawString(">", (fromX + getPosX() + getSpan()) - 2,fromY +  meassureCoords.getTabHeight() + span);
            layout.setTabNoteColor(gc);
        }
                
        if(layout.isScoreEnabled()){        	
        	paintEffects(gc,fromX,fromY + layout.getScoreSpan());
        }else{
        	paintDuration(layout,gc, fromX, fromY);
        	paintEffects(gc,fromX,fromY);
        }

        this.lastFromX = fromX;
        this.lastFromY = fromY;
    }

    
    
    /**
     * Encuentra la nota a la que esta ligada
     */
    private NoteCoords getNoteForTie() {
        //Primero lo busco en el compas actual
        List currComponents = this.meassureCoords.getComponentsBeforeEnd(this.meassureCoords.getMeasure().getStart());
        for (int cIdx = currComponents.size() - 1; cIdx >= 0; cIdx--) {
            MeasureComponent component = (MeasureComponent) currComponents.get(cIdx);
            if (component.getStart() < getNote().getStart()) {
                if (component instanceof NoteCoords) {
                    NoteCoords noteCoords = (NoteCoords) component;

                    if (noteCoords.getNote().getString() == getNote().getString()) {
                        return noteCoords;
                    }
                }
            }
        }

        //si no estaba en este compas lo busco en los anteriores
        for (int mIdx = (this.meassureCoords.getMeasure().getNumber() - 1); mIdx >= 0; mIdx--) {
            MeasureCoords measureCoords = (MeasureCoords) this.trackCoords.getMeasuresCoords().get(mIdx);

            List components = measureCoords.getComponentsBeforeEnd(measureCoords.getMeasure().getStart());
            for (int cIdx = components.size() - 1; cIdx >= 0; cIdx--) {
                MeasureComponent component = (MeasureComponent) components.get(cIdx);
                if (component.getStart() < getNote().getStart()) {
                    if (component instanceof NoteCoords) {
                        NoteCoords noteCoords = (NoteCoords) component;

                        if (noteCoords.getNote().getString() == getNote().getString()) {
                            return noteCoords;
                        }
                    }
                }
            }
        }
        return null;
    }

    /**
     * Pinta la figura de la Duracion
     */
    private void paintDuration(ViewLayout layout,GC gc, int fromX, int fromY) {
        int x = fromX + getPosX() + getSpan();
        int y2 = fromY + meassureCoords.getTabHeight() + 25;
        //int y2 = fromY + meassureCoords.getHeight() + 25;

        paintVerticalLine(layout,gc, fromX, fromY);

        if (note.getDuration().getValue() >= Duration.EIGHTH) {
            paintJoindeds(gc, fromX, fromY);
        }

        if (note.getDuration().isDotted() || note.getDuration().isDoubleDotted()) {
            paintDotted(gc, fromX, fromY,note.getDuration().isDoubleDotted());
        }
        if (!note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
            gc.drawString(Integer.toString(note.getDuration().getTupleto().getEnters()), x - 3, y2 + 10);
        }
    }
    
    

    
    private void paintVerticalLine(ViewLayout layout,GC gc, int fromX, int fromY) {
        int x = fromX + getPosX() + getSpan();
        int stringSpan = layout.getStringSpan();
        if (note.getDuration().getValue() >= Duration.QUARTER) {

            boolean[] usedStrings = this.durationCoords.getUsedStrings();
            for (int i = getNote().getString() - 1; i < usedStrings.length; i++) {
                if (!usedStrings[i]) {
                    int stringPosition = fromY + (stringSpan * (i + 1));
                    int y1 = stringPosition - (stringSpan / 2);
                    int y2 = stringPosition + (stringSpan / 2);
                	y2 = ((y2 - y1 < stringSpan)?y2 + 1:y2);
                    
                    gc.drawLine(x, y1, x, y2);
                }
            }
            //int y = fromY + meassureCoords.getHeight() + (stringSpan / 2);
            int y = fromY + meassureCoords.getTabHeight() + (stringSpan / 2);
            gc.drawLine(x, y, x, y + 19);
        } else if (note.getDuration().getValue() == Duration.HALF) {
            int y = fromY + meassureCoords.getTabHeight() + (stringSpan / 2) + 9;
            //int y = fromY + meassureCoords.getHeight() + (stringSpan / 2) + 9;
            gc.drawLine(x, y, x, y + 10);
        }
    }

    /**
     * Pinta las uniones entre notas
     */
    public void paintJoindeds(GC gc, int fromX, int fromY) {
        gc.setLineWidth(2);
        int x1 = 0;
        int x2 = 0;        
        
        if(this.joinedType == JOINED_TYPE_NONE_RIGHT){
            x1 = getPosX() + getSpan();
            x2 = getPosX() + getSpan() + 6;
        }else if(this.joinedType == JOINED_TYPE_NONE_LEFT){
            x1 = getPosX() + getSpan() - 5;
            x2 = getPosX() + getSpan();            
        }else{                              
            x1 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1());
            x2 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2());          
        }

        int eighthY = this.durationCoords.getEighthY();
        int sixteenthY = this.durationCoords.getSixteenthY();
        int thirtySecondY = this.durationCoords.getThirtySecondY();
        int sixtyFourthY = this.durationCoords.getSixtyFourthY();

        switch (note.getDuration().getValue()) {

        case Duration.EIGHTH:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            break;
        case Duration.SIXTEENTH:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
            break;
        case Duration.THIRTY_SECOND:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
            gc.drawLine(fromX + x1, fromY + thirtySecondY, fromX + x2, fromY + thirtySecondY);
            break;
        case Duration.SIXTY_FOURTH:
            gc.drawLine(fromX + x1, fromY + eighthY, fromX + x2, fromY + eighthY);
            gc.drawLine(fromX + x1, fromY + sixteenthY, fromX + x2, fromY + sixteenthY);
            gc.drawLine(fromX + x1, fromY + thirtySecondY, fromX + x2, fromY + thirtySecondY);
            gc.drawLine(fromX + x1, fromY + sixtyFourthY, fromX + x2, fromY + sixtyFourthY);
            break;
        }
        gc.setLineWidth(1);
    }

    private void paintDotted(GC gc, int fromX, int fromY,boolean doubleDotted) {
        int x = fromX + getPosX()  + getSpan();
        int y = fromY;

        switch (this.joinedType) {
        case JOINED_TYPE_NONE_RIGHT:
            x += 4;
            break;
        case JOINED_TYPE_NONE_LEFT:
            x -= 5;
            break;
        case JOINED_TYPE_LEFT:
            x -= 5;
            break;
        case JOINED_TYPE_RIGHT:
            x += 4;
            break;
        }
        
        switch (note.getDuration().getValue()) {
        case Duration.EIGHTH:
            y += this.durationCoords.getEighthY() - 5;
            break;
        case Duration.SIXTEENTH:
            y += this.durationCoords.getSixteenthY() - 5;
            break;
        case Duration.THIRTY_SECOND:
            y += this.durationCoords.getThirtySecondY() - 5;
            break;
        case Duration.SIXTY_FOURTH:
            y += this.durationCoords.getSixtyFourthY() - 5;
            break;
        default:
        	y += meassureCoords.getTabHeight() + 22;
            //y += meassureCoords.getHeight() + 22;
        	x = fromX + getPosX() + 4  + getSpan();
            break;
        }

        gc.drawOval(x, y, 1, 1);
        if(doubleDotted){
            gc.drawOval(x + 3, y, 1, 1);    
        }
    }

    
    /**
     * Pinta los efectos
     */
    private void paintEffects(GC gc, int fromX, int fromY){
        int x = fromX + getPosX() + getSpan();
        int y = fromY + getPosY();        
        
        NoteEffect effect = getNote().getEffect();
        if(effect.hasEffects()){
            if (effect.isVibrato()) {
                paintVibrato(gc,fromX,fromY);
            }        
            if(effect.isBend()){
                gc.drawImage(this.bendImage,this.posX + fromX + 5 + getSpan(),this.posY + fromY - 12);
            }else if(effect.isSlide() || effect.isHammer()){                                
                int nextFromX = fromX;
                MeasureComponent nextComponent = this.meassureCoords.getNextNoteComponent(this,getNote().getString());

                    if(effect.isSlide()){                

                        if(nextComponent != null){
                            NoteCoords nextNote = (NoteCoords)nextComponent;
                            //int nextX = nextNote.getPosX() + nextFromX;
                            int nextX = nextNote.getPosX() + nextFromX + meassureCoords.getSpanForComponent(nextNote);
                            int nextY = y;
                            if(nextNote.getNote().getValue() < getNote().getValue()){                        
                                y -= 3;
                                nextY += 3;                          
                            }else if(nextNote.getNote().getValue() > getNote().getValue()){
                                y += 3;
                                nextY -= 3;                                             
                            }else{
                                y -= 3;
                                nextY -= 3;
                            }
                            gc.drawLine(x + 5,y,nextX - 2,nextY);
                        }else{
                            gc.drawLine(x + 5,y - 3,x + 20 - 2,y - 3);
                        }
                    }else if(effect.isHammer()){                   
                        if(nextComponent != null){                 
                            NoteCoords nextNote = (NoteCoords)nextComponent;
                            int nextX = nextNote.getPosX() + nextFromX + meassureCoords.getSpanForComponent(nextNote);                        
                            gc.drawArc(x + 5,y - 5, (nextX - 6 - (x + 5)),15,45,90);
                            //gc.drawArc(x,y, (nextX - x),-5,45,90);                            
                        }else{
                        	gc.drawArc(x + 5,y - 5,10,15,45,90);
                            //gc.drawArc(x,y,20,-5,45,90);
                        }
                    }
                
            }
        }
    }
    
    private void paintVibrato(GC gc,int fromX,int fromY){                        
        int width = getWidth();
        int y1 = fromY - 2;
        int y2 = fromY + 2;
        
        gc.setLineWidth(2);
        for(int x = (this.posX + fromX + getSpan());x < (this.posX + fromX + width + getSpan()) - 5;x += 3){            
            gc.drawLine(x,y1,x + 3,y2);
            y2 = y1;
            y1 = (y1 < fromY)?fromY + 2:fromY - 2;
        }
        
        gc.setLineWidth(1);
    }
    
    /**
     * Pinta la figura de la Duracion para la partitura
     */
    private void paintScoreDuration(ViewLayout layout,GC gc, int fromX, int fromY) {
    	//KEY  0 = DO
    	int key = meassureCoords.getMeasure().getKeySignature();
    	int clef = meassureCoords.getMeasure().getClef();
    	int noteValue = getRealValue();
    	int scoreLineSpan = layout.getScoreLineSpan();
    	
    	int x = fromX + getPosX() + getSpan();    	
    	int y1 = fromY + getScorePosY();
		//int y1 = fromY + scoreBeatHelper.getY1(layout,this,key,clef);		
		
		//----------lineas extras----------------------------------
		if(y1 < (fromY + scoreLineSpan)){
			gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));
			for(int i = (fromY + scoreLineSpan);i > y1;i -= scoreLineSpan){
				gc.drawLine(x - 4,i,x + 12,i);
			}
		}else if(y1 > (fromY + (scoreLineSpan * 5))){
			gc.setForeground(tablature.getDisplay().getSystemColor(SWT.COLOR_BLACK));
			for(int i = (fromY +(scoreLineSpan * 5));i < y1;i += scoreLineSpan){
				gc.drawLine(x - 4,(i + scoreLineSpan),x + 12,(i + scoreLineSpan));
			}			
		}
		
		//-------------background--------------------------------------
		boolean playMode = (layout.isPlayModeEnabled() && isPlaying());		
        if(playMode){
        	layout.setPlayNoteColor(gc);
        }else{
        	layout.setScoreNoteColor(gc);
        }
        
		//----------ligadura---------------------------------------
        if (getNote().isTiedNote()) {        
        	NoteCoords noteForTie = getNoteForTie();
        	if (noteForTie != null && noteForTie.isAtSameLine(fromY)) {               		        	
        		int ligadureX = noteForTie.getPointX();
        		int ligadureY = noteForTie.getLastFromY() + getScorePosY();
        		//int ligadureY = noteForTie.getLastFromY() + scoreBeatHelper.getY1(layout,this,key,clef);

        		gc.drawArc(ligadureX + 3, ligadureY - 3, (x - ligadureX), 35, 45, 90);
        	}else{        		
        		gc.drawArc(x - 10,y1 - 2,10, 30, 45, 90);            	
        	}           	
        }						
		//----------sostenido--------------------------------------
		
		boolean isSharpKey = KEY_SIGNATURES[key][SCORE_SHARP_NOTES[noteValue % 12]] == SHARP;
		boolean isFlatKey = KEY_SIGNATURES[key][SCORE_FLAT_NOTES[noteValue % 12]] == FLAT;
		boolean isNoNaturalNote = NO_NATURAL_NOTES[noteValue % 12];
		
		if(key <= 7){		
			if(isNoNaturalNote && !isSharpKey){
				gc.drawImage(SystemImages.KEY_SHARP,x - 7 ,y1 - 1);			
			}		
			if(isSharpKey && !isNoNaturalNote){
				gc.drawImage(SystemImages.KEY_NATURAL,x - 7,y1 -3);
			}
		}else{
			if(isNoNaturalNote && !isFlatKey){
				gc.drawImage(SystemImages.KEY_FLAT,x - 7 ,y1 -2);			
			}		
			if(isFlatKey && !isNoNaturalNote){
				gc.drawImage(SystemImages.KEY_NATURAL,x - 7,y1 -3);
			}			
		}
		//----------fin sostenido--------------------------------------
		int size = (layout.getScoreLineSpan() - 2);
		
		gc.drawOval(x,y1 + 1,size,size);
		//relleno el circulo
		if(note.getDuration().getValue() >= Duration.QUARTER){
			gc.setBackground(gc.getForeground());
			gc.fillOval(x,y1 + 1,size,size);
			gc.setBackground(tablature.getDisplay().getSystemColor(SWT.COLOR_WHITE));
		}
		
        if(playMode){
        	layout.setScoreNoteColor(gc);
        } 		
        
		  
        //PUNTILLO y DOBLE PUNTILLO
        if (note.getDuration().isDotted() || note.getDuration().isDoubleDotted()) {
        	gc.setLineWidth(3);        	
            gc.drawOval(x + 13, y1 + 4, 1, 1);
            if(note.getDuration().isDoubleDotted()){
                gc.drawOval(x + 18,y1 + 4, 1, 1);    
            }                       
            gc.setLineWidth(1);
        }        
        //TUPLETO
        if (!note.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)) {
        	gc.drawString(Integer.toString(note.getDuration().getTupleto().getEnters()), x + 1, fromY + layout.getScoreSpan() - 12);
            //gc.drawString(Integer.toString(note.getDuration().getTupleto().getEnters()), x + 2, fromY + 95);
        }        
        
		//dibujo el pie
		if(note.getDuration().getValue() >= Duration.HALF){
	    	y1 += 5;
			if(scoreBeatHelper.getDirection() == ScoreBeatHelper.DIRECTION_UP){
	    		x += size + 1;
	    		fromX += size + 1;
	    		//x += 9;
	    		//fromX += 9;
	    	}
			
	        int y2 = fromY + scoreBeatHelper.getY2(layout,getPosX() + getSpan(),key,clef);
	        gc.drawLine(x, y1, x, y2);
	        
	        
	        if (note.getDuration().getValue() >= Duration.EIGHTH) {
	        	paintScoreJoindeds(layout,gc,fromX ,fromY,key,clef);
	        }
		}    	

    }

        
    public void paintScoreJoindeds(ViewLayout layout,GC gc, int fromX, int fromY,int key,int clef) {
        
        
        int dir = (scoreBeatHelper.getDirection() == ScoreBeatHelper.DIRECTION_DOWN)?1:-1;
        
        if((this.joinedType == JOINED_TYPE_NONE_LEFT || this.joinedType == JOINED_TYPE_NONE_RIGHT) && !this.joinedGreaterThanQuarter){
        	gc.setLineWidth(2);
        	
        	int x = fromX + getPosX() + getSpan();
        	int x2 = x + 7;        	
        	int y = fromY + scoreBeatHelper.getY2(layout,getPosX() + getSpan(),key,clef);        	
        	
        	switch (note.getDuration().getValue()) {
        	case Duration.EIGHTH:
            	gc.drawLine(x,y,x2,y - (6 * dir));        		
        		break;
        	case Duration.SIXTEENTH:
            	gc.drawLine(x,y,x2,y - (6 * dir));
            	gc.drawLine(x,y - (5 * dir),x2,(y - (5 * dir)) - (6 * dir)); 
        		break;
        	case Duration.THIRTY_SECOND:
            	gc.drawLine(x,y,x2,y - (6 * dir));
            	gc.drawLine(x,y - (5 * dir),x2,(y - (5 * dir)) - (6 * dir));
            	gc.drawLine(x,y - (10 * dir),x2,(y - (10 * dir)) - (6 * dir));
        		break;
        	case Duration.SIXTY_FOURTH:
            	gc.drawLine(x,y,x2,y - (6 * dir));
            	gc.drawLine(x,y - (5 * dir),x2,(y - (5 * dir)) - (6 * dir));
            	gc.drawLine(x,y - (10 * dir),x2,(y - (10 * dir)) - (6 * dir));
            	gc.drawLine(x,y - (15 * dir),x2,(y - (15 * dir)) - (6 * dir));        		
        		break;
        	}        	
        	y += dir;
        	
        	gc.drawLine(x2,y - (6 * dir),x2,y - (6 * dir) - (16 * dir));
        	gc.setLineWidth(1);
        }else{
        	gc.setLineWidth(3);
        	
            int x1 = 0;
            int x2 = 0;        
            
            if(this.joinedType == JOINED_TYPE_NONE_RIGHT){
                x1 = getPosX() + getSpan();
                x2 = getPosX() + getSpan() + 6;
            }else if(this.joinedType == JOINED_TYPE_NONE_LEFT){
                x1 = getPosX() + getSpan() - 5;
                x2 = getPosX() + getSpan();            
            }else{                              
                x1 = this.durationCoords.getNote1().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote1());
                x2 = this.durationCoords.getNote2().getPosX() + this.meassureCoords.getSpanForComponent(this.durationCoords.getNote2());          
            }                                
        	int y1 = fromY + scoreBeatHelper.getY2(layout,x1,key,clef);
        	int y2 = fromY + scoreBeatHelper.getY2(layout,x2,key,clef);
        
        	
        
        	switch (note.getDuration().getValue()) {

        	case Duration.EIGHTH:
        		gc.drawLine(fromX + x1, y1, fromX + x2,y2);
        		break;
        	case Duration.SIXTEENTH:
        		gc.drawLine(fromX + x1,y1, fromX + x2,y2);
        		gc.drawLine(fromX + x1,y1 - (5 * dir), fromX + x2,y2 - (5 * dir));
        		break;
        	case Duration.THIRTY_SECOND:
        		gc.drawLine(fromX + x1,y1, fromX + x2,y2);
        		gc.drawLine(fromX + x1,y1 - (5 * dir), fromX + x2,y2 - (5 * dir));
        		gc.drawLine(fromX + x1,y1 - (10 * dir), fromX + x2,y2 - (10 * dir));
        		break;
        	case Duration.SIXTY_FOURTH:
        		gc.drawLine(fromX + x1,y1, fromX + x2,y2);
        		gc.drawLine(fromX + x1,y1 - (5 * dir), fromX + x2,y2 - (5 * dir));
        		gc.drawLine(fromX + x1,y1 - (10 * dir), fromX + x2,y2 - (10 * dir));
        		gc.drawLine(fromX + x1,y1 - (15 * dir), fromX + x2,y2 - (15 * dir));
        		break;
        	}
        	
        	 gc.setLineWidth(1);
        }
               
    }        
    

    private boolean isPlaying(){
        if(meassureCoords.isPlaying()){
            long playerTickPosition = this.tablature.getSongManager().getPlayer().getTickPosition();
            if(playerTickPosition >= getNote().getStart()  && playerTickPosition < getNote().getStart() + getNote().getDuration().getTime()){            
                return true;
            }
        }
        return false;
    }
    
    private int getWidth(){
        double quartersInDuration = ((1.00 / (double)getNote().getDuration().getValue()) * 4.00);
        int width = (int)((double)this.meassureCoords.getQuarterSpan() * quartersInDuration);
        return width;
    }
    
    /**
     * Asigna el start de la nota
     */
    public void setStart(long start) {
        this.note.setStart(start);
    }

    /**
     * Retorna el start de la nota
     */
    public long getStart() {
        return this.note.getStart();
    }

    /**
     * Asigna la duracion de la nota
     */
    public void setDuration(Duration duration) {
        this.note.setDuration(duration);
    }

    /**
     * Retorna la duracion de la nota
     */
    public Duration getDuration() {
        return this.note.getDuration();
    }

    /**
     * Retorna la nota de Referencia
     */
    public Note getNote() {
        return note;
    }

    /**
     * Retorna posicion X dentro del compas
     */
    public int getPosX() {
        return posX;
    }

    /**
     * Retorna posicion Y dentro del compas
     */
    public int getPosY() {
        return posY;
    }

    /**
     * Retorna posicion del ultimo fromX
     */
    public int getLastFromX() {
        return lastFromX;
    }

    /**
     * Retorna posicion del ultimo fromY
     */
    public int getLastFromY() {
        return lastFromY;
    }
    
    public boolean isAtSameLine(int y){
    	return (!meassureCoords.isOutOfBounds() && (getLastFromY() == y));   
    }
    
    public int getSpan(){
        return meassureCoords.getSpanForComponent(this);
    }
    
    public int getPointX(){
        return this.pointX;
    }
    public int getPointY(){
        return this.pointY;
    }

    public int getRealValue(){
    	return this.realValue;    	
    }
    
	public ScoreBeatHelper getScoreBeatHelper() {
		return scoreBeatHelper;
	}

	public void setScoreBeatHelper(ScoreBeatHelper scoreBeatHelper) {
		this.scoreBeatHelper = scoreBeatHelper;
	}

	public Component getComponent() {
		return getNote();
	}

	public int getScorePosY() {
		return scorePosY;
	}
    

}