package org.herac.tuxguitar.gui.mixer;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.song.models.SongTrack;

public class TrackMixer {
	private SongMixer mixer;
	private SongTrack track;
	private Button soloCheckBox;
	private Button muteCheckBox;
	private Scale balanceScale;
	private Scale volumeScale;
	private Text volumeText;
	private Label channelLabel;
    private Label volumeLabel;
    
	public TrackMixer(SongMixer mixer,SongTrack track){
		this.mixer = mixer;
		this.track = track;
	}
	
	public void init(final Composite parent) {
		final Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(1, true));
		composite.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		
		this.channelLabel = new Label(composite, SWT.NULL);		
		
		this.soloCheckBox = new Button(composite,SWT.CHECK);
		this.soloCheckBox.setSelection(track.getChannel().isSolo());
		this.soloCheckBox.addSelectionListener(new SelectionAdapter() {	
			public void widgetSelected(SelectionEvent e) {
				track.getChannel().setSolo(soloCheckBox.getSelection());
				if(track.getChannel().isSolo()){
					track.getChannel().setMute(false);
				}
				mixer.fireChanges(track.getChannel());
			}		
		});
		this.muteCheckBox = new Button(composite,SWT.CHECK);
		this.muteCheckBox.setSelection(track.getChannel().isMute());
		this.muteCheckBox.addSelectionListener(new SelectionAdapter() {	
			public void widgetSelected(SelectionEvent e) {
				track.getChannel().setMute(muteCheckBox.getSelection());
				if(track.getChannel().isMute()){
					track.getChannel().setSolo(false);
				}				
				mixer.fireChanges(track.getChannel());
			}		
		});
		
		this.balanceScale = new Scale(composite, SWT.HORIZONTAL);
		
		this.volumeLabel = new Label(composite, SWT.NULL);
		this.volumeScale = new Scale(composite, SWT.VERTICAL);
		this.volumeText = new Text(composite, SWT.BORDER | SWT.SINGLE);


		GridData data = new GridData();
		data.widthHint = 70;
		data.heightHint = 17;
		this.balanceScale.setMaximum(127);
		this.balanceScale.setMinimum(0);
		this.balanceScale.setIncrement(1);
		this.balanceScale.setPageIncrement(1);
		this.balanceScale.setLayoutData(data);				

		data = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
		data.widthHint = 40;
		data.heightHint = 100;
		this.volumeScale.setMaximum(127);
		this.volumeScale.setMinimum(0);
		this.volumeScale.setIncrement(1);
		this.volumeScale.setPageIncrement(5);
		this.volumeScale.setLayoutData(data);

		data = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
		data.widthHint = 25;
		data.heightHint = 13;
		this.volumeText.setEditable(false);
		this.volumeText.setLayoutData(data);

		this.balanceScale.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				track.getChannel().setBalance((short)balanceScale.getSelection());
				balanceScale.setToolTipText(TuxGuitar.getProperty("track.channel.balance") + ": " + track.getChannel().getBalance());
				mixer.fireChanges(track.getChannel());
			}
		});
		
		this.volumeScale.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				track.getChannel().setVolume((short)(volumeScale.getMaximum() - volumeScale.getSelection()));
				volumeScale.setToolTipText(TuxGuitar.getProperty("track.channel.volume") + ": " + track.getChannel().getVolume());
				mixer.fireChanges(track.getChannel());
			}
		});

		this.balanceScale.setSelection(track.getChannel().getBalance());
		this.balanceScale.setToolTipText("Balance: " + track.getChannel().getBalance());
		this.volumeScale.setSelection(this.volumeScale.getMaximum() - track.getChannel().getVolume());
		this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
	}
	
	public void fireChanges(){
		this.soloCheckBox.setSelection(track.getChannel().isSolo());
		this.muteCheckBox.setSelection(track.getChannel().isMute());
		this.volumeScale.setSelection(this.volumeScale.getMaximum() - track.getChannel().getVolume());
		this.volumeText.setText(Integer.toString(this.volumeScale.getMaximum() - this.volumeScale.getSelection()));
	}
	
	public SongTrack getTrack(){
		return this.track;
	}
	
	public void loadProperties(){
		this.channelLabel.setText("CH:" + track.getChannel().getChannel() + " EC:" + track.getChannel().getEffectChannel());
		this.soloCheckBox.setText(TuxGuitar.getProperty("track.channel.solo"));
		this.muteCheckBox.setText(TuxGuitar.getProperty("track.channel.mute"));
		this.volumeLabel.setText(TuxGuitar.getProperty("track.channel.volume") + ":");
		this.volumeScale.setToolTipText(TuxGuitar.getProperty("track.channel.volume") + ": " + track.getChannel().getVolume());
		this.balanceScale.setToolTipText(TuxGuitar.getProperty("track.channel.balance") + ": " + track.getChannel().getBalance());
	}
	
}
