package org.herac.tuxguitar.gui.marker;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.tab.MeasureComponent;
import org.herac.tuxguitar.gui.tab.MeasureCoords;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.song.models.Marker;

public class MarkerNavigator {

	public MarkerNavigator(){		
	}
	
	public void goToSelectedMarker(Marker marker){                                
        if(marker != null){
        	Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        	SongTrackCoords track = caret.getSongTrackCoords();
        	MeasureCoords measure = null;
        	MeasureComponent component = null;        	
        	
        	if(track != null){
        		measure = track.getMeasure(TuxGuitar.instance().getSongManager().getTrackManager().getMeasure(track.getTrack(),marker.getMeasure()));
        	}        	
    	    if(measure != null){
    	        component = measure.getFirstComponent();
    	    }    
            if(track != null && measure != null && component != null){
                caret.moveTo(track,measure,component,caret.getSelectedString().getNumber());        
                caret.setChanges(true);
                TuxGuitar.instance().redraw();
            }	     	    
        }		
	}
}
