package org.herac.tuxguitar.gui.marker;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeMarker;
import org.herac.tuxguitar.song.models.Marker;

public class MarkerList {
	private Shell dialog;	
	private Table table;
	private List markers;
	
	public MarkerList() {
	}

	public void show(Shell shell) {

		dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
		dialog.setLayout(new GridLayout(2,false));
		dialog.setText(TuxGuitar.getProperty("marker.list"));
		dialog.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
		// ----------------------------------------------------------------------
		Composite composite = new Composite(dialog, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		table = new Table(composite, SWT.BORDER);
		table.setLayoutData(new GridData(250,200));
		TableColumn measureColumn = new TableColumn(table, SWT.LEFT);
		TableColumn titleColumn = new TableColumn(table, SWT.LEFT);

		measureColumn.setText(TuxGuitar.getProperty("measure"));		
		measureColumn.setWidth(70);
		titleColumn.setText(TuxGuitar.getProperty("title"));
		titleColumn.setWidth(180);
		table.setHeaderVisible(true);

		loadTableItems();
		
		// ------------------BUTTONS--------------------------
		Composite buttons = new Composite(dialog, SWT.NONE);
		buttons.setLayout(new GridLayout(1,false));
		buttons.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));    	

		final Button buttonAdd = new Button(buttons, SWT.PUSH);
		buttonAdd.setText(TuxGuitar.getProperty("add"));
		buttonAdd.setLayoutData(makeGridData(SWT.FILL, SWT.TOP,false,80,25));
		buttonAdd.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
				Marker marker = new Marker(caret.getMeasureCoords().getMeasure().getNumber());
				new MarkerEditor(marker,MarkerEditor.STATUS_NEW).show(dialog);
				loadTableItems();
			}
		});

		final Button buttonEdit = new Button(buttons, SWT.PUSH);
		buttonEdit.setText(TuxGuitar.getProperty("edit"));
		buttonEdit.setLayoutData(makeGridData(SWT.FILL, SWT.TOP,false,80,25));
		buttonEdit.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				Marker marker = getSelectedMarker();
				if(marker != null){
					new MarkerEditor(marker,MarkerEditor.STATUS_EDIT).show(dialog);
					loadTableItems();
				}
			}
		});			
		
		final Button buttonDelete = new Button(buttons, SWT.PUSH);
		buttonDelete.setText(TuxGuitar.getProperty("remove"));
		buttonDelete.setLayoutData(makeGridData(SWT.FILL, SWT.TOP,false,80,25));
		buttonDelete.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				Marker marker = getSelectedMarker();
				// comienza el undoable
				UndoableChangeMarker undoable = UndoableChangeMarker.startUndo(marker);
				
				TuxGuitar.instance().getSongManager().removeMarker(marker);
				loadTableItems();
				
				// termia el undoable
				TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoable.endUndo(null));				
			}
		});			
		
		Button buttonGo = new Button(buttons, SWT.PUSH);
		buttonGo.setText(TuxGuitar.getProperty("go"));
		buttonGo.setLayoutData(makeGridData(SWT.FILL, SWT.BOTTOM,true,80,25));
		buttonGo.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				new MarkerNavigator().goToSelectedMarker(getSelectedMarker());
			}
		});		
		
		Button buttonExit = new Button(buttons, SWT.PUSH);
		buttonExit.setText(TuxGuitar.getProperty("exit"));
		buttonExit.setLayoutData(makeGridData(SWT.FILL, SWT.BOTTOM,false,80,25));
		buttonExit.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent arg0) {
				dialog.dispose();
			}
		});

		dialog.pack();
		dialog.open();

		int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
		int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
		dialog.setLocation(x, y);

		while (!dialog.isDisposed()) {
			if (!dialog.getDisplay().readAndDispatch()) {
				dialog.getDisplay().sleep();
			}

		}

	}
	
	private GridData makeGridData(int horizontalAlignment,int verticalAlignment,boolean grabExcessVerticalSpace,int minimumWidth,int minimumHeight){
		GridData data = new GridData();
		data.horizontalAlignment = horizontalAlignment;
		data.verticalAlignment = verticalAlignment;
		data.grabExcessHorizontalSpace = true;
		data.grabExcessVerticalSpace = grabExcessVerticalSpace;
		data.minimumWidth = 80;
		data.minimumHeight = 25;	
		
		return data;
	}

	private void clearTableItems(){
		TableItem[] items = this.table.getItems();
		for(int i = 0;i < items.length;i++){
			items[i].dispose();
		}
	}
	
	private void loadTableItems(){
		int itemSelected = table.getSelectionIndex();
		
		this.clearTableItems();
		this.markers = TuxGuitar.instance().getSongManager().getMarkers();
		
		Iterator it = this.markers.iterator();
		while (it.hasNext()) {
			Marker marker = (Marker) it.next();

			TableItem item = new TableItem(table, SWT.NONE);
			item.setText(new String[] { Integer.toString(marker.getMeasure()),marker.getTitle() });
		}		
		
		if(itemSelected >= 0 && itemSelected < markers.size()){
			table.select(itemSelected);
		}
	}	
	
	private Marker getSelectedMarker(){
		int itemSelected = table.getSelectionIndex();
		if(itemSelected >= 0 && itemSelected < markers.size()){
			return (Marker)markers.get(itemSelected);
		}
		return null;
	}
	

}
