/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.language;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.ResourceBundle;

import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

/**
 * @author julian
 * 
 */
public class LanguageManager {	

    private ResourceBundle resources;
    private String[] languages;
    
    public LanguageManager() {
        this.loadLanguages();
    }
    
    public void setLanguage(String lang) { 
        try {
        	if(lang == null){
        		this.resources = ResourceBundle.getBundle("lang.messages");
        	}else{
        		this.resources = ResourceBundle.getBundle("lang.messages", new Locale(lang));
        	}
        } catch (Exception e) {
        	e.printStackTrace();        	
        }
    }
    
    
    public String getProperty(String key) {
    	String s = null;

    	try {
    		s = resources.getString(key);
    	}catch(Exception e){}
    	
        return (s == null)?key:s;
    }    
        
    public String getLanguage() {
    	if(this.resources != null){
    		return this.resources.getLocale().getLanguage();
    	}
    	return null;
    }
    
    
    public String[] getLanguages() {
        return this.languages;
    }
    
    /**
     * Load language files from lang folder
     *
     */
    private void loadLanguages(){
    	// we need .properties files only
        final FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return (name.indexOf("messages_") != -1 && name.indexOf(".properties") != -1);
            }
        };          
        // get the files
        String langFolderPath = TuxGuitarFileUtils.LANGUAGE_PREFIX;
        if(langFolderPath != null){        	
        	File langFolder = new File(langFolderPath);
        	if(langFolder != null){
        		String[] fileNames = langFolder.list(filter);
        		this.languages = new String[fileNames.length];        
        		// now iterate over them
        		for(int i = 0;i < fileNames.length;i++){        	
        			if (fileNames[i].indexOf("messages_") != -1){
        				this.languages[i] = fileNames[i].substring(9,11);
        			}        		
        		}
        	}
        }
    }    

}