package org.herac.tuxguitar.gui.keybindings;

import java.util.HashMap;
import java.util.Map;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.duration.ChangeDottedDurationAction;
import org.herac.tuxguitar.gui.actions.duration.ChangeTupletoDurationAction;
import org.herac.tuxguitar.gui.actions.edit.RedoAction;
import org.herac.tuxguitar.gui.actions.edit.UndoAction;
import org.herac.tuxguitar.gui.actions.file.NewFileAction;
import org.herac.tuxguitar.gui.actions.file.OpenFileAction;
import org.herac.tuxguitar.gui.actions.file.SaveFileAction;
import org.herac.tuxguitar.gui.actions.player.PlaySongAction;

public class KeyBindingDefaults {
	
	public static Map getDefaultKeyBindings(){
		Map keyBindings = new HashMap();
		//Save File: Ctrl + S
		keyBindings.put(new KeyBinding(115,262144),TuxGuitar.instance().getAction(SaveFileAction.NAME));
		//Open File: Ctrl + W
		keyBindings.put(new KeyBinding(119,262144),TuxGuitar.instance().getAction(OpenFileAction.NAME));	
		//New File: Alt + Ctrl + N
		keyBindings.put(new KeyBinding(110,327680),TuxGuitar.instance().getAction(NewFileAction.NAME));	
		//Undo: Ctrl + Z			
		keyBindings.put(new KeyBinding(122,262144),TuxGuitar.instance().getAction(UndoAction.NAME));	
		//Redo: Ctrl + Y				 
		keyBindings.put(new KeyBinding(121,262144),TuxGuitar.instance().getAction(RedoAction.NAME));
		//Play-Pause: Space		
		keyBindings.put(new KeyBinding(32,0),TuxGuitar.instance().getAction(PlaySongAction.NAME));
		//Dotted Duration: '*'
		keyBindings.put(new KeyBinding(16777258,0),TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));
		//Dotted Duration: '.'
		keyBindings.put(new KeyBinding(16777262,0),TuxGuitar.instance().getAction(ChangeDottedDurationAction.NAME));
		//Tupleto Duration: '/'
		keyBindings.put(new KeyBinding(16777263,0),TuxGuitar.instance().getAction(ChangeTupletoDurationAction.NAME));
		
		return keyBindings;
	}
}
