/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.tool;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.layout.SetLinearLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetMultitrackViewAction;
import org.herac.tuxguitar.gui.actions.layout.SetPageLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetScoreEnabledAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.layout.PageViewLayout;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LayoutToolItems implements ItemContainer{
    public static final String NAME = "COMPOSITION_ITEMS";
    
    private TablatureEditor tablatureEditor;
    private ToolBar toolBar;
    private ToolItem pageLayout;
    private ToolItem linearLayout;
    private ToolItem multitrack;
    private ToolItem scoreEnabled;
    
    public LayoutToolItems(TablatureEditor tablatureEditor,ToolBar toolBar){
        this.tablatureEditor = tablatureEditor;
        this.toolBar = toolBar;
    }
   
    public void showItems(){
        this.pageLayout = new ToolItem(toolBar, SWT.RADIO);        
        this.pageLayout.setImage(SystemImages.LAYOUT_PAGE);
        this.pageLayout.addSelectionListener(TuxGuitar.instance().getAction(SetPageLayoutAction.NAME));
    	
        this.linearLayout = new ToolItem(toolBar, SWT.RADIO);        
        this.linearLayout.setImage(SystemImages.LAYOUT_LINEAR);
        this.linearLayout.addSelectionListener(TuxGuitar.instance().getAction(SetLinearLayoutAction.NAME));
        
        this.multitrack = new ToolItem(toolBar, SWT.CHECK);        
        this.multitrack.setImage(SystemImages.LAYOUT_MULTITRACK);
        this.multitrack.addSelectionListener(TuxGuitar.instance().getAction(SetMultitrackViewAction.NAME));
        
        this.scoreEnabled = new ToolItem(toolBar, SWT.CHECK);        
        this.scoreEnabled.setImage(SystemImages.LAYOUT_SCORE);
        this.scoreEnabled.addSelectionListener(TuxGuitar.instance().getAction(SetScoreEnabledAction.NAME));
        
        this.loadProperties();
    }

    public void loadProperties(){
        this.pageLayout.setToolTipText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setToolTipText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setToolTipText(TuxGuitar.getProperty("layout.multitrack"));
        this.scoreEnabled.setToolTipText(TuxGuitar.getProperty("layout.score-enabled"));
    }
    
    public void update(){
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
        this.scoreEnabled.setSelection(this.tablatureEditor.getTablature().getViewLayout().isScoreEnabled());
    }
}

