/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.track.AddTrackAction;
import org.herac.tuxguitar.gui.actions.track.ChangeTrackPropertiesAction;
import org.herac.tuxguitar.gui.actions.track.CloneTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoFirstTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoLastTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoNextTrackAction;
import org.herac.tuxguitar.gui.actions.track.GoPreviousTrackAction;
import org.herac.tuxguitar.gui.actions.track.MoveTrackDownAction;
import org.herac.tuxguitar.gui.actions.track.MoveTrackUpAction;
import org.herac.tuxguitar.gui.actions.track.RemoveTrackAction;
import org.herac.tuxguitar.gui.items.ItemContainer;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TrackMenuItem implements ItemContainer{
    private TablatureEditor tablatureEditor;
    private MenuItem trackMenuItem;
    private Menu menu; 
    private MenuItem first;
    private MenuItem last;
    private MenuItem next;
    private MenuItem previous;    
    private MenuItem addTrack;
    private MenuItem cloneTrack;
    private MenuItem removeTrack;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem properties;
    
    public TrackMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.trackMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //--First--
        this.first = new MenuItem(this.menu, SWT.PUSH);
        this.first.addSelectionListener(TuxGuitar.instance().getAction(GoFirstTrackAction.NAME));
        //--previous--
        this.previous = new MenuItem(this.menu, SWT.PUSH);
        this.previous.addSelectionListener(TuxGuitar.instance().getAction(GoPreviousTrackAction.NAME));        
        //--next--
        this.next = new MenuItem(this.menu, SWT.PUSH);
        this.next.addSelectionListener(TuxGuitar.instance().getAction(GoNextTrackAction.NAME));        
        //--last--
        this.last = new MenuItem(this.menu, SWT.PUSH);
        this.last.addSelectionListener(TuxGuitar.instance().getAction(GoLastTrackAction.NAME));          
        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);          
        //--ADD TRACK--
        this.addTrack = new MenuItem(this.menu, SWT.PUSH);
        this.addTrack.addSelectionListener(TuxGuitar.instance().getAction(AddTrackAction.NAME));
        //--CLONE TRACK--
        this.cloneTrack = new MenuItem(this.menu, SWT.PUSH);
        this.cloneTrack.addSelectionListener(TuxGuitar.instance().getAction(CloneTrackAction.NAME));        
        //--REMOVE TRACK--
        this.removeTrack = new MenuItem(this.menu, SWT.PUSH);  
        this.removeTrack.addSelectionListener(TuxGuitar.instance().getAction(RemoveTrackAction.NAME)); 
        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);
        //--MOVE UP--
        this.moveUp = new MenuItem(this.menu, SWT.PUSH);  
        this.moveUp.addSelectionListener(TuxGuitar.instance().getAction(MoveTrackUpAction.NAME));
        //--MOVE DOWN--        
        this.moveDown = new MenuItem(this.menu, SWT.PUSH);  
        this.moveDown.addSelectionListener(TuxGuitar.instance().getAction(MoveTrackDownAction.NAME));        
        //--SEPARATOR
        new MenuItem(this.menu, SWT.SEPARATOR);                  
        //--PROPERTIES--
        this.properties = new MenuItem(this.menu, SWT.PUSH);                  
        this.properties.addSelectionListener(TuxGuitar.instance().getAction(ChangeTrackPropertiesAction.NAME));  
        
        
        this.trackMenuItem.setMenu(menu);      
        
        this.loadProperties();
    }

    
    public void update(){
    }
    
    public void loadProperties(){
        this.trackMenuItem.setText(TuxGuitar.getProperty("track"));        
        this.first.setText(TuxGuitar.getProperty("track.first"));
        this.last.setText(TuxGuitar.getProperty("track.last"));
        this.previous.setText(TuxGuitar.getProperty("track.previous"));
        this.next.setText(TuxGuitar.getProperty("track.next"));        
        this.addTrack.setText(TuxGuitar.getProperty("track.add"));
        this.cloneTrack.setText(TuxGuitar.getProperty("track.clone"));
        this.removeTrack.setText(TuxGuitar.getProperty("track.remove"));
        this.moveUp.setText(TuxGuitar.getProperty("track.move-up"));
        this.moveDown.setText(TuxGuitar.getProperty("track.move-down"));
        this.properties.setText(TuxGuitar.getProperty("track.properties"));        
    }        
}
