/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.layout.SetLinearLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetMultitrackViewAction;
import org.herac.tuxguitar.gui.actions.layout.SetPageLayoutAction;
import org.herac.tuxguitar.gui.actions.layout.SetScoreEnabledAction;
import org.herac.tuxguitar.gui.actions.view.ShowFretBoardAction;
import org.herac.tuxguitar.gui.actions.view.ShowMixerAction;
import org.herac.tuxguitar.gui.actions.view.ShowTransportAction;
import org.herac.tuxguitar.gui.items.ItemContainer;
import org.herac.tuxguitar.gui.tab.layout.LinearViewLayout;
import org.herac.tuxguitar.gui.tab.layout.PageViewLayout;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class LayoutMenuItem implements ItemContainer{
    private TablatureEditor tablatureEditor;
    private MenuItem layoutMenuItem;
    private Menu menu; 
    private MenuItem showMixer;
    private MenuItem showTransport;
    private MenuItem showFretBoard;
    private MenuItem pageLayout;
    private MenuItem linearLayout;
    private MenuItem multitrack;
    private MenuItem scoreEnabled;
    
    public LayoutMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.layoutMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){  
        //--MIXER--
        this.showMixer = new MenuItem(this.menu, SWT.CHECK);        
        this.showMixer.addSelectionListener(TuxGuitar.instance().getAction(ShowMixerAction.NAME));
        
        //--TRANSPORT--
        this.showTransport = new MenuItem(this.menu, SWT.CHECK);        
        this.showTransport.addSelectionListener(TuxGuitar.instance().getAction(ShowTransportAction.NAME));    	
        
        //--FRETBOARD--
        this.showFretBoard = new MenuItem(this.menu, SWT.CHECK);        
        this.showFretBoard.addSelectionListener(TuxGuitar.instance().getAction(ShowFretBoardAction.NAME));
        
        new MenuItem(this.menu, SWT.SEPARATOR);
        
        //--PAGE LAYOUT--
        this.pageLayout = new MenuItem(this.menu, SWT.RADIO);        
        this.pageLayout.addSelectionListener(TuxGuitar.instance().getAction(SetPageLayoutAction.NAME));
        //--LINEAR LAYOUT--
        this.linearLayout = new MenuItem(this.menu, SWT.RADIO);  
        this.linearLayout.addSelectionListener(TuxGuitar.instance().getAction(SetLinearLayoutAction.NAME));        
        //--MULTITRACK--
        this.multitrack = new MenuItem(this.menu, SWT.CHECK);        
        this.multitrack.addSelectionListener(TuxGuitar.instance().getAction(SetMultitrackViewAction.NAME));        
        //--SCORE
        this.scoreEnabled = new MenuItem(this.menu, SWT.CHECK);  
        this.scoreEnabled.addSelectionListener(TuxGuitar.instance().getAction(SetScoreEnabledAction.NAME));           
        
        this.layoutMenuItem.setMenu(menu);    
        
        this.loadProperties();
    }

    
    public void update(){
    	this.showMixer.setSelection(!TuxGuitar.instance().getMixer().isDisposed());
    	this.showTransport.setSelection(!TuxGuitar.instance().getTransport().isDisposed());
    	this.showFretBoard.setSelection(TuxGuitar.instance().getFretBoardEditor().getFretBoard().isVisible());
        this.pageLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof PageViewLayout);
        this.linearLayout.setSelection(this.tablatureEditor.getTablature().getViewLayout() instanceof LinearViewLayout);
        this.multitrack.setSelection(this.tablatureEditor.getTablature().getViewLayout().isMultitrack());
        this.scoreEnabled.setSelection(this.tablatureEditor.getTablature().getViewLayout().isScoreEnabled());
    }
    
    public void loadProperties(){    	     
        this.layoutMenuItem.setText(TuxGuitar.getProperty("layout"));
        this.showMixer.setText(TuxGuitar.getProperty("show-mixer"));  
        this.showTransport.setText(TuxGuitar.getProperty("show-transport"));  
        this.showFretBoard.setText(TuxGuitar.getProperty("show-fretboard"));   
        this.pageLayout.setText(TuxGuitar.getProperty("layout.page"));
        this.linearLayout.setText(TuxGuitar.getProperty("layout.linear"));
        this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
        this.scoreEnabled.setText(TuxGuitar.getProperty("layout.score-enabled"));
    }          
}
