/*
 * Created on 18-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.DurationMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.LanguageMenuItem;
import org.herac.tuxguitar.gui.items.menu.LayoutMenuItem;
import org.herac.tuxguitar.gui.items.menu.MarkerMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteEffectsMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.PluginMenuItem;
import org.herac.tuxguitar.gui.items.menu.SettingsMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.EditToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.InsertToolItems;
import org.herac.tuxguitar.gui.items.tool.LayoutToolItems;
import org.herac.tuxguitar.gui.items.tool.MarkerToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.PropertiesToolItems;
import org.herac.tuxguitar.gui.items.tool.RepeatToolItems;
import org.herac.tuxguitar.gui.items.tool.TrackToolItems;
import org.herac.tuxguitar.gui.items.tool.ViewToolItems;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ItemContainerManager {
	private static final int HEIGHT = 32;
	
    private TablatureEditor tablatureEditor;    
    private Menu menu;
    private Menu popupMenu;
    public CoolBar coolBar;
    private List items;
    
    public ItemContainerManager(TablatureEditor tablatureEditor){
        this.tablatureEditor = tablatureEditor;
        this.items = new ArrayList();
    }
    
    public void createToolbar(final Shell shell) {    	    	
    	this.coolBar = new CoolBar(shell,SWT.FLAT);
		
		ToolBar toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);	
        ItemContainer fileItems = new FileToolItems(tablatureEditor,toolBar);
        fileItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer editItems = new EditToolItems(tablatureEditor,toolBar);
        editItems.showItems();
        makeCoolItem(toolBar);

        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer propertiesItems = new PropertiesToolItems(tablatureEditor,toolBar);
        propertiesItems.showItems();
        makeCoolItem(toolBar);        

        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer trackItems = new TrackToolItems(tablatureEditor,toolBar);
        trackItems.showItems();
        makeCoolItem(toolBar);             
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer durationItems = new DurationToolItems(tablatureEditor,toolBar);
        durationItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer compositionItems = new CompositionToolItems(tablatureEditor,toolBar);
        compositionItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer repeatItems = new RepeatToolItems(tablatureEditor, toolBar);
        repeatItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer noteItems = new NoteToolItems(tablatureEditor, toolBar);
        noteItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer playerItems = new PlayerToolItems(tablatureEditor,toolBar);
        playerItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer markerItems = new MarkerToolItems(toolBar);
        markerItems.showItems();
        makeCoolItem(toolBar);              
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer insertItems = new InsertToolItems(tablatureEditor,toolBar);
        insertItems.showItems();
        makeCoolItem(toolBar);
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer layoutItems = new LayoutToolItems(tablatureEditor,toolBar);
        layoutItems.showItems();
        makeCoolItem(toolBar);  
        
        toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);
        ItemContainer viewItems = new ViewToolItems(toolBar);
        viewItems.showItems();
        makeCoolItem(toolBar);  
        
        this.items.add(fileItems);
        this.items.add(editItems);
        this.items.add(compositionItems);
        this.items.add(durationItems);
        this.items.add(repeatItems);
        this.items.add(noteItems);
        this.items.add(playerItems);
        this.items.add(insertItems);
        this.items.add(layoutItems);
        this.items.add(viewItems);
        this.items.add(markerItems);
        
        FormData coolData = new FormData();
        coolData.left = new FormAttachment(0);
        coolData.right = new FormAttachment(100);
        coolData.top = new FormAttachment(0,5);        
        coolBar.setLayoutData(coolData);
        coolBar.addListener(SWT.Resize, new Listener() {
          public void handleEvent(Event event) {
        	  shell.layout();
          }
        });

    }    
    
    private void makeCoolItem(ToolBar toolBar){
    	CoolItem coolItem = new CoolItem(coolBar,SWT.NONE);
        coolItem.setControl(toolBar);
        Point size = toolBar.computeSize( SWT.DEFAULT,SWT.DEFAULT);
        Point coolSize = coolItem.computeSize(size.x, HEIGHT);
	    coolItem.setMinimumSize(coolSize);
	    //coolItem.setPreferredSize(coolSize);
	    coolItem.setSize(coolSize);
    }
    
    public void createMenu(Shell shell) {
        this.menu = new Menu(shell, SWT.BAR);

        ItemContainer fileItem = new FileMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer layoutItems = new LayoutMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer compositionItem = new CompositionMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer trackItem = new TrackMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer measureItem = new MeasureMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer durationItem = new DurationMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer effectsItem = new NoteEffectsMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer markerItem = new MarkerMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer playItem = new PlayMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor);
        ItemContainer languageItems = new LanguageMenuItem(shell,this.menu, SWT.CASCADE);
        ItemContainer settingItems = new SettingsMenuItem(shell,this.menu, SWT.CASCADE);        
        ItemContainer pluginItems = new PluginMenuItem(shell,this.menu, SWT.CASCADE); 
        ItemContainer helpItem = new HelpMenuItem(shell,this.menu, SWT.CASCADE);        
        
        fileItem.showItems();
        layoutItems.showItems();
        compositionItem.showItems();        
        trackItem.showItems();
        measureItem.showItems();
        durationItem.showItems();
        effectsItem.showItems();
        markerItem.showItems();
        playItem.showItems();
        languageItems.showItems();
        settingItems.showItems();        
        pluginItems.showItems();
        helpItem.showItems();
        
        shell.setMenuBar(this.menu);
        
        this.items.add(fileItem);
        this.items.add(layoutItems);
        this.items.add(compositionItem);
        this.items.add(trackItem);
        this.items.add(measureItem);
        this.items.add(durationItem);
        this.items.add(effectsItem); 
        this.items.add(markerItem); 
        this.items.add(playItem);  
        this.items.add(languageItems);
        this.items.add(settingItems);
        this.items.add(helpItem); 
        this.items.add(pluginItems); 
    }    
    
    public void createPopupMenu(Shell shell) {
        this.popupMenu = new Menu(shell, SWT.POP_UP);

        ItemContainer compositionItem = new CompositionMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor);
        ItemContainer trackItem = new TrackMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor);
        ItemContainer measureItem = new MeasureMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor);
        ItemContainer durationItem = new DurationMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor);
        ItemContainer effectsItem = new NoteEffectsMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor);
        ItemContainer markerItem = new MarkerMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor);

        compositionItem.showItems();        
        trackItem.showItems();
        measureItem.showItems();
        durationItem.showItems();
        effectsItem.showItems();
        markerItem.showItems();

        this.items.add(compositionItem);
        this.items.add(trackItem);
        this.items.add(measureItem);
        this.items.add(durationItem);
        this.items.add(effectsItem); 
        this.items.add(markerItem);         
    }        
    
    public void updateItems(){
        if(!this.menu.isDisposed() && !this.popupMenu.isDisposed() && !this.coolBar.isDisposed()){
            Iterator it = this.items.iterator();
            while(it.hasNext()){
                ItemContainer item = (ItemContainer)it.next();
                item.update();            
            }
        }
    }
    
    public void loadProperties(){
        if(!this.menu.isDisposed() && !this.popupMenu.isDisposed() && !this.coolBar.isDisposed()){
            Iterator it = this.items.iterator();
            while(it.hasNext()){
                ItemContainer item = (ItemContainer)it.next();
                item.loadProperties();            
            }
        }        
    }
    
    
    public CoolBar getCoolbar(){
    	return this.coolBar;
    }
    
    public Menu getPopupMenu(){
    	return this.popupMenu;
    }
}

