/*
 * Created on 08-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class FileHistory {
	private static final int PATH_LIMIT = TuxGuitar.instance().getConfig().getIntConfigValue(PropertyNames.MAX_HISTORY_FILES);
	private boolean pathChanges;
	private boolean isNewFile;
	private String lastPath;	
	private List paths;

    public FileHistory(){
    	this.clearFile();
    	this.loadHistory();
    }
    	
	public void clearFile() {
		this.lastPath = "Untitled.gp4";
		this.isNewFile = true;
	}           
    
	public String getFileName() {
		return new File(lastPath).getName();
	}

	public String getFilePath() {
		return new File(lastPath).getParent(); 
	}

	public boolean isNewFile(){
		return isNewFile;
	}
	
	public void setFile(String fileName) {
		this.lastPath = fileName;
		this.isNewFile = false;
		this.addPath(fileName);
	}	

    public void addPath(String path){
    	if(path != null && path.length() > 0){
    		removePath(path);
    		paths.add(0,path);    		
       		checkLimit();
       		saveHistory();
       		setPathChanges(true);
    	}
    }
    
    public List getPaths(){
    	return this.paths;
    }

    private void checkLimit(){
    	while(paths.size() > PATH_LIMIT){
    		paths.remove(paths.size() - 1);	
    	}
    }
 
    private void removePath(String path){    	    	
    	for(int i = 0; i < paths.size(); i++){
    		String old = (String)paths.get(i);
    		if(old.equals(path)){
    			paths.remove(i);
    			break;
    		}
    	}
    }
    

    public boolean hasPathChanges() {
		return pathChanges;
	}

	public void setPathChanges(boolean pathChanges) {
		this.pathChanges = pathChanges;
	}

	public void loadHistory() {       
        try {              
        	this.paths = new ArrayList();
        	if(new File(getHistoryFileName()).exists()){        	
        		InputStream inputStream = new FileInputStream(getHistoryFileName());                        
        		Properties properties = new Properties();
        		properties.load(inputStream);
        		
        		int count = Integer.parseInt((String)properties.get("history.count"));
        		for(int i = 0; i < count;i ++){
        			String path = (String)properties.get("history." + i);
        			if(PATH_LIMIT > i && path != null && path.length() > 0){
        				paths.add((String)properties.get("history." + i));
        			}
        		}
        		setPathChanges(true);
        	}else{
        		this.saveHistory();
        	}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void saveHistory(){
        try {
        	Properties properties = new Properties();
        	
        	int count = paths.size();
        	for(int i = 0;i < count;i ++){
        		properties.put("history." + i,paths.get(i));	
        	}
        	properties.put("history.count",Integer.toString(count));

        	properties.store(new FileOutputStream(getHistoryFileName()),"History Files");
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
    }
    
    private String getHistoryFileName(){
    	return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "history.properties";
    }
}
