/*
 * Created on 09-ene-2006
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SystemConfigManager {
    private Properties properties;  
    
    public SystemConfigManager() {
    	this.properties = new Properties(new Defaults().getProperties());
    }

    public void init(){    	
    	this.load();
    }
    
    private String getProperty(String key) {      
        return this.properties.getProperty(key);    
    }    

    public String getStringConfigValue(String key) {
    	String property = getProperty(key); 
        return (property == null)?null:property.trim();
    }
    
    public int getIntConfigValue(String key) {
        String value = getProperty(key);        
        return (value == null)?0:Integer.parseInt(value.trim());
    }   
    
    public boolean getBooleanConfigValue(String key) {
        String value = getProperty(key);
        return (value == null)?false:Boolean.valueOf(value.trim()).booleanValue();
    }   

    public FontData getFontDataConfigValue(String key){
    	String value = getProperty(key);
    	if(value != null){
    		String[] values = value.trim().split(",");
    		if(values != null && values.length == 3){
    			try{
    				String name = values[0].trim();
    				int size = Integer.parseInt(values[1].trim());
    				int style = Integer.parseInt(values[2].trim());
    	
    				return new FontData(name,size,style);
    			}catch(NumberFormatException e){}    		
    		}
    	}
    	return null;
    }
    
    public RGB getRGBConfigValue(String key){
    	String value = getProperty(key);
    	if(value != null){
    		String[] values = value.trim().split(",");
    		if(values != null && values.length == 3){
    			try{
    				int red = Integer.parseInt(values[0].trim());
    				int green = Integer.parseInt(values[1].trim());
    				int blue = Integer.parseInt(values[2].trim());
    	
    				return new RGB(red,green,blue);
    			}catch(NumberFormatException e){}    		
    		}
    	}
    	return null;
    }    
    
    public void setProperty(String key,String value){
        this.properties.setProperty(key,value);
    }
    
    public void setProperty(String key,int value){
        setProperty(key,Integer.toString(value));
    }
    
    public void setProperty(String key,boolean value){
        setProperty(key,Boolean.toString(value));
    }
    
    
    public void removeProperty(String key){
        this.properties.remove(key);
    }
    
    public void clear(){
        this.properties.clear();
    }
    
    public void load() {       
        try {                    
        	if(new File(getFileName()).exists()){        	
        		InputStream inputStream = new FileInputStream(getFileName());                        
        		this.properties.clear();
        		this.properties.load(inputStream);
        	}else{
        		this.save();
        	}
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void save(){
        try {
            properties.store(new FileOutputStream(getFileName()),"System Configuration");
        } catch (FileNotFoundException e1) {
            e1.printStackTrace();
        } catch (IOException e1) {
            e1.printStackTrace();
        }
    }
    
    private String getFileName(){
    	return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "config.properties";
    }

}