/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.track;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.sound.midi.Instrument;
import javax.sound.midi.Soundbank;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.undo.undoables.JoinedUndoable;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInfoTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableInstrumentTrack;
import org.herac.tuxguitar.gui.undo.undoables.track.UndoableTrackGeneric;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.RGBColor;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeTrackPropertiesAction extends Action {
    public static final String NAME = "CHANGE_TRACK_PROPERTIES";
	private static final int MINIMUN_WIDTH = 200;
	private static final int MINIMUN_HEIGHT = 10;	    
    private static final int MAX_STRINGS = 7;
    private static final int MIN_STRINGS = 4;
    private static final int MAX_OCTAVES = 10;
    private static final int MAX_NOTES = 12;
    private Shell dialog;
    private Text nameText;
    private RGBColor trackColor;
    private List tempStrings;
    private TunningSpinner[] stringSpinners = new TunningSpinner[MAX_STRINGS];
    private Spinner stringCountSpinner;
    private Combo offsetCombo;
    private int stringCount;
    private Combo instrumentCombo;
    private Button percussionCheckBox;
    
    public ChangeTrackPropertiesAction(TablatureEditor tablatureEditor) {
        super(NAME,true, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    public void showDialog(Shell shell) {
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        if (trackCoords != null) {
            this.stringCount = trackCoords.getTrack().getStrings().size();
            this.trackColor = (RGBColor) trackCoords.getTrack().getColor().clone();
            this.initTempStirngs(trackCoords.getTrack().getStrings());

            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
            this.dialog.setLayout(new GridLayout());
            this.dialog.setText(TuxGuitar.getProperty("track.properties"));
            
    		TabFolder tabFolder = new TabFolder(dialog, SWT.NONE);
    		tabFolder.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));  
    		tabFolder.setLayout(new FormLayout());
            
            Composite control = null;
            //GENERAL
            control = makeTabItem(tabFolder,TuxGuitar.getProperty("track.properties.general"));
            initTrackInfo(control, trackCoords);

            //TUNNING
            control = makeTabItem(tabFolder,TuxGuitar.getProperty("tunning"));
            initTunningInfo(control, trackCoords);

            //INSTRUMENT
            control = makeTabItem(tabFolder,TuxGuitar.getProperty("instrument.instrument"));
            initInstrumentFields(control, trackCoords);

            //BUTTONS
            initButtons(dialog);

            tabFolder.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    e.doit = false;
                }
            });

            
            updateTunningSpinner(!trackCoords.getTrack().isPercussionTrack());
            
            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
                        
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
        }
    }

	private Composite makeTabItem(TabFolder tabFolder,String itemName){		
        Composite control = new Composite(tabFolder, SWT.NONE);
        control.setLayout(new GridLayout());
        TabItem tabItem = new TabItem(tabFolder, SWT.NONE);
        tabItem.setText(itemName);
        tabItem.setControl(control);		        
        return control;
	}    
    
    private void initTrackInfo(Composite parent,SongTrackCoords trackCoords) {
    	Composite composite = new Composite(parent,SWT.NONE);
    	composite.setLayout(new GridLayout(2,false));
    	composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
    	
        Label nameLabel = new Label(composite, SWT.NONE);
        nameLabel.setLayoutData(new GridData(100, 15));
        nameLabel.setText(TuxGuitar.getProperty("track.name"));

        this.nameText = new Text(composite, SWT.BORDER);
        nameText.setLayoutData(new GridData(250, 15));
        nameText.setText(trackCoords.getTrack().getName());

        Label colorLabel = new Label(composite, SWT.NONE);
        colorLabel.setText(TuxGuitar.getProperty("track.color"));

        final Button colorButton = new Button(composite, SWT.PUSH);
        setButtonColor(colorButton, new Color(dialog.getDisplay(), this.trackColor.getR(), this.trackColor.getG(), this.trackColor.getB()));

        colorButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(dialog);

                dlg.setRGB(dialog.getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                dlg.setText(TuxGuitar.getProperty("choose-color"));
                RGB rgb = dlg.open();
                if (rgb != null) {
                    setButtonColor(colorButton, new Color(dialog.getDisplay(), rgb));
                }
            }
        });

    }

    private void setButtonColor(Button button, Color color) {
        Image image = new Image(dialog.getDisplay(), 25, 25);
        GC gc = new GC(image);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, 25, 25);        
        gc.dispose();
        button.setImage(image);
        this.trackColor.setR(color.getRed());
        this.trackColor.setG(color.getGreen());
        this.trackColor.setB(color.getBlue());
    }
    
    private void initTunningInfo(Composite parent,SongTrackCoords trackCoords) {
    	Composite composite = new Composite(parent,SWT.NONE);
    	composite.setLayout(new GridLayout());
    	composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
    	
        initTunningData(composite,trackCoords);
        initTunningSpinners(composite);    	
    }

    private void initTunningSpinners(Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(MAX_STRINGS, false));
        composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        String[] tunningTexts = getAllValueNames();
        for (int i = 0; i < MAX_STRINGS; i++) {
            this.stringSpinners[i] = new TunningSpinner(composite, SWT.NONE);
            this.stringSpinners[i].setTexts(tunningTexts);
        }
    }

    private void initTunningData(Composite parent,SongTrackCoords trackCoords) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(4, true));    	
        composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));
        
        Label stringCountLabel = new Label(composite, SWT.NONE);
        stringCountLabel.setText(TuxGuitar.getProperty("tunning.strings"));

        this.stringCountSpinner = new Spinner(composite, SWT.BORDER);
        GridData data = new GridData();
        data.widthHint = 30;
        stringCountSpinner.setLayoutData(data);

        stringCountSpinner.setMinimum(MIN_STRINGS);
        stringCountSpinner.setMaximum(MAX_STRINGS);
        stringCountSpinner.setSelection(this.stringCount);
        stringCountSpinner.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                stringCount = stringCountSpinner.getSelection();
                setDefaultTunning();
                updateTunningSpinner(!percussionCheckBox.getSelection());
            }
        });

        
        Label offsetLabel = new Label(composite, SWT.NONE);
        offsetLabel.setText(TuxGuitar.getProperty("tunning.offset"));

        offsetCombo = new Combo(composite, SWT.DROP_DOWN);
        for(int i = SongTrack.MIN_OFFSET;i <= SongTrack.MAX_OFFSET;i ++){
        	offsetCombo.add(Integer.toString(i));
        	if(i == trackCoords.getTrack().getOffset()){
        		offsetCombo.select(i - SongTrack.MIN_OFFSET);
        	}
        }               
    }

    private void initButtons(final Composite parent) {
        Composite composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new GridLayout(2,false));
        composite.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));    	
        
        GridData data = new GridData(SWT.FILL,SWT.FILL,true,true);    
        data.minimumWidth = 80;
        data.minimumHeight = 25;
        
        Button buttonOK = new Button(composite, SWT.PUSH);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setLayoutData(data);
        buttonOK.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                updateTrackProperties();
                //--------------update and redraw------------------------------------------------------
                new SyncThread(new Runnable() {
                    public void run() {
                        if(!TuxGuitar.isDisposed()){
                        	updateTablature();
                        	TuxGuitar.instance().getMixer().update();
                        	redraw();                        
                        	dialog.dispose();
                        }
                    }
                }).start();
            }
        });

        Button buttonCancel = new Button(composite, SWT.PUSH);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.setLayoutData(data);
        buttonCancel.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent arg0) {
                dialog.dispose();
            }
        });

    }

    private void initInstrumentFields(Composite parent,SongTrackCoords trackCoords) {
    	Composite composite = new Composite(parent,SWT.NONE);
    	composite.setLayout(new GridLayout(2,true));
    	composite.setLayoutData(new GridData(SWT.FILL,SWT.FILL,true,true));    	
    	
        Instrument[] instruments = getInstruments();

        final SongTrack track = trackCoords.getTrack();
        //------------Instrument Combo-------------------------------------
        Label instrumentLabel = new Label(composite, SWT.DROP_DOWN);
        instrumentLabel.setText(TuxGuitar.getProperty("instrument.instrument"));
        this.instrumentCombo = new Combo(composite, SWT.NULL);
        if (instruments != null) {
            int count = instruments.length;
            if (count > 128) {
                count = 128;
            }
            for (int i = 0; i < count; i++) {
                instruments[i].getName();
                instrumentCombo.add(instruments[i].getName());
            }
            instrumentCombo.setText(instruments[track.getChannel().getInstrument()].getName());
            instrumentCombo.setEnabled(!track.isPercussionTrack());
        } else {
            instrumentCombo.setEnabled(false);
        }

        //--------------------Precusion CheckBox-------------------------------
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.percussionCheckBox = new Button(composite, SWT.CHECK);
        percussionCheckBox.setText(TuxGuitar.getProperty("instrument.percussion-track"));
        percussionCheckBox.setLayoutData(gridData);
        if (instruments != null) {
            percussionCheckBox.setSelection(track.isPercussionTrack());
            percussionCheckBox.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    instrumentCombo.setEnabled(!percussionCheckBox.getSelection());
                    
                    setDefaultTunning();
                    updateTunningSpinner(!percussionCheckBox.getSelection());                                            
                }
            });
        } else {
            percussionCheckBox.setEnabled(false);
        }
        //-----------------------------------------------------------
    }

    private Instrument[] getInstruments() {
        Instrument[] instruments = null;
        Soundbank sb = getEditor().getSongManager().getPlayer().getSoundbank();
        if (sb != null) {
            instruments = sb.getInstruments();
        }
        return instruments;
    }

    private void updateTrackProperties() {
        SongTrackCoords trackCoords = getEditor().getTablature().getCaret().getSongTrackCoords();
        
        String trackName = this.nameText.getText();
        RGBColor trakColor = this.trackColor;
        
        int stringNumber = 1;
        List strings = new ArrayList();
        for (int i = stringCount - 1; i >= 0; i--) {
            strings.add(new InstrumentString(stringNumber, stringSpinners[i].getSelection()));
            stringNumber++;
        }
        int offset = SongTrack.MIN_OFFSET + offsetCombo.getSelectionIndex();
        int instrument = instrumentCombo.getSelectionIndex();
        boolean percussion = percussionCheckBox.getSelection();
        
        boolean infoChanges = hasInfoChanges(trackCoords,trackName,trackColor,offset);
        boolean tunningChanges = hasTunningChanges(trackCoords,strings);
        boolean instrumentChanges = hasInstrumentChanges(trackCoords,instrument,percussion);
        
        if(infoChanges || tunningChanges || instrumentChanges){
        	JoinedUndoable undoable = new JoinedUndoable();
        	
        	UndoableTrackGeneric undoableGeneric = null;
        	if(tunningChanges){
        		undoableGeneric = UndoableTrackGeneric.startUndo(trackCoords.getTrack());
        	}
        	
        	//--------------------------------------info---------------------------------------
        	if(infoChanges){
        		UndoableInfoTrack undoableInfo = null;
        		if(!tunningChanges){
        			undoableInfo = UndoableInfoTrack.startUndo(trackCoords.getTrack());
        		}
        		getEditor().getSongManager().getTrackManager().changeInfo(trackCoords.getTrack(),trackName,trackColor,offset);
        		if(!tunningChanges){
        			undoable.addUndoableEdit(undoableInfo.endUndo(trackCoords.getTrack()));
        		}
        	}
        	//--------------------------------------tunning---------------------------------------
        	if(tunningChanges){
        		getEditor().getSongManager().getTrackManager().changeInstrumentStrings(trackCoords.getTrack(),strings);
        	}
        	//-----------------------------instrument----------------------------------------------        
        	if(instrumentChanges){
        		UndoableInstrumentTrack undoableInstrument = null;
        		if(!tunningChanges){
        			undoableInstrument = UndoableInstrumentTrack.startUndo(trackCoords.getTrack());
        		}        	
        		getEditor().getSongManager().getTrackManager().changeInstrument(trackCoords.getTrack(),instrument,percussion);
        		if(!tunningChanges){
        			undoable.addUndoableEdit(undoableInstrument.endUndo(trackCoords.getTrack()));
        		}
        	}
        	if(tunningChanges){
        		undoable.addUndoableEdit(undoableGeneric.endUndo(trackCoords.getTrack()));
        	}
        	
        	getEditor().getUndoManager().addEdit(undoable.endUndo());
        }
    }
    
    private boolean hasInfoChanges(SongTrackCoords trackCoords,String name,RGBColor color,int offset){
    	if(!name.equals(trackCoords.getTrack().getName())){
    		return true;
    	}
    	if(!color.isEqual(trackCoords.getTrack().getColor())){
    		return true;
    	}    	
    	if(offset != trackCoords.getTrack().getOffset()){
    		return true;
    	}
    	return false;
    }
    
    private boolean hasTunningChanges(SongTrackCoords trackCoords,List newStrings){
    	List oldStrings = trackCoords.getTrack().getStrings();    	
    	//check the number of strings
    	if(oldStrings.size() != newStrings.size()){
    		return true;
    	}    	
    	//check the tunning of strings
    	for(int i = 0;i < oldStrings.size();i++){    		    		
    		InstrumentString oldString = (InstrumentString)oldStrings.get(i);
    		boolean stringExists = false;    	
    		for(int j = 0;j < newStrings.size();j++){
    			InstrumentString newString = (InstrumentString)newStrings.get(j);
    			if(newString.isEqual(oldString)){
    				stringExists = true;
    			}
    		}    		
    		if(!stringExists){
    			return true;
    		}
    	}
    	return false;
    }
    
    private boolean hasInstrumentChanges(SongTrackCoords trackCoords,int instrument,boolean percussion){
    	if(instrument < 0){
    		return false;
    	}
    	if(trackCoords.getTrack().getChannel().getInstrument() != instrument){
    		return true;
    	}
    	if(trackCoords.getTrack().isPercussionTrack() != percussion){
    		return true;
    	}
    	return false;
    }
    
    private void updateTunningSpinner(boolean enabled) {        
        int spinnerIndex = tempStrings.size() - 1;
        Iterator it = tempStrings.iterator();
        while (it.hasNext()) {
            InstrumentString string = (InstrumentString) it.next();
            stringSpinners[spinnerIndex].setSelection(string.getValue());
            stringSpinners[spinnerIndex].setVisible(true);
            stringSpinners[spinnerIndex].setEnabled(enabled);
            spinnerIndex--;
        }
        for (int i = tempStrings.size(); i < MAX_STRINGS; i++) {
            stringSpinners[i].setSelection(0);
            stringSpinners[i].setVisible(false);
        }
    }

    private void initTempStirngs(List realStrings) {
        this.tempStrings = new ArrayList();
        for (int i = 0; i < realStrings.size(); i++) {
            InstrumentString realString = (InstrumentString) realStrings.get(i);
            tempStrings.add(realString.clone());
        }
    }

    private void setDefaultTunning() {
        this.tempStrings.clear();

        if (percussionCheckBox.getSelection()) {
            for (int i = 1; i <= stringCount; i++) {
                this.tempStrings.add(new InstrumentString(i, 0));
            }

        } else {
            switch (stringCount) {
            case 7:
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                this.tempStrings.add(new InstrumentString(7, 35));
                break;
            case 6:
                this.tempStrings.add(new InstrumentString(1, 64));
                this.tempStrings.add(new InstrumentString(2, 59));
                this.tempStrings.add(new InstrumentString(3, 55));
                this.tempStrings.add(new InstrumentString(4, 50));
                this.tempStrings.add(new InstrumentString(5, 45));
                this.tempStrings.add(new InstrumentString(6, 40));
                break;
            case 5:
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                this.tempStrings.add(new InstrumentString(5, 23));
                break;
            case 4:
                this.tempStrings.add(new InstrumentString(1, 43));
                this.tempStrings.add(new InstrumentString(2, 38));
                this.tempStrings.add(new InstrumentString(3, 33));
                this.tempStrings.add(new InstrumentString(4, 28));
                break;
            }
        }
    }

    private String[] getAllValueNames() {
        String[] valueNames = new String[MAX_NOTES * MAX_OCTAVES];
        for (int i = 0; i < valueNames.length; i++) {
            valueNames[i] = getValueName(i);
        }

        return valueNames;
    }

    private String getValueName(int value) {
        String name = null;
        int octave = (value / MAX_NOTES);
        value = value - (octave * MAX_NOTES);
        switch (value) {
        case 0:
            name = "C";
            break;
        case 1:
            name = "C#";
            break;
        case 2:
            name = "D";
            break;
        case 3:
            name = "D#";
            break;
        case 4:
            name = "E";
            break;
        case 5:
            name = "F";
            break;
        case 6:
            name = "F#";
            break;
        case 7:
            name = "G";
            break;
        case 8:
            name = "G#";
            break;
        case 9:
            name = "A";
            break;
        case 10:
            name = "Bb";
            break;
        case 11:
            name = "B";
            break;
        }
        return name + octave;
    }

    private class TunningSpinner extends Composite {
        private Text text;
        private Composite buttonComposite;
        private Button upButton;
        private Button downButton;
        private String[] texts;
        private int maxSelection;
        private int minSelection;
        private int selection;

        public TunningSpinner(Composite parent, int style) {
            super(parent, style);
            this.setLayout(createLayout(2));
            this.init();
        }

        private void init() {
            this.text = new Text(this, SWT.BORDER);
            this.text.setLayoutData(new GridData(30, 22));
            this.buttonComposite = new Composite(this, SWT.NONE);
            this.buttonComposite.setLayout(createLayout(1));
            this.upButton = new Button(buttonComposite, SWT.ARROW | SWT.UP);
            this.upButton.setLayoutData(new GridData(15, 15));
            this.downButton = new Button(buttonComposite, SWT.ARROW | SWT.DOWN);
            this.downButton.setLayoutData(new GridData(15, 15));
            this.selection = 0;
            this.minSelection = 0;
            this.maxSelection = 0;

            this.text.setEditable(false);

            this.upButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    setSelection(selection + 1);
                }
            });

            this.downButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    setSelection(selection - 1);
                }
            });
        }

        private Layout createLayout(int numColumns) {
            GridLayout layout = new GridLayout(numColumns, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            return layout;
        }

        public void setTexts(String[] texts) {
            this.texts = texts;
            this.minSelection = 0;
            this.maxSelection = texts.length - 1;
        }

        public int getSelection() {
            return selection;
        }

        public void setSelection(int selection) {
            if (selection >= minSelection && selection <= maxSelection) {
                this.selection = selection;
                if (texts != null) {
                    this.text.setText(texts[selection]);
                }
            }
        }
        
        public void setEnabled(boolean enabled){
            super.setEnabled(enabled);
            this.text.setEnabled(enabled);
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }

    private class ChannelList{
    	private List channelIndexs;
    	
    	public ChannelList(){    
    		this.channelIndexs = new ArrayList();
    	}
    	
    	public void addChannel(int index,int channel){
    		this.channelIndexs.add(new ChannelIndex(index,channel));
    	}
    	
    	public int getChannel(int index){
    		Iterator it = this.channelIndexs.iterator();
    		while (it.hasNext()) {
				ChannelIndex channelIndex = (ChannelIndex) it.next();
				if(index == channelIndex.getIndex()){
					return channelIndex.getChannel();
				}
			}
    		return -1;
    	}
    	
    	public void clear(){
    		this.channelIndexs.clear();
    	}
    }
    
    private class ChannelIndex{
    	private int index;
    	private int channel;
    	
    	public ChannelIndex(int index,int channel){
    		this.index = index;
    		this.channel = channel;
    	}

		public int getChannel() {
			return channel;
		}

		public int getIndex() {
			return index;
		}
    	    	
    }
}