/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.settings;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.config.PropertyNames;
import org.herac.tuxguitar.gui.config.SystemConfigManager;
import org.herac.tuxguitar.gui.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class EditConfigAction extends Action{
    public static final String NAME = "EDIT_CONFIG";
    private SystemConfigManager config;
    private Shell dialog;
    private Option options[];
    
    public EditConfigAction(TablatureEditor tablatureEditor) {
        super(NAME,tablatureEditor);  
        this.config = TuxGuitar.instance().getConfig();
    }

    public boolean doAction(TypedEvent e) {
        showDialog(getEditor().getTablature().getShell());
        return true;
    }

    
    
    public void showDialog(Shell shell) {
            this.dialog = new Shell(shell, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);           

            dialog.setLayout(new GridLayout());
            dialog.setText(TuxGuitar.getProperty("settings.config"));

            //-------main-------------------------------------         
            Composite mainComposite = new Composite(dialog,SWT.NONE);
            mainComposite.setLayout(new GridLayout(2,false));
            createComposites(mainComposite);
            
            //-------buttons-------------------------------------

            Composite buttonComposite = new Composite(dialog,SWT.NONE);
            buttonComposite.setLayout(new GridLayout(2,true));
            buttonComposite.setLayoutData(new GridData(SWT.END,SWT.FILL,true,true));                          
            
            final Button buttonOK = new Button(buttonComposite, SWT.PUSH);
            buttonOK.setLayoutData(makeGridData(80,25)); 
            buttonOK.setText(TuxGuitar.getProperty("ok"));             
            buttonOK.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {   
                    updateOptions();                    
                    if(new ConfirmDialog(dialog,TuxGuitar.getProperty("settings.config.apply-changes-question")).confirm()){
                    	TuxGuitar.instance().reloadConfig();
                    	TuxGuitar.instance().fireUpdate();
                    	TuxGuitar.instance().redraw();
                    }
                    dialog.dispose();
                }
            });

            Button buttonCancel = new Button(buttonComposite, SWT.PUSH);
            buttonCancel.setLayoutData(makeGridData(80,25)); 
            buttonCancel.setText(TuxGuitar.getProperty("cancel"));
            buttonCancel.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent arg0) {
                    dialog.dispose();
                }
            });

            dialog.pack();
            dialog.open();

            int x = shell.getBounds().x + (shell.getBounds().width - dialog.getSize().x) / 2;
            int y = shell.getBounds().y + (shell.getBounds().height - dialog.getSize().y) / 2;
            dialog.setLocation(x, y);
        
    		while (!dialog.isDisposed()) {
                if (!dialog.getDisplay().readAndDispatch()) {
                	dialog.getDisplay().sleep();
                }
            }
    }
    
    
    
    
    
    
    
	private void createComposites(Composite parent) {	    
		ToolBar toolBar = new ToolBar(parent, SWT.VERTICAL | SWT.BORDER);
		toolBar.setLayoutData(makeGridData(60,350));
			
	    Composite option = new Composite(parent,SWT.NONE);	
	    option.setLayout(new FormLayout());
	    option.setLayoutData(makeGridData(250,350));
	    
	    initOptions(toolBar,option);		

		select(options[0]);
	}
	
	protected GridData makeGridData(int minWith,int minHeight){
		return makeGridData(0,0,minWith,minHeight);
	}
	
	protected GridData makeGridData(int with,int height,int minWith,int minHeight){   
    	GridData data = new GridData();    	
    	data.minimumWidth = minWith;
    	data.minimumHeight = minHeight;
    	if(with > 0){
    		data.widthHint = with;
    	}else{
    		data.horizontalAlignment = SWT.FILL;
    		data.grabExcessHorizontalSpace = true;
    	}
    	if(height > 0){
    		data.heightHint = with;
    	}else{
    		data.verticalAlignment = SWT.FILL;
    		data.grabExcessVerticalSpace = true;
    	}
    	
    	return data;
	}
	
	private void initOptions(ToolBar toolBar,Composite parent){
	    this.options = new Option[4];
	    this.options[0] = new ViewOption(this.config,toolBar,parent);
	    this.options[1] = new StylesOption(this.config,toolBar,parent);
	    this.options[2] = new SoundOption(this.config,toolBar,parent);
	    this.options[3] = new LanguageOption(this.config,toolBar,parent);

		for(int i = 0;i < this.options.length;i++){
			this.options[i].createOption();		   
		}
	}

    private void select(Option option){
        hideAll();
        option.setVisible(true);
        dialog.layout();
    }
    
    private void hideAll(){
        for(int i = 0;i < this.options.length;i++){
            this.options[i].setVisible(false);
            this.options[i].setVisible(false);
        }
    }

    private void updateOptions(){        
        this.config.clear();
        for(int i = 0;i < this.options.length;i++){
            this.options[i].updateConfig();
        }
        this.config.save();
    }

    
    private abstract class Option extends SelectionAdapter{ 
        private SystemConfigManager config;
        private ToolBar toolBar;
        private Composite parent;
        private Group group;
        private Composite composite;
        private ToolItem toolItem;
        
        public Option(SystemConfigManager config,ToolBar toolBar,final Composite parent,String text){
            this.config = config;
            this.toolBar = toolBar;
            this.parent = parent;
            this.toolItem = new ToolItem(toolBar, SWT.RADIO);
            this.group = new Group(parent, SWT.SHADOW_ETCHED_IN);
            this.group.setLayout(new GridLayout());
            this.group.setLayoutData(getGroupData());
            this.group.setText(text);
            this.composite = new Composite(this.group, SWT.SHADOW_ETCHED_IN);   
            this.composite.setLayout(new GridLayout());
        }
        
        public abstract void createOption();   
        
        public abstract void updateConfig();       
        
        public void setVisible(boolean visible){
            this.toolItem.setSelection(visible);
            this.group.setVisible(visible);            
        }
        
        protected FormData getGroupData(){
            FormData data = new FormData();
            data.top = new FormAttachment(0,0);
            data.bottom = new FormAttachment(100,0);
            data.left = new FormAttachment(0,0);
            data.right = new FormAttachment(100,0);
            return data;
        }                 
        

        protected GridData getTabbedData(){           
        	return getTabbedData(20);
        }
        
        protected GridData getTabbedData(int indent){   
        	GridData data = new GridData();
        	data.horizontalAlignment = SWT.FILL;
        	data.grabExcessHorizontalSpace = true;
        	data.horizontalIndent = indent;
		
        	return data;
        }
        
	    public void widgetSelected(SelectionEvent e) {
	        select(this);
	    }        	
	    
	    public SystemConfigManager getConfig(){
	        return this.config;
	    }
	    
	    public Composite getComposite(){	        
	        return this.composite;
	    }
	    
	    public ToolItem getToolItem(){
	        return this.toolItem;
	    }
    }
    
    private class ViewOption extends Option{
        private static final int MIN_WIDHT = 640;
        private static final int MIN_HEIGHT = 480;
        
        private Button mixer;
        private Button transport;
        private Button fretBoard;
        private Button maximized;
        private Button multitrack;
        private Button scoreEnabled;
        private Button[] layoutModes;
        private Spinner width;
        private Spinner height;
        public ViewOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent,TuxGuitar.getProperty("settings.config.view"));            
        }        

        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.view"));	
    		getToolItem().setImage(SystemImages.OPTION_VIEW);
    		getToolItem().addSelectionListener(this);

    		Label title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.view.mode"));
    		
    		this.mixer = new Button(getComposite(),SWT.CHECK);
    		this.mixer.setText(TuxGuitar.getProperty("show-mixer"));
    		this.mixer.setLayoutData(getTabbedData());
    		this.mixer.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MIXER));
    		
    		this.transport = new Button(getComposite(),SWT.CHECK);
    		this.transport.setText(TuxGuitar.getProperty("show-transport"));
    		this.transport.setLayoutData(getTabbedData());
    		this.transport.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_TRANSPORT));    		
    		
    		this.fretBoard = new Button(getComposite(),SWT.CHECK);
    		this.fretBoard.setText(TuxGuitar.getProperty("show-fretboard"));
    		this.fretBoard.setLayoutData(getTabbedData());
    		this.fretBoard.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_FRETBOARD));

    		this.scoreEnabled = new Button(getComposite(),SWT.CHECK);
    		this.scoreEnabled.setText(TuxGuitar.getProperty("layout.score-enabled"));
    		this.scoreEnabled.setLayoutData(getTabbedData());
    		this.scoreEnabled.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_SCORE));    		
    		
    		this.multitrack = new Button(getComposite(),SWT.CHECK);
    		this.multitrack.setText(TuxGuitar.getProperty("layout.multitrack"));
    		this.multitrack.setLayoutData(getTabbedData());
    		this.multitrack.setSelection(getConfig().getBooleanConfigValue(PropertyNames.SHOW_MULTITRACK));    		    	
    		
    		this.layoutModes = new Button[2];		
    		this.layoutModes[0] = new Button(getComposite(),SWT.RADIO); 
    		this.layoutModes[0].setText(TuxGuitar.getProperty("layout.page"));	
    		this.layoutModes[0].setLayoutData(getTabbedData());
    		this.layoutModes[1] = new Button(getComposite(),SWT.RADIO); 
    		this.layoutModes[1].setText(TuxGuitar.getProperty("layout.linear"));
    		this.layoutModes[1].setLayoutData(getTabbedData());
    		int currentMode = getConfig().getIntConfigValue(PropertyNames.LAYOUT_MODE);
    		switch(currentMode){
    			case ViewLayout.MODE_PAGE:
    			    this.layoutModes[0].setSelection(true);
    			    break;
    			case ViewLayout.MODE_LINEAR:
    			    this.layoutModes[1].setSelection(true);
    			    break;    			
    		}

    		
    		title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.view.size"));
    		
    		this.maximized = new Button(getComposite(),SWT.CHECK);
    		this.maximized.setText(TuxGuitar.getProperty("settings.config.view.size.maximized"));
    		this.maximized.setLayoutData(getTabbedData());
    		this.maximized.setSelection(getConfig().getBooleanConfigValue(PropertyNames.MAXIMIZED));    		
    		
    		Composite size = new Composite(getComposite(),SWT.NONE);
    		size.setLayout(new GridLayout(2,true));
    		
    		Label widthLabel = new Label(size,SWT.NONE);
    		widthLabel.setText(TuxGuitar.getProperty("settings.config.view.size.width"));
    		
            widthLabel.setLayoutData(getTabbedData());
            
    		this.width = new Spinner(size, SWT.BORDER);    		
    		this.width.setMinimum(MIN_WIDHT);
    		this.width.setMaximum(getEditor().getTablature().getDisplay().getBounds().width);
    		this.width.setSelection(getConfig().getIntConfigValue(PropertyNames.WIDTH));  
            
            this.width.setLayoutData(getTabbedData());
    		
    		
            
            
    		Label heightLabel = new Label(size,SWT.NONE);
    		heightLabel.setText(TuxGuitar.getProperty("settings.config.view.size.height"));
    		
            heightLabel.setLayoutData(getTabbedData());
            
    		this.height = new Spinner(size, SWT.BORDER);
    		this.height.setMinimum(MIN_HEIGHT);
    		this.height.setMaximum(getEditor().getTablature().getDisplay().getBounds().height);
    		this.height.setSelection(getConfig().getIntConfigValue(PropertyNames.HEIGHT));      		

            this.height.setLayoutData(getTabbedData());

            width.setEnabled(!maximized.getSelection());
            height.setEnabled(!maximized.getSelection());
    		this.maximized.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    width.setEnabled(!maximized.getSelection());
                    height.setEnabled(!maximized.getSelection());
                }
            });
    		
    		
    		
        }                  
    
        
        public void updateConfig(){
            for(int i = 0;i < this.layoutModes.length;i++){
                if(this.layoutModes[i].getSelection()){
                    getConfig().setProperty(PropertyNames.LAYOUT_MODE,i + 1); 
                }
            }                   
            getConfig().setProperty(PropertyNames.SHOW_SCORE,this.scoreEnabled.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_MULTITRACK,this.multitrack.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_MIXER,this.mixer.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_TRANSPORT,this.transport.getSelection());
            getConfig().setProperty(PropertyNames.SHOW_FRETBOARD,this.fretBoard.getSelection());    
            
            getConfig().setProperty(PropertyNames.MAXIMIZED,this.maximized.getSelection());
            getConfig().setProperty(PropertyNames.WIDTH,this.width.getSelection());
            getConfig().setProperty(PropertyNames.HEIGHT,this.height.getSelection());
        }
        
    }    
    
    
    
    
    private class LanguageOption extends Option{
        private Button[] languages;
       
        
        public LanguageOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent,TuxGuitar.getProperty("settings.config.language"));  
        }
        
        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));	
    		getToolItem().setImage(SystemImages.OPTION_LANGUAGE);
    		getToolItem().addSelectionListener(this);
    		
    		Label title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.language.choose"));    		
    		
    		String currenLanguage = getConfig().getStringConfigValue(PropertyNames.LANGUAGE);
    		String[] availableLanguages = TuxGuitar.instance().getLanguageManager().getLanguages();
    		if(availableLanguages != null){
    			this.languages = new Button[availableLanguages.length];
    			for(int i = 0;i < this.languages.length;i++){
    				this.languages[i] = new Button(getComposite(),SWT.RADIO); 
    				this.languages[i].setData(availableLanguages[i]);
    				this.languages[i].setLayoutData(getTabbedData());
    				this.languages[i].setText(TuxGuitar.getProperty(availableLanguages[i]));	    		    
    				if(availableLanguages[i].equals(currenLanguage)){
    					this.languages[i].setSelection(true);
    				}
    			}
    		}
    		
        }                        
       
        public void updateConfig(){    		
            String selected = "";
    		for(int i = 0;i < this.languages.length;i++){
    		    if(this.languages[i].getSelection()){
    		        selected = (String)this.languages[i].getData();
    		    }
    		}
    		getConfig().setProperty(PropertyNames.LANGUAGE,selected);
        }
        
    }
    
    
    
    
    private class StylesOption extends Option{
    	private FontData defaultFontData;
    	private FontData noteFontData;
    	private FontData timeSignatureFontData;    	
    	private FontData printerDefaultFontData;
    	private FontData printerNoteFontData;
    	private FontData printerTimeSignatureFontData;    	    	
    	private RGB scoreNoteRGB;    	
    	private RGB tabNoteRGB;
    	private RGB playNoteRGB;
    	
        public StylesOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent,TuxGuitar.getProperty("settings.config.styles"));
            this.defaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(PropertyNames.FONT_DEFAULT);
            this.noteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(PropertyNames.FONT_NOTE);
            this.timeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(PropertyNames.FONT_TIME_SIGNATURE);            
            this.printerDefaultFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(PropertyNames.FONT_PRINTER_DEFAULT);
            this.printerNoteFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(PropertyNames.FONT_PRINTER_NOTE);
            this.printerTimeSignatureFontData = TuxGuitar.instance().getConfig().getFontDataConfigValue(PropertyNames.FONT_PRINTER_TIME_SIGNATURE);
            
            this.scoreNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(PropertyNames.COLOR_SCORE_NOTE);
            this.tabNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(PropertyNames.COLOR_TAB_NOTE);
            this.playNoteRGB = TuxGuitar.instance().getConfig().getRGBConfigValue(PropertyNames.COLOR_PLAY_NOTE);
            if(this.scoreNoteRGB == null){
            	this.scoreNoteRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getScoreNoteColor().getRGB();
            }
            if(this.tabNoteRGB == null){
            	this.tabNoteRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getTabNoteColor().getRGB();
            }
            if(this.playNoteRGB == null){
            	this.playNoteRGB  = TuxGuitar.instance().getTablatureEditor().getTablature().getPlayNoteColor().getRGB();
            }            
        }
        
        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.styles"));	
    		getToolItem().setImage(SystemImages.OPTION_STYLE);
    		getToolItem().addSelectionListener(this);
    		
    		Composite styles = new Composite(getComposite(),SWT.NONE);
    		styles.setLayout(new GridLayout(2,false));
    		
    		Label defaultFontLabel = new Label(styles,SWT.NONE);
    		defaultFontLabel.setText(TuxGuitar.getProperty("settings.config.styles.font.default"));    		
    		
    	    Button defaultFontButton = new Button(styles, SWT.PUSH);
    	    defaultFontButton.setLayoutData(makeGridData(80,25));
    	    defaultFontButton.setText(TuxGuitar.getProperty("choose"));
    	    defaultFontButton.addSelectionListener(new SelectionAdapter() {			
				public void widgetSelected(SelectionEvent arg0) {
					FontData[] datas = null;
					if(defaultFontData != null){
						Font font = new Font(dialog.getDisplay(),defaultFontData);
						datas = font.getFontData();
						font.dispose();
					}
					if(datas == null){
						datas = TuxGuitar.instance().getTablatureEditor().getTablature().getDefaultFont().getFontData();
					}					
					FontDialog fontDialog = new FontDialog(dialog);
					fontDialog.setFontList(datas);
					FontData data = fontDialog.open();
					if(data != null){
						defaultFontData = data;
					}
				}			
			});
    	    
    		Label noteFontLabel = new Label(styles,SWT.NONE);
    		noteFontLabel.setText(TuxGuitar.getProperty("settings.config.styles.font.note"));    		
    		
    	    Button noteFontButton = new Button(styles, SWT.PUSH);
    	    noteFontButton.setLayoutData(makeGridData(80,25));
    	    noteFontButton.setText(TuxGuitar.getProperty("choose"));
    	    noteFontButton.addSelectionListener(new SelectionAdapter() {			
				public void widgetSelected(SelectionEvent arg0) {
					FontData[] datas = null;
					if(noteFontData != null){
						Font font = new Font(dialog.getDisplay(),noteFontData);
						datas = font.getFontData();
						font.dispose();
					}
					if(datas == null){
						datas = TuxGuitar.instance().getTablatureEditor().getTablature().getNoteFont().getFontData();
					}						
					FontDialog fontDialog = new FontDialog(dialog);
					fontDialog.setFontList(datas);
					FontData data = fontDialog.open();
					if(data != null){
						noteFontData = data;
					}
				}			
			});
    	    
    	    
    		Label timeSignatureLabel = new Label(styles,SWT.NONE);
    		timeSignatureLabel.setText(TuxGuitar.getProperty("settings.config.styles.font.time-signature"));    		
    		
    	    Button timeSignatureButton = new Button(styles, SWT.PUSH);
    	    timeSignatureButton.setLayoutData(makeGridData(80,25));
    	    timeSignatureButton.setText(TuxGuitar.getProperty("choose"));
    	    timeSignatureButton.addSelectionListener(new SelectionAdapter() {			
				public void widgetSelected(SelectionEvent arg0) {
					FontData[] datas = null;
					if(timeSignatureFontData != null){
						Font font = new Font(dialog.getDisplay(),timeSignatureFontData);
						datas = font.getFontData();
						font.dispose();
					}
					if(datas == null){
						datas = TuxGuitar.instance().getTablatureEditor().getTablature().getTimeSignatureFont().getFontData();
					}						
					FontDialog fontDialog = new FontDialog(dialog);
					fontDialog.setFontList(datas);
					FontData data = fontDialog.open();
					if(data != null){
						timeSignatureFontData = data;
					}
				}			
			});     	    
 
    		Label printerDefaultFontLabel = new Label(styles,SWT.NONE);
    		printerDefaultFontLabel.setText(TuxGuitar.getProperty("settings.config.styles.font.printer-default"));        	    
    	    Button printerDefaultFontButton = new Button(styles, SWT.PUSH);
    	    printerDefaultFontButton.setLayoutData(makeGridData(80,25));
    	    printerDefaultFontButton.setText(TuxGuitar.getProperty("choose"));
    	    printerDefaultFontButton.addSelectionListener(new SelectionAdapter() {			
				public void widgetSelected(SelectionEvent arg0) {
					FontData[] datas = null;
					if(printerDefaultFontData != null){
						Font font = new Font(dialog.getDisplay(),printerDefaultFontData);
						datas = font.getFontData();
						font.dispose();
					}
					if(datas == null){
						datas = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterDefaultFont().getFontData();
					}					
					FontDialog fontDialog = new FontDialog(dialog);
					fontDialog.setFontList(datas);
					FontData data = fontDialog.open();
					if(data != null){
						printerDefaultFontData = data;
					}
				}			
			});
    	    
    		Label printerNoteFontLabel = new Label(styles,SWT.NONE);
    		printerNoteFontLabel.setText(TuxGuitar.getProperty("settings.config.styles.font.printer-note"));    		
    		
    	    Button printerNoteFontButton = new Button(styles, SWT.PUSH);
    	    printerNoteFontButton.setLayoutData(makeGridData(80,25));
    	    printerNoteFontButton.setText(TuxGuitar.getProperty("choose"));
    	    printerNoteFontButton.addSelectionListener(new SelectionAdapter() {			
				public void widgetSelected(SelectionEvent arg0) {
					FontData[] datas = null;
					if(printerNoteFontData != null){
						Font font = new Font(dialog.getDisplay(),printerNoteFontData);
						datas = font.getFontData();
						font.dispose();
					}
					if(datas == null){
						datas = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterNoteFont().getFontData();
					}						
					FontDialog fontDialog = new FontDialog(dialog);
					fontDialog.setFontList(datas);
					FontData data = fontDialog.open();
					if(data != null){
						printerNoteFontData = data;
					}
				}			
			});
    	    
    	    
    		Label printerTimeSignatureLabel = new Label(styles,SWT.NONE);
    		printerTimeSignatureLabel.setText(TuxGuitar.getProperty("settings.config.styles.font.printer-time-signature"));    		
    		
    	    Button printerTimeSignatureButton = new Button(styles, SWT.PUSH);
    	    printerTimeSignatureButton.setLayoutData(makeGridData(80,25));
    	    printerTimeSignatureButton.setText(TuxGuitar.getProperty("choose"));
    	    printerTimeSignatureButton.addSelectionListener(new SelectionAdapter() {			
				public void widgetSelected(SelectionEvent arg0) {
					FontData[] datas = null;
					if(printerTimeSignatureFontData != null){
						Font font = new Font(dialog.getDisplay(),printerTimeSignatureFontData);
						datas = font.getFontData();
						font.dispose();
					}
					if(datas == null){
						datas = TuxGuitar.instance().getTablatureEditor().getTablature().getPrinterTimeSignatureFont().getFontData();
					}						
					FontDialog fontDialog = new FontDialog(dialog);
					fontDialog.setFontList(datas);
					FontData data = fontDialog.open();
					if(data != null){
						printerTimeSignatureFontData = data;
					}
				}			
			});     
    	    
    	    
            Label scoreNoteColorLabel = new Label(styles, SWT.NONE);
            scoreNoteColorLabel.setText(TuxGuitar.getProperty("settings.config.styles.color.score-note"));
            final Button scoreNoteColorButton = new Button(styles, SWT.PUSH);
            scoreNoteColorButton.setLayoutData(makeGridData(80,25));
            setButtonColor(scoreNoteColorButton,this.scoreNoteRGB);
            scoreNoteColorButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    ColorDialog dlg = new ColorDialog(dialog);
                    dlg.setRGB(dialog.getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rgb = dlg.open();
                    if (rgb != null) {
                    	scoreNoteRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                        setButtonColor(scoreNoteColorButton,rgb);                        
                    }
                }
            });
            
    	    
            Label tabNoteColorLabel = new Label(styles, SWT.NONE);
            tabNoteColorLabel.setText(TuxGuitar.getProperty("settings.config.styles.color.tab-note"));
            final Button tabNoteColorButton = new Button(styles, SWT.PUSH);
            tabNoteColorButton.setLayoutData(makeGridData(80,25));
            setButtonColor(tabNoteColorButton,this.tabNoteRGB);
            tabNoteColorButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    ColorDialog dlg = new ColorDialog(dialog);
                    dlg.setRGB(dialog.getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rgb = dlg.open();
                    if (rgb != null) {
                    	tabNoteRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                        setButtonColor(tabNoteColorButton,rgb);                        
                    }
                }
            });       
            
            
    	    
            Label playNoteColorLabel = new Label(styles, SWT.NONE);
            playNoteColorLabel.setText(TuxGuitar.getProperty("settings.config.styles.color.play-note"));
            final Button playNoteColorButton = new Button(styles, SWT.PUSH);
            playNoteColorButton.setLayoutData(makeGridData(80,25));
            setButtonColor(playNoteColorButton, this.playNoteRGB);
            playNoteColorButton.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    ColorDialog dlg = new ColorDialog(dialog);
                    dlg.setRGB(dialog.getDisplay().getSystemColor(SWT.COLOR_BLACK).getRGB());
                    dlg.setText(TuxGuitar.getProperty("choose-color"));
                    RGB rgb = dlg.open();
                    if (rgb != null) {
                    	playNoteRGB = new RGB(rgb.red,rgb.green,rgb.blue);
                        setButtonColor(playNoteColorButton,rgb);                        
                    }
                }
            });            
        }                        
       
        private void setButtonColor(Button button,RGB rgb) {
        	Color color = new Color(dialog.getDisplay(),rgb);
            Image image = new Image(dialog.getDisplay(), 80, 15);
            GC gc = new GC(image);
            gc.setBackground(color);
            gc.fillRectangle(0, 0, 80, 15);        
            gc.dispose();
            button.setImage(image);
        }        
        
        public void updateConfig(){    		
            if(defaultFontData != null){
            	getConfig().setProperty(PropertyNames.FONT_DEFAULT,defaultFontData.getName() + "," + defaultFontData.getHeight()  + "," + defaultFontData.getStyle());
            }
            if(noteFontData != null){
            	getConfig().setProperty(PropertyNames.FONT_NOTE,noteFontData.getName() + "," + noteFontData.getHeight() + "," + noteFontData.getStyle());
            }
            if(timeSignatureFontData != null){
            	getConfig().setProperty(PropertyNames.FONT_TIME_SIGNATURE,timeSignatureFontData.getName() + "," + timeSignatureFontData.getHeight() + "," + timeSignatureFontData.getStyle());            	
            }   
            if(printerDefaultFontData != null){
            	getConfig().setProperty(PropertyNames.FONT_PRINTER_DEFAULT,printerDefaultFontData.getName() + "," + printerDefaultFontData.getHeight()  + "," + printerDefaultFontData.getStyle());
            }
            if(printerNoteFontData != null){
            	getConfig().setProperty(PropertyNames.FONT_PRINTER_NOTE,printerNoteFontData.getName() + "," + printerNoteFontData.getHeight() + "," + printerNoteFontData.getStyle());
            }
            if(printerTimeSignatureFontData != null){
            	getConfig().setProperty(PropertyNames.FONT_PRINTER_TIME_SIGNATURE,printerTimeSignatureFontData.getName() + "," + printerTimeSignatureFontData.getHeight() + "," + printerTimeSignatureFontData.getStyle());            	
            }               
            if(scoreNoteRGB != null){
            	getConfig().setProperty(PropertyNames.COLOR_SCORE_NOTE,scoreNoteRGB.red + "," + scoreNoteRGB.green + "," + scoreNoteRGB.blue);
            }
            if(tabNoteRGB != null){
            	getConfig().setProperty(PropertyNames.COLOR_TAB_NOTE,tabNoteRGB.red + "," + tabNoteRGB.green + "," + tabNoteRGB.blue);
            }
            if(playNoteRGB != null){
            	getConfig().setProperty(PropertyNames.COLOR_PLAY_NOTE,playNoteRGB.red + "," + playNoteRGB.green + "," + playNoteRGB.blue);
            }                        
        }
        
    }
    
    
    
    private class SoundOption extends Option{
    	private Button useDefaultSoundbank;
    	private Button useCustomSoundbank;
    	private Text fileText;
    	private Button fileButton;
    	
        public SoundOption(SystemConfigManager config,ToolBar toolBar,final Composite parent){
            super(config,toolBar,parent,TuxGuitar.getProperty("settings.config.sound"));
        }
        
        public void createOption(){		
    		getToolItem().setText(TuxGuitar.getProperty("settings.config.sound"));	
    		getToolItem().setImage(SystemImages.OPTION_SOUND);
    		getToolItem().addSelectionListener(this);
    		
    		Label title = new Label(getComposite(),SWT.NONE);
    		title.setText(TuxGuitar.getProperty("settings.config.sound.soundbank"));    		


    		useDefaultSoundbank = new Button(getComposite(),SWT.RADIO); 
    		useDefaultSoundbank.setLayoutData(getTabbedData());
    		useDefaultSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.default-soundbank"));	    		    
    		
    		useCustomSoundbank = new Button(getComposite(),SWT.RADIO); 
    		useCustomSoundbank.setLayoutData(getTabbedData());
    		useCustomSoundbank.setText(TuxGuitar.getProperty("settings.config.sound.custom-soundbank"));    		
    		    		
    		Composite chooser = new Composite(getComposite(),SWT.NONE);
    		chooser.setLayout(new GridLayout(2,false));
    		chooser.setLayoutData(getTabbedData(20));

    		fileText = new Text(chooser,SWT.BORDER);
    		fileText.setLayoutData(makeGridData(150,0,0,0));
    		
    		fileButton = new Button(chooser,SWT.PUSH);
    		fileButton.setLayoutData(makeGridData(80,25));
    		fileButton.setText(TuxGuitar.getProperty("choose"));
    		fileButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					String fileName = FileChooser.instance().open(dialog,FileChooser.ALL_FORMAT,null);
					if(fileName != null){
						fileText.setText(fileName);
						showRestartMessage();
					}
				}		
			});
    		
    		useDefaultSoundbank.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					if(useDefaultSoundbank.getSelection()){
						fileText.setEnabled(false);
						fileButton.setEnabled(false);					
						showRestartMessage();
					}
				}		
			});
    		useCustomSoundbank.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					if(useCustomSoundbank.getSelection()){
						fileText.setEnabled(true);
						fileButton.setEnabled(true);
					}
				}		
			});
    		
    		boolean useCustom = getConfig().getBooleanConfigValue(PropertyNames.SOUNDBANK_CUSTOM);
    		useDefaultSoundbank.setSelection(!useCustom);
    		useCustomSoundbank.setSelection(useCustom);
    		fileText.setEnabled(useCustom);
			fileButton.setEnabled(useCustom);
			if(useCustom){
				fileText.setText(getConfig().getStringConfigValue(PropertyNames.SOUNDBANK_CUSTOM_PATH));	
			}
        }                        
        
        
        private void showRestartMessage(){
    		String title = TuxGuitar.getProperty("warning");
    		String message = TuxGuitar.getProperty("settings.config.sound.soundbank-restart-message");
    		new MessageDialog(title,message,SWT.ICON_INFORMATION).show(dialog);
        }
        
        public void updateConfig(){
        	boolean useCustom = useCustomSoundbank.getSelection();
        	getConfig().setProperty(PropertyNames.SOUNDBANK_CUSTOM,useCustom);
        	if(useCustom){
        		getConfig().setProperty(PropertyNames.SOUNDBANK_CUSTOM_PATH,fileText.getText());	
        	}else{
        		getConfig().removeProperty(PropertyNames.SOUNDBANK_CUSTOM_PATH);
        	}
        }
       
    }
        
}
